/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.datasource.impl;

import com.artfess.base.datasource.DataSourceLoader;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.DataBaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DefaultDatabaseContext
implements DatabaseContext,
ContextThread {
    @Resource
    DynamicRoutingDataSource dynamicRoutingDataSource;
    @Resource
    DataSourceLoader dataSourceLoader;
    @Resource
    JdbcTemplate jdbcTemplate;
    private Map<Object, DbType> map = new ConcurrentHashMap<Object, DbType>();
    private ThreadLocal<DataSource> currentDatasource = new ThreadLocal();

    public void clear() {
        this.currentDatasource.remove();
    }

    public static boolean isLocalDataSource(String alias) {
        return "master".equalsIgnoreCase(alias) || "slave".equalsIgnoreCase(alias) || "LOCAL".equalsIgnoreCase(alias);
    }

    @Override
    public DatabaseSwitchResult setDataSource(String alias) {
        if (!DefaultDatabaseContext.isLocalDataSource(alias)) {
            MasterSlaveAutoRoutingPlugin.setInExternalDatasource();
        }
        MultiTenantHandler.setThreadLocalIgnore();
        String dbType = this.getDbTypeByAlias(alias);
        if (DefaultDatabaseContext.isLocalDataSource(alias)) {
            return new DatabaseSwitchResult("LOCAL", "LOCAL", dbType);
        }
        Assert.isTrue((boolean)StringUtil.isNotEmpty(alias), (String)"\u8981\u5207\u6362\u7684\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        DataSource datasource = this.getDataSourceByAlias(alias);
        String currentDsAlias = DynamicDataSourceContextHolder.peek();
        DynamicDataSourceContextHolder.push((String)alias);
        this.currentDatasource.set(datasource);
        this.jdbcTemplate.setDataSource(datasource);
        return new DatabaseSwitchResult(currentDsAlias, alias, dbType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSourceByAlias(String alias) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty(alias), (String)"\u6570\u636e\u6e90\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        if ("LOCAL".equalsIgnoreCase(alias)) {
            this.dynamicRoutingDataSource.setStrict(false);
        } else {
            this.dynamicRoutingDataSource.setStrict(true);
        }
        DataSource dataSource = null;
        try {
            dataSource = this.dynamicRoutingDataSource.getDataSource(alias);
        }
        catch (RuntimeException portalFeignService) {
        }
        finally {
            if (BeanUtils.isEmpty(dataSource)) {
                SystemConfigFeignService portalFeignService = AppUtil.getBean(SystemConfigFeignService.class);
                dataSource = this.getDsFromSysSource(portalFeignService.getBeanByAlias(alias));
                this.dynamicRoutingDataSource.addDataSource(alias, dataSource);
            }
        }
        return dataSource;
    }

    public DataSource getDsFromSysSource(JsonNode sysDataSource) {
        try {
            Class<?> _class = null;
            _class = Class.forName(sysDataSource.get("classPath").asText());
            DataSource sqldataSource = null;
            sqldataSource = (DataSource)_class.newInstance();
            String settingJson = sysDataSource.get("settingJson").asText();
            ArrayNode arrayNode = (ArrayNode)JsonUtil.toJsonNode(settingJson);
            for (int i = 0; i < arrayNode.size(); ++i) {
                ObjectNode jo = (ObjectNode)arrayNode.get(i);
                Object value = BeanUtils.convertByActType(JsonUtil.getString((JsonNode)jo, "type"), JsonUtil.getString((JsonNode)jo, "value"));
                BeanUtils.setProperty(sqldataSource, JsonUtil.getString((JsonNode)jo, "name"), value);
            }
            String initMethodStr = sysDataSource.get("initMethod").asText();
            if (!StringUtil.isEmpty(initMethodStr)) {
                Method method = _class.getMethod(initMethodStr, new Class[0]);
                method.invoke((Object)sqldataSource, new Object[0]);
            }
            return sqldataSource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public DataSource getDataSource() {
        DataSource dataSource = this.currentDatasource.get();
        if (dataSource == null) {
            return this.dynamicRoutingDataSource.determineDataSource();
        }
        return dataSource;
    }

    @Override
    public String getDbType() {
        return this.getDbTypeObj().getDb();
    }

    @Override
    public DbType getDbTypeObj() {
        DataSource dataSource = this.getDataSource();
        return this.getDbTypeObj(dataSource);
    }

    @Override
    public String getDbTypeByAlias(String alias) {
        DataSource dataSourceByAlias = this.getDataSourceByAlias(alias);
        return this.getDbTypeObj(dataSourceByAlias).getDb();
    }

    public DbType getDbTypeObj(DataSource dataSource) {
        DbType type = this.map.get(dataSource);
        if (BeanUtils.isEmpty(type)) {
            try {
                Connection con = DataSourceUtils.getConnection((DataSource)dataSource);
                type = JdbcUtils.getDbType((String)con.getMetaData().getURL());
                this.map.put(dataSource, type);
            }
            catch (Exception e) {
                throw new DataBaseException("\u83b7\u53d6\u5f53\u524d\u6570\u636e\u6e90\u5f02\u5e38");
            }
        }
        return type;
    }

    @Override
    public void cleanAll() {
        this.clear();
    }
}

