/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.xqxt.meeting.dao.MeetingUserDao;
import com.artfess.xqxt.meeting.manager.BizMeetingAccessoryManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.model.BizMeetingAccessory;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.utils.SortList;
import com.artfess.xqxt.meeting.vo.FeedBackCountVo;
import com.artfess.xqxt.meeting.vo.MeetFeedBackVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MeetingUserManagerImpl
extends BaseManagerImpl<MeetingUserDao, MeetingUser>
implements MeetingUserManager {
    @Resource
    private MeetingManager meetingManager;
    @Resource
    private BizMeetingAccessoryManager meetingAccessoryManager;
    @Resource
    private MeetingUserDao meetingUserDao;

    @Override
    public PageList<MeetingUser> findList(QueryFilter<MeetingUser> queryFilter) {
        String meetingId = null;
        List queryFilters = queryFilter.getQuerys();
        for (QueryField field : queryFilters) {
            if (!"meetingId".equals(field.getProperty())) continue;
            meetingId = field.getValue().toString();
        }
        if (StringUtils.isEmpty(meetingId)) {
            return null;
        }
        PageList list = this.query(queryFilter);
        List listRows = list.getRows();
        if (null != listRows && listRows.size() > 0) {
            for (MeetingUser user : list.getRows()) {
                if (StringUtil.isNotEmpty((String)user.getUserId())) {
                    String currentDeptId = ContextUtil.getCurrentDeptId((String)user.getUserId());
                    if (StringUtil.isNotEmpty((String)currentDeptId)) {
                        user.setDeptId(currentDeptId);
                        user.setDeptName(ContextUtil.getCurrentDeptName((String)user.getUserId()));
                    } else {
                        user.setDeptId(ContextUtil.getCurrentOrgId((String)user.getUserId()));
                        user.setDeptName(ContextUtil.getCurrentOrgName((String)user.getUserId()));
                    }
                }
                QueryWrapper accessoryQueryWrapper = new QueryWrapper();
                accessoryQueryWrapper.eq((Object)"IS_DELE_", (Object)"0");
                accessoryQueryWrapper.eq((Object)"SOURCE_ID_", (Object)user.getId());
                List bizMeetingAccessories = this.meetingAccessoryManager.list((Wrapper)accessoryQueryWrapper);
                ArrayList<BizMeetingAccessory> fileList = new ArrayList<BizMeetingAccessory>();
                ArrayList<BizMeetingAccessory> imageList = new ArrayList<BizMeetingAccessory>();
                for (BizMeetingAccessory file : bizMeetingAccessories) {
                    String type = file.getSuffix();
                    if ("bmp".equals(type) || "jpg".equals(type) || "png".equals(type)) {
                        file.setUrl("/image" + file.getUrl().substring(file.getUrl().indexOf("ava/file/") + 8));
                        imageList.add(file);
                        continue;
                    }
                    fileList.add(file);
                }
                user.setFileList(fileList);
                user.setImageList(imageList);
            }
            SortList sortList = new SortList();
            sortList.Sort(listRows, "getDeptId", "asc");
        }
        return list;
    }

    @Override
    public void feedBack(MeetFeedBackVO meetFeedBackVO) {
        User currentUser = ContextUtil.getCurrentUser();
        String meetingId = meetFeedBackVO.getMeetingId();
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        String userId = currentUser.getId();
        if (StringUtil.isNotEmpty((String)meetFeedBackVO.getUserId())) {
            userId = meetFeedBackVO.getUserId();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId)).eq((Object)"USER_ID_", (Object)userId);
        List list = this.list((Wrapper)queryWrapper);
        if (null == list || list.size() == 0) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u60a8\u53c2\u52a0\u8be5\u4f1a\u8bae\uff0c\u65e0\u9700\u53cd\u9988\uff01");
        }
        for (MeetingUser meetingUser : list) {
            List<String> accessoryIds;
            meetingUser.setFeedBack(meetFeedBackVO.getFeedBack());
            meetingUser.setFeedBackStatus("0");
            meetingUser.setFeedBackDate(LocalDateTime.now());
            if (null != meetFeedBackVO.getEstimatedArrivalDate()) {
                meetingUser.setEstimatedArrivalDate(meetFeedBackVO.getEstimatedArrivalDate());
                Meeting meeting = (Meeting)this.meetingManager.get((Serializable)((Object)meetingId));
                if (null != meeting && meeting.getStartTime() != null) {
                    Duration duration = Duration.between(meeting.getStartTime(), meetFeedBackVO.getEstimatedArrivalDate());
                    long minutes = duration.toMinutes();
                    meetingUser.setEstimatedArrivalTime(minutes);
                }
            }
            if (!"1".equals(meetFeedBackVO.getFeedBack())) {
                meetingUser.setNotJoiningReasons(meetFeedBackVO.getNotJoiningReasons());
                accessoryIds = meetFeedBackVO.getAccessoryIds();
                if (null == accessoryIds || accessoryIds.size() <= 0) continue;
                QueryWrapper oldAccessoryQueryWrapper = new QueryWrapper();
                oldAccessoryQueryWrapper.eq((Object)"SOURCE_ID_", (Object)meetingUser.getId());
                List oldBizMeetingAccessories = this.meetingAccessoryManager.list((Wrapper)oldAccessoryQueryWrapper);
                if (null != oldBizMeetingAccessories && oldBizMeetingAccessories.size() > 0) {
                    for (BizMeetingAccessory bizMeetingAccessory : oldBizMeetingAccessories) {
                        bizMeetingAccessory.setIsDele("1");
                    }
                    this.meetingAccessoryManager.updateBatchById(oldBizMeetingAccessories);
                }
                QueryWrapper accessoryQueryWrapper = new QueryWrapper();
                accessoryQueryWrapper.in((Object)"ID_", accessoryIds);
                List bizMeetingAccessories = this.meetingAccessoryManager.list((Wrapper)accessoryQueryWrapper);
                if (null == bizMeetingAccessories || bizMeetingAccessories.size() <= 0) continue;
                for (BizMeetingAccessory bizMeetingAccessory : bizMeetingAccessories) {
                    bizMeetingAccessory.setSourceId(meetingUser.getId());
                    bizMeetingAccessory.setIsDele("0");
                }
                this.meetingAccessoryManager.updateBatchById(bizMeetingAccessories);
                continue;
            }
            meetingUser.setNotJoiningReasons("");
            meetingUser.setEstimatedArrivalDate(null);
            meetingUser.setEstimatedArrivalTime(null);
            accessoryIds = meetFeedBackVO.getAccessoryIds();
            QueryWrapper accessoryQueryWrapper = new QueryWrapper();
            accessoryQueryWrapper.eq((Object)"SOURCE_ID_", (Object)meetingUser.getId());
            this.meetingAccessoryManager.remove((Wrapper)accessoryQueryWrapper);
        }
        this.updateBatchById(list);
    }

    @Override
    public FeedBackCountVo feedBackCount(String meetingId) {
        FeedBackCountVo vo = new FeedBackCountVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        vo.setTotal(this.count((Wrapper)queryWrapper));
        queryWrapper.eq((Object)"FEED_BACK_STATUS_", (Object)"0");
        vo.setFeedBacked(this.count((Wrapper)queryWrapper));
        queryWrapper.eq((Object)"FEED_BACK_", (Object)"1");
        vo.setSignMeeting(this.count((Wrapper)queryWrapper));
        queryWrapper.clear();
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        queryWrapper.eq((Object)"FEED_BACK_STATUS_", (Object)"0");
        queryWrapper.eq((Object)"FEED_BACK_", (Object)"2");
        vo.setDelaySignMeeting(this.count((Wrapper)queryWrapper));
        queryWrapper.clear();
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        queryWrapper.eq((Object)"FEED_BACK_STATUS_", (Object)"0");
        queryWrapper.eq((Object)"FEED_BACK_", (Object)"3");
        vo.setUnSignMeeting(this.count((Wrapper)queryWrapper));
        queryWrapper.clear();
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"MEETING_ID_", (Object)meetingId);
        queryWrapper.eq((Object)"FEED_BACK_STATUS_", (Object)"1");
        vo.setUnFeedBacked(this.count((Wrapper)queryWrapper));
        return vo;
    }
}

