/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.exception.BaseException;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.bean.ConfNode;
import com.artfess.xqxt.meeting.m900.bean.ConferenceSimpleInfo;
import com.artfess.xqxt.meeting.m900.bean.ConferenceStatus;
import com.artfess.xqxt.meeting.m900.bean.Participant;
import com.artfess.xqxt.meeting.m900.bean.ParticipantStatusV2;
import com.artfess.xqxt.meeting.m900.bean.RecordParam;
import com.artfess.xqxt.meeting.m900.bean.TerminalSimpleInfo;
import com.artfess.xqxt.meeting.m900.bean.TerminalStatus;
import com.artfess.xqxt.meeting.m900.request.BoardcastParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.BrowseParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.CancelConferenceReservedRequest;
import com.artfess.xqxt.meeting.m900.request.CancelMuteParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.CancelQuietParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.ConnectParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.CreateConferenceRequest;
import com.artfess.xqxt.meeting.m900.request.DeleteParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.DisconnectParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.EndConferenceRequest;
import com.artfess.xqxt.meeting.m900.request.GetAddressBookRequest;
import com.artfess.xqxt.meeting.m900.request.GetConfNodeListRequest;
import com.artfess.xqxt.meeting.m900.request.GetConferenceInfoListRequest;
import com.artfess.xqxt.meeting.m900.request.GetConferenceReservedListRequest;
import com.artfess.xqxt.meeting.m900.request.GetConferenceStatusRequest;
import com.artfess.xqxt.meeting.m900.request.GetHistoryConferenceListRequest;
import com.artfess.xqxt.meeting.m900.request.GetParticipantStatusV2Request;
import com.artfess.xqxt.meeting.m900.request.GetTerListRequest;
import com.artfess.xqxt.meeting.m900.request.InviteParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.LoginRequest;
import com.artfess.xqxt.meeting.m900.request.MuteParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.ProlongConferenceRequest;
import com.artfess.xqxt.meeting.m900.request.QuietParticipantRequest;
import com.artfess.xqxt.meeting.m900.request.SetChairmanParticipantRequest;
import com.artfess.xqxt.meeting.m900.response.BoardcastParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.BrowseParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.CancelConferenceReservedResponse;
import com.artfess.xqxt.meeting.m900.response.CancelMuteParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.CancelQuietParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.ConferenceResponse;
import com.artfess.xqxt.meeting.m900.response.ConnectParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.CreateConferenceResponse;
import com.artfess.xqxt.meeting.m900.response.DeleteParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.DisconnectParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.EndConferenceResponse;
import com.artfess.xqxt.meeting.m900.response.GetAddressBookResponse;
import com.artfess.xqxt.meeting.m900.response.GetConfNodeListResponse;
import com.artfess.xqxt.meeting.m900.response.GetConferenceInfoListResponse;
import com.artfess.xqxt.meeting.m900.response.GetConferenceReservedListResponse;
import com.artfess.xqxt.meeting.m900.response.GetConferenceStatusResponse;
import com.artfess.xqxt.meeting.m900.response.GetHistoryConferenceListResponse;
import com.artfess.xqxt.meeting.m900.response.GetParticipantStatusV2Response;
import com.artfess.xqxt.meeting.m900.response.GetTerminalListResponse;
import com.artfess.xqxt.meeting.m900.response.InviteParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.LoginResponse;
import com.artfess.xqxt.meeting.m900.response.MuteParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.ProlongConferenceResponse;
import com.artfess.xqxt.meeting.m900.response.QuietParticipantResponse;
import com.artfess.xqxt.meeting.m900.response.SetChairmanParticipantResponse;
import com.artfess.xqxt.meeting.manager.BizSiteParamExManager;
import com.artfess.xqxt.meeting.manager.BizTerminalManager;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.BizSiteParamEx;
import com.artfess.xqxt.meeting.model.BizTerminal;
import com.artfess.xqxt.meeting.model.ZTEErrorCode;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.HistoryConferenceVO;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import com.artfess.xqxt.meeting.zteService.MultimediaConferenceServiceLocator;
import com.artfess.xqxt.meeting.zteService.MultimediaConferenceSoapBindingStub;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeaderElement;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ZTEManagerImpl
implements ZTEManager {
    @Value(value="${zte.userName}")
    private String userName;
    @Value(value="${zte.password}")
    private String password;
    @Value(value="${zte.url}")
    private String url;
    @Resource
    private BizSiteParamExManager siteParamExManager;
    @Resource
    private BizTerminalManager terminalManager;
    @Resource
    private BizSiteParamExManager bizSiteParamExManager;
    @Resource
    private MeetingManager meetingManager;

    @Override
    public CreateConferenceResponse sendMeeting(MeetingDTO dto) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            CreateConferenceRequest request = new CreateConferenceRequest();
            request.setConferenceName(dto.getTheme());
            long minutes = 0L;
            if (null != dto.getStartTime()) {
                Duration duration = Duration.between(LocalDateTime.now(), dto.getStartTime());
                minutes = duration.toMinutes();
                if (minutes > 5L) {
                    request.setStartTime(GregorianCalendar.from(ZonedDateTime.of(dto.getStartTime(), ZoneId.systemDefault())));
                }
            } else {
                dto.setStartTime(LocalDateTime.now());
            }
            request.setAccount(this.userName);
            Duration dur = Duration.between(dto.getStartTime(), dto.getEndTime());
            int duration = 0;
            if (minutes <= 5L && minutes > 0L) {
                duration = (int)(dur.toMinutes() + minutes);
            }
            request.setDuration(duration);
            int multiViewNumber = dto.getPlaces().size();
            if (multiViewNumber > 8) {
                multiViewNumber = 8;
            }
            request.setMultiViewNumber(multiViewNumber);
            request.setMultiPicControl("manual");
            request.setMaxParticipants(10000);
            request.setInviteWithSDP(1);
            RecordParam recordParam = new RecordParam();
            recordParam.setIfRecord(true);
            recordParam.setIfLive(true);
            request.setRecord(recordParam);
            Participant[] participants = new Participant[dto.getPlaces().size()];
            for (int i = 0; i < dto.getPlaces().size(); ++i) {
                Participant participant = new Participant();
                BeanUtils.copyProperties((Object)((Object)dto.getPlaces().get(i)), (Object)participant);
                participants[i] = participant;
            }
            request.setParticipants(participants);
            CreateConferenceResponse response = mStub.createConference(request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getToken() {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            header.addChild(element);
            mStub.clearHeaders();
            mStub.setHeader(header);
            LoginRequest request = new LoginRequest();
            request.setUserName(this.userName);
            request.setPassword(EncryptUtil.encryptMd5Hash((String)this.password));
            LoginResponse response = mStub.login(request);
            String token = EncryptUtil.encryptMd5Hash((String)(this.password + response.getRandomKey())).toLowerCase();
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getAddresBook() {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetAddressBookRequest request = new GetAddressBookRequest();
            request.setAccount(this.userName);
            request.setPage(1);
            request.setNumPerPage(100);
            GetAddressBookResponse response = mStub.getAddressBook(request);
            if ("200".equals(response.getResult())) {
                TerminalSimpleInfo[] reList;
                for (TerminalSimpleInfo info : reList = response.getTerminalInfo()) {
                    BizTerminal bizTerminal = new BizTerminal();
                    BeanUtils.copyProperties((Object)info, (Object)((Object)bizTerminal));
                    QueryWrapper queryWrapper = new QueryWrapper();
                    bizTerminal.setTerType(String.valueOf(info.getTerType()));
                    bizTerminal.setTerminalId(String.valueOf(info.getTerminalId()));
                    bizTerminal.setCallMode(String.valueOf(info.getCallMode()));
                    queryWrapper.eq((Object)"TERMINAL_ID_", (Object)bizTerminal.getTerminalId());
                    List bizTerminalList = this.terminalManager.list((Wrapper)queryWrapper);
                    if (null != bizTerminalList && bizTerminalList.size() > 0) {
                        BizTerminal old = (BizTerminal)((Object)bizTerminalList.get(0));
                        QueryWrapper bizSiteQueryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"TERMINAL_ID_", (Object)bizTerminal.getTerminalId());
                        bizTerminal.setId(old.getId());
                        BeanUtils.copyProperties((Object)((Object)bizTerminal), (Object)((Object)old));
                        List bizSiteParamExList = this.bizSiteParamExManager.list((Wrapper)bizSiteQueryWrapper);
                        if (null != bizSiteParamExList && bizSiteParamExList.size() > 0) {
                            BizSiteParamEx bizSiteParamEx = (BizSiteParamEx)((Object)bizSiteParamExList.get(0));
                            BeanUtils.copyProperties((Object)((Object)bizTerminal), (Object)((Object)bizSiteParamEx));
                            bizSiteParamEx.setName(bizTerminal.getTerminalName());
                            bizSiteParamEx.setIpAddress(bizTerminal.getIpAddress());
                            bizSiteParamEx.setRate(bizTerminal.getRate());
                            bizSiteParamEx.setUri(bizTerminal.getTerminalNumber());
                            bizSiteParamEx.setRegPassword(bizTerminal.getPassword());
                            bizSiteParamEx.setRegUser(bizTerminal.getContactName());
                            bizSiteParamEx.setTenantId("-1");
                            this.bizSiteParamExManager.update((Model)bizSiteParamEx);
                        }
                        old.setTenantId("-1");
                        old.setIsDele("0");
                        this.terminalManager.update((Model)old);
                        continue;
                    }
                    this.terminalManager.create((Model)bizTerminal);
                    BizSiteParamEx bizSiteParamEx = new BizSiteParamEx();
                    BeanUtils.copyProperties((Object)((Object)bizTerminal), (Object)((Object)bizSiteParamEx));
                    bizSiteParamEx.setName(bizTerminal.getTerminalName());
                    bizSiteParamEx.setType("2");
                    bizSiteParamEx.setGroupId("1");
                    bizSiteParamEx.setIpAddress(bizTerminal.getIpAddress());
                    bizSiteParamEx.setRate(bizTerminal.getRate());
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("type", "2");
                    Integer nextSequence = this.siteParamExManager.getNextSequence(map);
                    bizSiteParamEx.setSequence(nextSequence);
                    bizSiteParamEx.setUri(bizTerminal.getTerminalNumber());
                    bizSiteParamEx.setRegPassword(bizTerminal.getPassword());
                    bizSiteParamEx.setRegUser(bizTerminal.getContactName());
                    this.bizSiteParamExManager.create((Model)bizSiteParamEx);
                }
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "500";
        }
    }

    @Override
    @Transactional
    public void getTerList() {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetTerListRequest request = new GetTerListRequest();
            GetTerminalListResponse response = mStub.getTerList(request);
            if ("200".equals(response.getResult())) {
                TerminalStatus[] reList;
                for (TerminalStatus terminalStatus : reList = response.getTerminalInfo()) {
                    BizTerminal bizTerminal = new BizTerminal();
                    BeanUtils.copyProperties((Object)terminalStatus, (Object)((Object)bizTerminal));
                    QueryWrapper queryWrapper = new QueryWrapper();
                    if (this.terminalManager.getOne((Wrapper)queryWrapper) != null) continue;
                    this.terminalManager.create((Model)bizTerminal);
                    BizSiteParamEx bizSiteParamEx = new BizSiteParamEx();
                    bizSiteParamEx.setName(bizTerminal.getTerminalName());
                    bizSiteParamEx.setDeviceStatusId(bizTerminal.getId());
                    bizSiteParamEx.setType("2");
                    bizSiteParamEx.setGroupId("1");
                    this.bizSiteParamExManager.create((Model)bizSiteParamEx);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public GetConferenceStatusResponse updateMeeting(String id) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetConferenceStatusRequest request = new GetConferenceStatusRequest();
            request.setConferenceIdentifier(id);
            GetConferenceStatusResponse response = mStub.getConferenceStatus(request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String endMeeting(String id) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            EndConferenceRequest request = new EndConferenceRequest();
            request.setConferenceIdentifier(id);
            EndConferenceResponse response = mStub.endConference(request);
            if ("200".equals(response.getResult())) {
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String quiet(String id, String terId, boolean isSleep) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            QuietParticipantRequest request = new QuietParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(terId);
            QuietParticipantResponse response = mStub.quietParticipant(request);
            if ("200".equals(response.getResult())) {
                if (isSleep) {
                    Thread.sleep(2000L);
                }
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String cancelQuiet(String id, String terId, boolean isSleep) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            CancelQuietParticipantRequest request = new CancelQuietParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(terId);
            CancelQuietParticipantResponse response = mStub.cancelQuietParticipant(request);
            if ("200".equals(response.getResult())) {
                if (isSleep) {
                    Thread.sleep(2000L);
                }
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String connect(String id, String[] terIds, boolean isSleep) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            ConnectParticipantRequest request = new ConnectParticipantRequest();
            request.setConferenceIdentifier(id);
            if (null != terIds && terIds.length > 0) {
                request.setTerminalIdentifier(terIds);
            } else {
                request.setTerminalIdentifier(new String[0]);
            }
            ConnectParticipantResponse response = mStub.connectParticipant(request);
            if ("200".equals(response.getResult())) {
                if (isSleep) {
                    Thread.sleep(3000L);
                }
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String disconnect(String id, String[] terIds) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            DisconnectParticipantRequest request = new DisconnectParticipantRequest();
            request.setConferenceIdentifier(id);
            if (null != terIds && terIds.length > 0) {
                request.setTerminalIdentifier(terIds);
            } else {
                request.setTerminalIdentifier(new String[0]);
            }
            DisconnectParticipantResponse response = mStub.disconnectParticipant(request);
            if ("200".equals(response.getResult())) {
                Thread.sleep(3000L);
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public ParticipantStatusV2[] participantStatusV2(String id) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetParticipantStatusV2Request request = new GetParticipantStatusV2Request();
            request.setConferenceIdentifier(id);
            GetParticipantStatusV2Response response = mStub.getParticipantStatusV2(request);
            if ("200".equals(response.getResult())) {
                return response.getParticipantStatusV2();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    @Override
    public String inviteParticipant(String id, Participant participant) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            InviteParticipantRequest request = new InviteParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setParticipant(participant);
            InviteParticipantResponse response = mStub.inviteParticipant(request);
            if ("200".equals(response.getResult())) {
                Thread.sleep(3000L);
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String setChairman(String id, String placeId) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            SetChairmanParticipantRequest request = new SetChairmanParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(placeId);
            SetChairmanParticipantResponse response = mStub.setChairmanParticipant(request);
            if ("200".equals(response.getResult())) {
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String boardcastParticipant(String id, String placeId) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            BoardcastParticipantRequest request = new BoardcastParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(placeId);
            BoardcastParticipantResponse response = mStub.boardcastParticipant(request);
            if ("200".equals(response.getResult())) {
                Thread.sleep(1000L);
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String browseParticipant(String id, String terminalIdentifier, Integer cmdType) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            BrowseParticipantRequest request = new BrowseParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setBrowseType(1);
            request.setCmdType(cmdType);
            request.setTimeInterval(6);
            if (StringUtil.isNotEmpty((String)terminalIdentifier)) {
                request.setTerminalIdentifier(terminalIdentifier.split(","));
            } else {
                request.setTerminalIdentifier(new String[0]);
            }
            BrowseParticipantResponse response = mStub.browseParticipant(request);
            if ("200".equals(response.getResult())) {
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public List<BizSiteParamExVO> getParticipantStatusV2(String meetingId, String[] terminalIdentifiers) throws Exception {
        ArrayList<BizSiteParamExVO> resultList = new ArrayList<BizSiteParamExVO>();
        MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
        mLocator.setMultimediaConferenceEndpointAddress(this.url);
        MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
        SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
        MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
        MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
        header.addChild(tokenElement);
        header.addChild(element);
        mStub.setHeader(header);
        GetParticipantStatusV2Request request = new GetParticipantStatusV2Request();
        request.setConferenceIdentifier(meetingId);
        if (null != terminalIdentifiers && terminalIdentifiers.length > 0) {
            request.setTerminalIdentifier(terminalIdentifiers);
        } else {
            request.setTerminalIdentifier(new String[0]);
        }
        GetParticipantStatusV2Response response = mStub.getParticipantStatusV2(request);
        if ("200".equals(response.getResult())) {
            ParticipantStatusV2[] reList = response.getParticipantStatusV2();
            if (null != reList && reList.length > 0) {
                for (ParticipantStatusV2 info : reList) {
                    BizSiteParamExVO bizSiteParamExVO = new BizSiteParamExVO();
                    BizSiteParamEx bizSiteParamEx = new BizSiteParamEx();
                    BeanUtils.copyProperties((Object)info, (Object)((Object)bizSiteParamEx));
                    BeanUtils.copyProperties((Object)((Object)bizSiteParamEx), (Object)bizSiteParamExVO);
                    QueryWrapper bizSiteQueryWrapper = new QueryWrapper();
                    bizSiteQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)info.getTerminalIdentifier());
                    List bizSiteParamExList = this.bizSiteParamExManager.list((Wrapper)bizSiteQueryWrapper);
                    if (null != bizSiteParamExList && bizSiteParamExList.size() > 0) {
                        bizSiteParamEx = (BizSiteParamEx)((Object)bizSiteParamExList.get(0));
                    }
                    BeanUtils.copyProperties((Object)info, (Object)((Object)bizSiteParamEx));
                    BizTerminal bizTerminal = new BizTerminal();
                    QueryWrapper terminalQueryWrapper = new QueryWrapper();
                    terminalQueryWrapper.eq((Object)"TERMINAL_ID_", (Object)info.getTerminalIdentifier());
                    List bizTerminalList = this.terminalManager.list((Wrapper)terminalQueryWrapper);
                    if (null != bizTerminalList && bizTerminalList.size() > 0) {
                        bizTerminal = (BizTerminal)((Object)bizTerminalList.get(0));
                    }
                    BeanUtils.copyProperties((Object)info, (Object)((Object)bizTerminal));
                    bizSiteParamExVO.setBizTerminal(bizTerminal);
                    resultList.add(bizSiteParamExVO);
                }
                Comparator<BizSiteParamExVO> comparator = new Comparator<BizSiteParamExVO>(){

                    @Override
                    public int compare(BizSiteParamExVO conferenceStatus01, BizSiteParamExVO conferenceStatus02) {
                        return conferenceStatus01.getStatus().compareTo(conferenceStatus02.getStatus());
                    }
                };
                Collections.sort(resultList, comparator);
            }
        } else {
            throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
        }
        return resultList;
    }

    @Override
    public MeetingVO getConferenceStatus(String meetintId) throws Exception {
        MeetingVO meetingVO = this.meetingManager.findById(meetintId);
        return this.getConferenceStatus(meetingVO);
    }

    @Override
    public MeetingVO getConferenceStatus(MeetingVO meetingVO) throws Exception {
        if (null == meetingVO || StringUtil.isEmpty((String)meetingVO.getId())) {
            return null;
        }
        String meetintId = meetingVO.getId();
        MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
        mLocator.setMultimediaConferenceEndpointAddress(this.url);
        MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
        SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
        MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
        MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
        header.addChild(tokenElement);
        header.addChild(element);
        mStub.setHeader(header);
        GetConferenceStatusRequest request = new GetConferenceStatusRequest();
        request.setConferenceIdentifier(meetintId);
        GetConferenceStatusResponse response = mStub.getConferenceStatus(request);
        if (!"200".equals(response.getResult())) {
            if (ZTEErrorCode.E15.getCode().equalsIgnoreCase(response.getResult()) || ZTEErrorCode.E116.getCode().equalsIgnoreCase(response.getResult())) {
                this.meetingManager.updateStatus(meetintId, 3);
            }
            throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
        }
        ConferenceStatus conferenceInfo = response.getConferenceInfo();
        BeanUtils.copyProperties((Object)conferenceInfo, (Object)((Object)meetingVO));
        meetingVO.setId(conferenceInfo.getConferenceIdentifier());
        meetingVO.setDuration(conferenceInfo.getDuration());
        meetingVO.setPassword(conferenceInfo.getConferencePassword());
        meetingVO.setTheme(conferenceInfo.getConferenceName());
        meetingVO.setConferenceNumber(conferenceInfo.getConferenceNumber());
        meetingVO.setIfRecord(conferenceInfo.isIfRecord());
        meetingVO.setRecordState(conferenceInfo.getRecordState());
        meetingVO.setLockState(conferenceInfo.isLockState());
        meetingVO.setConfCtrlMode(conferenceInfo.getConfCtrlMode());
        meetingVO.setBoardcaster(conferenceInfo.getBoardcaster());
        meetingVO.setDualBoardcaster(conferenceInfo.getDualBoardcaster());
        meetingVO.setChairman(conferenceInfo.getChairman());
        meetingVO.setIfUpMode(conferenceInfo.getIfUpMode());
        meetingVO.setMultiPicCtrlMode(conferenceInfo.getMultiPicCtrlMode());
        meetingVO.setMaxPicNum(conferenceInfo.getMaxPicNum());
        meetingVO.setCurPicNum(conferenceInfo.getCurPicNum());
        return meetingVO;
    }

    @Override
    public String muteParticipant(String id, String terId, boolean isSleep) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            MuteParticipantRequest request = new MuteParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(terId);
            MuteParticipantResponse response = mStub.muteParticipant(request);
            if ("200".equals(response.getResult())) {
                if (isSleep) {
                    Thread.sleep(2000L);
                }
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String cancelMuteParticipant(String id, String terId, boolean isSleep) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            CancelMuteParticipantRequest request = new CancelMuteParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(terId);
            CancelMuteParticipantResponse response = mStub.cancelMuteParticipant(request);
            if ("200".equals(response.getResult())) {
                if (isSleep) {
                    Thread.sleep(2000L);
                }
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String cancelConferenceReserved(String meetingId) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            CancelConferenceReservedRequest request = new CancelConferenceReservedRequest();
            request.setConferenceIdentifier(meetingId);
            CancelConferenceReservedResponse response = mStub.cancelConferenceReserved(request);
            if ("200".equals(response.getResult())) {
                Thread.sleep(2000L);
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public String deleteParticipant(String id, String placeId) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            DeleteParticipantRequest request = new DeleteParticipantRequest();
            request.setConferenceIdentifier(id);
            request.setTerminalIdentifier(placeId.split(","));
            DeleteParticipantResponse response = mStub.deleteParticipant(request);
            if ("200".equals(response.getResult())) {
                Thread.sleep(1000L);
                return "1";
            }
            return response.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    public List<ConferenceStatus> getConferenceInfoList() {
        ConferenceResponse response = null;
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetConferenceInfoListRequest request = new GetConferenceInfoListRequest();
            request.setAccount(this.userName);
            response = mStub.getConferenceInfoList(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return null;
        }
        if ("200".equals(response.getResult())) {
            ConferenceStatus[] data = ((GetConferenceInfoListResponse)response).getConferenceList();
            ArrayList<ConferenceStatus> conferenceInfoList = new ArrayList<ConferenceStatus>(data.length);
            Collections.addAll(conferenceInfoList, data);
            return conferenceInfoList;
        }
        throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
    }

    @Override
    public List<ConferenceSimpleInfo> getConferenceReservedList() {
        ConferenceResponse response = null;
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetConferenceReservedListRequest request = new GetConferenceReservedListRequest();
            request.setAccount(this.userName);
            response = mStub.getConferenceReservedList(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return null;
        }
        if ("200".equals(response.getResult())) {
            ConferenceSimpleInfo[] data = ((GetConferenceReservedListResponse)response).getConferenceList();
            ArrayList<ConferenceSimpleInfo> conferenceSimpleInfoList = new ArrayList<ConferenceSimpleInfo>(data.length);
            Collections.addAll(conferenceSimpleInfoList, data);
            return conferenceSimpleInfoList;
        }
        throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
    }

    @Override
    public List<ConfNode> getConfNodeList(String conferenceIdentifier, int page, int numPerPage) {
        if (page == 0) {
            page = 1;
        }
        if (page < -1) {
            page = -1;
        }
        if (numPerPage < 10) {
            numPerPage = 10;
        }
        if (numPerPage < -1) {
            numPerPage = -1;
        }
        ConferenceResponse response = null;
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetConfNodeListRequest request = new GetConfNodeListRequest();
            request.setConferenceIdentifier(conferenceIdentifier);
            request.setPage(page);
            request.setNumPerPage(numPerPage);
            response = mStub.getConfNodeList(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return null;
        }
        if ("200".equals(response.getResult())) {
            ConfNode[] data = ((GetConfNodeListResponse)response).getConfNodeList();
            ArrayList<ConfNode> ConfNodeList = new ArrayList<ConfNode>(data.length);
            Collections.addAll(ConfNodeList, data);
            return ConfNodeList;
        }
        throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
    }

    @Override
    public List<ConferenceStatus> getHistoryConferenceList(HistoryConferenceVO historyConferenceVO) {
        Integer page = historyConferenceVO.getPage();
        Integer numPerPage = historyConferenceVO.getNumPerPage();
        if (page == 0) {
            page = 1;
        }
        if (page < -1) {
            page = -1;
        }
        if (numPerPage < 10) {
            numPerPage = 10;
        }
        if (numPerPage < -1) {
            numPerPage = -1;
        }
        ConferenceResponse response = null;
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            GetHistoryConferenceListRequest request = new GetHistoryConferenceListRequest();
            request.setAccount(this.userName);
            request.setOption(historyConferenceVO.getOption());
            if (StringUtil.isNotEmpty((String)historyConferenceVO.getConferenceNumber())) {
                request.setConferenceNumber(historyConferenceVO.getConferenceNumber());
            }
            if (StringUtil.isNotEmpty((String)historyConferenceVO.getConferenceName())) {
                request.setConferenceName(historyConferenceVO.getConferenceName());
            }
            if (null != historyConferenceVO.getStartTime()) {
                GregorianCalendar localDateTimeCalendar = GregorianCalendar.from(ZonedDateTime.of(historyConferenceVO.getStartTime(), ZoneId.systemDefault()));
                request.setStartTime(localDateTimeCalendar);
            }
            request.setPage(page);
            request.setNumPerPage(numPerPage);
            response = mStub.getHistoryConferenceList(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (response == null) {
            return null;
        }
        if ("200".equals(response.getResult())) {
            ConferenceStatus[] data = ((GetHistoryConferenceListResponse)response).getConferenceList();
            ArrayList<ConferenceStatus> conferenceStatusList = new ArrayList<ConferenceStatus>(data.length);
            Collections.addAll(conferenceStatusList, data);
            return conferenceStatusList;
        }
        throw new BaseException(ZTEErrorCode.getDescByCode(response.getResult()));
    }

    @Override
    public ProlongConferenceResponse prolongConference(String meetingId, int minutes) {
        try {
            MultimediaConferenceServiceLocator mLocator = new MultimediaConferenceServiceLocator();
            mLocator.setMultimediaConferenceEndpointAddress(this.url);
            MultimediaConferenceSoapBindingStub mStub = (MultimediaConferenceSoapBindingStub)mLocator.getMultimediaConference();
            SOAPHeaderElement header = new SOAPHeaderElement(new QName("AuthHeader"));
            MessageElement element = new MessageElement(new QName("Version"), (Object)"1");
            MessageElement tokenElement = new MessageElement(new QName("Token"), (Object)this.getToken());
            header.addChild(tokenElement);
            header.addChild(element);
            mStub.setHeader(header);
            ProlongConferenceRequest request = new ProlongConferenceRequest();
            request.setConferenceIdentifier(meetingId);
            request.setProlongTime(minutes);
            ProlongConferenceResponse response = mStub.prolongConference(request);
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

