/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.xqxt.meeting.dto.MeetingDTO;
import com.artfess.xqxt.meeting.m900.bean.ConferenceStatus;
import com.artfess.xqxt.meeting.m900.bean.ParticipantStatusV2;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.MeetingUserManager;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.model.MeetingUser;
import com.artfess.xqxt.meeting.model.ZTEErrorCode;
import com.artfess.xqxt.meeting.vo.BizSiteParamExVO;
import com.artfess.xqxt.meeting.vo.HistoryConferenceVO;
import com.artfess.xqxt.meeting.vo.MeetBrowseParamVO;
import com.artfess.xqxt.meeting.vo.MeetFeedBackVO;
import com.artfess.xqxt.meeting.vo.MeetParamVO;
import com.artfess.xqxt.meeting.vo.MeetingCountVO;
import com.artfess.xqxt.meeting.vo.MeetingVO;
import com.artfess.xqxt.meeting.vo.Sha1VO;
import com.artfess.xqxt.meeting.vo.SignInAndOutCountVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/meeting/v1/"})
@Api(tags={"\u4f1a\u8bae\u6a21\u5757"})
@ApiGroup(group={"group_biz"})
public class MeetingController
extends BaseController<MeetingManager, Meeting> {
    @Resource
    MeetingManager meetingManager;
    @Resource
    private ZTEManager zteManager;
    @Resource
    private MeetingUserManager meetingUserManager;

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u4f1a\u8bae\u5bfc\u51fa")
    public void exportMeeting(@ApiParam(name="id", value="\u4f1a\u8baeID") @RequestParam String id, HttpServletResponse response) throws Exception {
        Assert.notNull((Object)id, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        this.meetingManager.exportMeeting(id, response);
    }

    @RequestMapping(value={"/getHistory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5386\u53f2\u4f1a\u8bae", httpMethod="POST")
    public CommonResult<PageList<MeetingVO>> getAllHistory(@RequestParam Integer type, @ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Meeting> queryFilter) {
        PageList<MeetingVO> result = this.meetingManager.getHistory(type, queryFilter);
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", result);
    }

    @RequestMapping(value={"/listCount"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u8bae\u6570\u91cf", httpMethod="GET")
    public CommonResult<MeetingCountVO> listCount() {
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", (Object)this.meetingManager.getMeetingCount());
    }

    @RequestMapping(value={"/getJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4f1a\u8bae\u67e5\u8be2", httpMethod="POST")
    public CommonResult<PageList<MeetingVO>> getJson(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<Meeting> queryFilter) {
        PageList<MeetingVO> result = this.meetingManager.findByUserId(queryFilter);
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", result);
    }

    @RequestMapping(value={"/getSiteListByMeetingId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4f1a\u8baeID\u67e5\u8be2\u4f1a\u573a\u5217\u8868\u53ca\u72b6\u6001", httpMethod="GET")
    public CommonResult<List<BizSiteParamExVO>> getSiteListByMeetingId(@ApiParam(name="meetingId", value="\u4f1a\u8baeID") @RequestParam String meetingId, @ApiParam(name="terminalIdentifier", value="\u7ec8\u7aefID\uff0c\u591a\u4e2a\u4f7f\u7528\u9017\u53f7\u5206\u5272ID") @RequestParam String terminalIdentifier) throws Exception {
        String[] terminalIdentifiers = null;
        if (StringUtils.isNotBlank((CharSequence)terminalIdentifier)) {
            terminalIdentifiers = terminalIdentifier.split(",");
        }
        List<BizSiteParamExVO> result = this.zteManager.getParticipantStatusV2(meetingId, terminalIdentifiers);
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", result);
    }

    @GetMapping(value={"get/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u4f1a\u8bae\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u4f1a\u8bae\u4fe1\u606f")
    public CommonResult<MeetingVO> get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return new CommonResult(true, "\u6210\u529f", (Object)this.meetingManager.findById(id));
    }

    @GetMapping(value={"getSha1"})
    @ApiOperation(value="\u83b7\u53d6\u5fae\u4fe1\u7b7e\u540d", httpMethod="GET", notes="\u83b7\u53d6\u5fae\u4fe1\u7b7e\u540d")
    public CommonResult<Sha1VO> getSha1(@RequestParam String url) {
        return new CommonResult(true, "\u6210\u529f", (Object)this.meetingManager.getSha1(url));
    }

    @RequestMapping(value={"/saveMeeting"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4f1a\u8bae\u4fe1\u606f\u52a0\u5206\u7ec4", httpMethod="POST")
    public CommonResult<String> saveMeetingVo(@ApiParam(name="MeetingDTO", value="\u4f1a\u8bae\u5b9e\u4f53") @RequestBody MeetingDTO dto) {
        String result = this.meetingManager.insertMeetingVo(dto);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u8bae\u521b\u5efa\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u521b\u5efa\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/updateMeeting"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u4f1a\u8bae\u4fe1\u606f\u52a0\u5206\u7ec4", httpMethod="POST")
    public CommonResult<String> updateMeetingVo(@ApiParam(name="MeetingDTO", value="\u4f1a\u8bae\u5b9e\u4f53") @RequestBody MeetingDTO dto) {
        int result = this.meetingManager.updateMeetingVo(dto);
        if (result <= 0) {
            return new CommonResult(false, "\u4fee\u6539\u5931\u8d25\uff01");
        }
        return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delayMeeting"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5ef6\u957f\u4f1a\u8bae\u65f6\u95f4", httpMethod="POST")
    public CommonResult<String> delayMeeting(@ApiParam(name="meetingId", value="\u4f1a\u8baeID") @RequestParam String meetingId, @ApiParam(name="meetingType", value="\u4f1a\u8bae\u7c7b\u578b") @RequestParam Integer meetingType, @ApiParam(name="minutes", value="\u5ef6\u957f\u65f6\u95f4\uff0c\u5206\u949f") @RequestParam Integer minutes) throws Exception {
        String result = this.meetingManager.delayMeeting(meetingId, meetingType, minutes);
        if ("1".equals(result)) {
            return new CommonResult(false, "\u5ef6\u957f\u4f1a\u8bae\u65f6\u95f4\u5931\u8d25\uff01");
        }
        return new CommonResult(true, "\u5ef6\u957f\u4f1a\u8bae\u65f6\u95f4\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4f1a\u8bae", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4f1a\u8bae")
    public CommonResult<String> removes(@ApiParam(name="ids", value="ID\u96c6\u5408\u4ee5\uff0c\u9694\u5f00", required=true) @RequestParam(value="ids", required=true) String ids) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idsList = Arrays.asList(ids.split(","));
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"ID_", idsList);
            updateWrapper.set((Object)"IS_DELE_", (Object)"1");
            this.meetingManager.update(null, (Wrapper)updateWrapper);
        }
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4fee\u6539\u4f1a\u8bae\u72b6\u6001", httpMethod="GET")
    public CommonResult<String> updateStatus(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u4f1a\u8bae\u72b6\u6001\uff0c1\uff1a\u672a\u5f00\u59cb\uff0c2\uff1a\u8fdb\u884c\u4e2d\uff0c3\uff1a\u5df2\u7ed3\u675f\uff0c4\uff1a\u53d6\u6d88") @RequestParam Integer status) {
        String result = this.meetingManager.updateStatus(id, status);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4fee\u6539\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/endMeeting"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7ed3\u675f\u4f1a\u8bae", httpMethod="GET")
    public CommonResult<String> endMeeting(@RequestParam String id) {
        String result = this.meetingManager.endMeeting(id);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u8bae\u7ed3\u675f\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u8bae\u7ed3\u675f\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/quiet"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u9ea6\u514b\u98ce\u9759\u97f3\uff08\u4e00\u952e\u9759\u97f3\u65f6\u4e0d\u4f20\u7ec8\u7aefID\uff09", httpMethod="GET")
    public CommonResult<String> quietMeeting(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID\uff0c\u5982\u679c\u4e0d\u4f20\u5219\u5173\u95ed\u4f1a\u8bae\u4e2d\u6240\u6709\u4f1a\u573a\u9ea6\u514b\u98ce") @RequestParam String placeId) {
        String result = this.zteManager.muteParticipant(id, placeId, true);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u9759\u97f3\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u9759\u97f3\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/cancelQuiet"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u9ea6\u514b\u98ce\u53d6\u6d88\u9759\u97f3\uff08\u6253\u5f00\u9ea6\u514b\u98ce\u8f93\u5165\uff09", httpMethod="GET")
    public CommonResult<String> cancelQuiet(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID\uff0c\u5982\u679c\u4e0d\u4f20\u5219\u6253\u5f00\u4f1a\u8bae\u4e2d\u6240\u6709\u4f1a\u573a\u9ea6\u514b\u98ce") @RequestParam String placeId) {
        String result = this.zteManager.cancelMuteParticipant(id, placeId, true);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u53d6\u6d88\u9759\u97f3\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u53d6\u6d88\u9759\u97f3\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/quietParticipant"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u626c\u58f0\u5668\u9759\u97f3\uff08\u5173\u95ed\u626c\u58f0\u5668\u8f93\u5165\uff09", httpMethod="GET")
    public CommonResult<String> quietParticipant(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID\uff0c\u5982\u679c\u4e0d\u4f20\u5219\u5173\u95ed\u4f1a\u8bae\u4e2d\u6240\u6709\u4f1a\u573a\u626c\u58f0\u5668") @RequestParam String placeId) {
        String result = this.meetingManager.quiet(id, placeId);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u9759\u97f3\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u9759\u97f3\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/cancelQuietParticipant"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u626c\u58f0\u5668\u53d6\u6d88\u9759\u97f3\uff08\u6253\u5f00\u626c\u58f0\u5668\u8f93\u5165\uff09", httpMethod="GET")
    public CommonResult<String> cancelQuietParticipant(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID\uff0c\u5982\u679c\u4e0d\u4f20\u5219\u6253\u5f00\u4f1a\u8bae\u4e2d\u6240\u6709\u4f1a\u573a\u626c\u58f0\u5668") @RequestParam String placeId) {
        String result = this.meetingManager.cancelQuiet(id, placeId);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u53d6\u6d88\u9759\u97f3\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u53d6\u6d88\u9759\u97f3\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4f1a\u573a\u547c\u53eb\uff08\u4e00\u952e\u547c\u53eb\u65f6\u4e0d\u4f20\u7ec8\u7aefID\uff09", httpMethod="POST")
    public CommonResult<String> conect(@ApiParam(name="meetParamVO", value="\u4f1a\u8bae\u53c2\u6570Vo") @RequestBody MeetParamVO meetParamVO) {
        String placeIds;
        String id = meetParamVO.getId();
        String result = this.meetingManager.connect(id, placeIds = meetParamVO.getPlaceIds());
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u573a\u547c\u53eb\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u547c\u53eb\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/disconnect"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u65ad\u5f00", httpMethod="GET")
    public CommonResult<String> disconnect(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID\uff0c\u591a\u4e2a\u4f7f\u7528\u9017\u53f7\u5206\u9694") @RequestParam String placeIds) {
        String result = this.meetingManager.disconnect(id, placeIds);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u573a\u65ad\u5f00\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u65ad\u5f00\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/invitePar"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u6dfb\u52a0", httpMethod="GET")
    public CommonResult<String> invitePar(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID") @RequestParam String placeId) {
        String result = this.meetingManager.inviteParticipant(id, placeId);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u573a\u6dfb\u52a0\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u6dfb\u52a0\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/parStatus"}, method={RequestMethod.GET})
    @ApiOperation(value="\u4f1a\u573a\u72b6\u6001", httpMethod="GET")
    public CommonResult<ParticipantStatusV2[]> parStatus(@RequestParam String id) throws Exception {
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", (Object)this.meetingManager.participantStatusV2(id));
    }

    @RequestMapping(value={"/setChairman"}, method={RequestMethod.GET})
    @ApiOperation(value="\u8bbe\u7f6e\u4e3b\u5e2d", httpMethod="GET")
    public CommonResult<String> setChairman(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID") @RequestParam String placeId) {
        String result = this.zteManager.setChairman(id, placeId);
        if ("-1".equalsIgnoreCase(placeId)) {
            this.zteManager.quiet(id, placeId, false);
        } else {
            this.zteManager.cancelQuiet(id, placeId, false);
        }
        if ("1".equals(result)) {
            return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u8bbe\u7f6e\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/call"}, method={RequestMethod.GET})
    @ApiOperation(value="\u70b9\u540d", httpMethod="GET")
    public CommonResult<String> call(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u88ab\u70b9\u540d\u7ec8\u7aefID") @RequestParam String placeId, @ApiParam(value="\u4e3b\u5e2d\u4f1a\u573a\u7ec8\u7aefID\uff0c\u5982\u679c\u6709\u4e3b\u5e2d\u5fc5\u987b\u4f20\u5165\uff0c\u5426\u5219\u4f1a\u5168\u5458\u9759\u97f3") @RequestParam String chairmanId) {
        String result;
        Assert.notNull((Object)chairmanId, (String)"\u4e3b\u5e2dID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u4e3b\u5e2d\uff01");
        String s = this.zteManager.browseParticipant(id, null, 0);
        String quiet = this.zteManager.muteParticipant(id, null, false);
        String s1 = this.zteManager.cancelMuteParticipant(id, placeId, false);
        if (StringUtils.isNotBlank((CharSequence)chairmanId)) {
            String string = this.zteManager.cancelMuteParticipant(id, chairmanId, false);
        }
        if ("1".equals(result = this.zteManager.boardcastParticipant(id, placeId))) {
            Meeting meeting = (Meeting)this.meetingManager.get((Serializable)((Object)id));
            if (null != meeting) {
                meeting.setBoardcaster(placeId);
                this.meetingManager.update((Model)meeting);
            }
            return new CommonResult(true, "\u70b9\u540d\u6210\u529f");
        }
        return new CommonResult(false, "\u70b9\u540d\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/cancelCall"}, method={RequestMethod.GET})
    @ApiOperation(value="\u53d6\u6d88\u70b9\u540d", httpMethod="GET")
    public CommonResult<String> cancelCall(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u88ab\u53d6\u6d88\u70b9\u540d\u7ec8\u7aefID") @RequestParam String placeId, @ApiParam(value="\u4e3b\u5e2d\u4f1a\u573a\u7ec8\u7aefID\uff0c\u5982\u679c\u6709\u4e3b\u5e2d\u5fc5\u987b\u4f20\u5165\uff0c\u5426\u5219\u4f1a\u5168\u5458\u9759\u97f3") @RequestParam String chairmanId) {
        Assert.notNull((Object)chairmanId, (String)"\u4e3b\u5e2dID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String s = this.zteManager.browseParticipant(id, null, 0);
        String quiet = this.zteManager.muteParticipant(id, null, false);
        String s2 = this.zteManager.cancelMuteParticipant(id, chairmanId, false);
        String result = this.zteManager.boardcastParticipant(id, chairmanId);
        boolean allCancel = false;
        if (placeId.equalsIgnoreCase(chairmanId)) {
            this.zteManager.browseParticipant(id, null, 1);
            allCancel = true;
        }
        if ("1".equals(result)) {
            Meeting meeting = (Meeting)this.meetingManager.get((Serializable)((Object)id));
            if (null != meeting) {
                if (allCancel) {
                    meeting.setBoardcaster("-1");
                } else {
                    meeting.setBoardcaster(placeId);
                }
                this.meetingManager.update((Model)meeting);
            }
            return new CommonResult(true, "\u53d6\u6d88\u70b9\u540d\u6210\u529f");
        }
        return new CommonResult(false, "\u53d6\u6d88\u70b9\u540d\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/browseParticipant"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4f1a\u573a\u8f6e\u8be2", httpMethod="POST")
    public CommonResult<String> browseParticipant(@ApiParam(name="meetBrowseParamVO", value="\u4f1a\u8bae\u8f6e\u8bad\u53c2\u6570Vo") @RequestBody MeetBrowseParamVO meetBrowseParamVO) {
        String id = meetBrowseParamVO.getId();
        String placeId = meetBrowseParamVO.getPlaceId();
        Integer cmdType = meetBrowseParamVO.getCmdType();
        String result = this.zteManager.browseParticipant(id, placeId, cmdType);
        result = "1";
        if ("1".equals(result)) {
            Meeting meeting = (Meeting)this.meetingManager.get((Serializable)((Object)id));
            if (null != meeting) {
                if (null != cmdType && cmdType == 0) {
                    meeting.setRotationStatus(1);
                    this.meetingManager.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"ROTATION_STATUS_", (Object)1)).eq((Object)"ID_", (Object)id));
                } else {
                    meeting.setRotationStatus(0);
                    this.meetingManager.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"ROTATION_STATUS_", (Object)0)).eq((Object)"ID_", (Object)id));
                }
                this.meetingManager.update((Model)meeting);
            }
            return new CommonResult(true, "\u4f1a\u573a\u8f6e\u8be2\u8bbe\u7f6e\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u8f6e\u8be2\u8bbe\u7f6e\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/updateMeetingUser"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4f1a\u8bae\u7528\u6237\u4fe1\u606f\u4fee\u6539", httpMethod="POST")
    public CommonResult<String> updateMeetingUser(@RequestBody MeetingUser meetingUser) {
        if (this.meetingManager.updateMeetingUser(meetingUser) > 0) {
            return new CommonResult(true, "\u4fee\u6539\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/signIn"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7b7e\u5230", httpMethod="GET")
    public CommonResult<String> signIn(@RequestParam String meetingId, @RequestParam String userId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.meetingManager.signIn(meetingId, userId);
        return new CommonResult(true, "\u7b7e\u5230\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/disSignIn"}, method={RequestMethod.GET})
    @ApiOperation(value="\u53d6\u6d88\u7b7e\u5230", httpMethod="GET")
    public CommonResult<String> disSignIn(@RequestParam String meetingId, @RequestParam String userId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.meetingManager.disSignIn(meetingId, userId);
        return new CommonResult(true, "\u53d6\u6d88\u7b7e\u5230\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/signOut"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7b7e\u9000", httpMethod="GET")
    public CommonResult<String> signOut(@RequestParam String meetingId, @RequestParam String userId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.meetingManager.signOut(meetingId, userId);
        return new CommonResult(true, "\u7b7e\u9000\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/disSignOut"}, method={RequestMethod.GET})
    @ApiOperation(value="\u53d6\u6d88\u7b7e\u9000", httpMethod="GET")
    public CommonResult<String> disSignOut(@RequestParam String meetingId, @RequestParam String userId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.meetingManager.disSignOut(meetingId, userId);
        return new CommonResult(true, "\u53d6\u6d88\u7b7e\u9000\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/signInUserList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7b7e\u5230\u4eba\u5458\u5217\u8868", httpMethod="GET")
    public CommonResult<List<MeetingUser>> signInUserList(@RequestParam String meetingId, @RequestParam Integer type) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6210\u529f\uff01", this.meetingManager.signInUserList(meetingId, type));
    }

    @RequestMapping(value={"/signOutUserList"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7b7e\u9000\u4eba\u5458\u5217\u8868", httpMethod="GET")
    public CommonResult<List<MeetingUser>> signOutUserList(@RequestParam String meetingId, @RequestParam Integer type) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6210\u529f\uff01", this.meetingManager.signOutUserList(meetingId, type));
    }

    @RequestMapping(value={"/signInAndOutCount"}, method={RequestMethod.GET})
    @ApiOperation(value="\u7b7e\u5230/\u7b7e\u9000\u4eba\u5458\u6570\u91cf\u7edf\u8ba1", httpMethod="GET")
    public CommonResult<SignInAndOutCountVo> signInAndOutCount(@RequestParam String meetingId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01", (Object)this.meetingManager.signInAndOutCount(meetingId));
    }

    @RequestMapping(value={"/getMeetingUserByMeetingIdAndUserId"}, method={RequestMethod.GET})
    @ApiOperation(value="\u6839\u636e\u4f1a\u8baeID\u3001\u7528\u6237id\u67e5\u8be2\u7528\u6237\u4fe1\u606f", httpMethod="GET")
    public CommonResult<MeetingUser> getMeetingUserByMeetingIdAndUserId(@RequestParam String meetingId, @RequestParam String userId) {
        Assert.notNull((Object)meetingId, (String)"\u4f1a\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        return new CommonResult(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f\uff01", (Object)this.meetingManager.getMeetingUserByMeetingIdAndUserId(meetingId, userId));
    }

    @RequestMapping(value={"/deleteParticipant"}, method={RequestMethod.GET})
    @ApiOperation(value="\u5220\u9664\u4f1a\u573a", httpMethod="GET")
    public CommonResult<String> deleteParticipant(@ApiParam(value="\u4f1a\u8baeID") @RequestParam String id, @ApiParam(value="\u7ec8\u7aefID,\u591a\u4e2a\u4f7f\u7528\u9017\u53f7\u5206\u9694") @RequestParam String placeId) {
        Assert.notNull((Object)placeId, (String)"\u7ec8\u7aefID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String result = this.zteManager.deleteParticipant(id, placeId);
        if ("1".equals(result)) {
            return new CommonResult(true, "\u4f1a\u573a\u5220\u9664\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4f1a\u573a\u5220\u9664\u5931\u8d25\uff0c" + ZTEErrorCode.getDescByCode(result));
    }

    @RequestMapping(value={"/feedBack"}, method={RequestMethod.POST})
    @ApiOperation(value="\u53cd\u9988-\u5165\u4f1a\u53cd\u9988", httpMethod="POST")
    public CommonResult<String> feedBack(@RequestBody MeetFeedBackVO meetFeedBackVO) {
        this.meetingUserManager.feedBack(meetFeedBackVO);
        return new CommonResult(true, "\u5165\u4f1a\u53cd\u9988\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/synConferenceInfo"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u4e2d\u5174\u6b63\u5728\u8fdb\u884c\u7684\u4f1a\u8bae", httpMethod="POST")
    public CommonResult<String> synConferenceInfo() {
        this.meetingManager.synConferenceInfo();
        return new CommonResult(true, "\u540c\u6b65\u4e2d\u5174\u6b63\u5728\u8fdb\u884c\u7684\u4f1a\u8bae\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"/synConferenceReserved"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u4e2d\u5174\u5c06\u6765\u9884\u7ea6\u7684\u4f1a\u8bae", httpMethod="POST")
    public CommonResult<String> synConferenceReserved() {
        this.meetingManager.synConferenceReserved();
        return new CommonResult(true, "\u540c\u6b65\u4e2d\u5174\u5c06\u6765\u9884\u7ea6\u7684\u4f1a\u8bae\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"/getHistoryConferenceList"}, method={RequestMethod.POST})
    @ApiOperation(value="\u4ece\u4e2d\u5174\u83b7\u53d6\u5386\u53f2\u4f1a\u8bae", httpMethod="POST")
    public CommonResult<List<ConferenceStatus>> getHistoryConferenceList(@RequestBody HistoryConferenceVO historyConferenceVO) {
        List<ConferenceStatus> result = this.zteManager.getHistoryConferenceList(historyConferenceVO);
        return new CommonResult(true, "\u4ece\u4e2d\u5174\u83b7\u53d6\u5386\u53f2\u4f1a\u8bae\u67e5\u8be2\u6210\u529f\uff01", result);
    }
}

