/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.schedule;

import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.xqxt.meeting.dao.MeetingDao;
import com.artfess.xqxt.meeting.m900.bean.ConferenceStatus;
import com.artfess.xqxt.meeting.manager.MeetingManager;
import com.artfess.xqxt.meeting.manager.ZTEManager;
import com.artfess.xqxt.meeting.model.Meeting;
import com.artfess.xqxt.meeting.vo.HistoryConferenceVO;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@EnableScheduling
public class Schedule {
    private static final Logger log = LoggerFactory.getLogger(Schedule.class);
    @Resource
    MeetingDao meetingDao;
    @Resource
    MeetingManager meetingManager;
    @Resource
    SysDictionaryManager sysDictionaryManager;
    @Resource
    ZTEManager zteManager;

    @Scheduled(cron="0/30 * * * * ? ")
    public void send() {
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4f01\u4e1a\u5fae\u4fe1\u901a\u77e5\u63a8\u9001\u3011\u6267\u884c---\u5f00\u59cb-------------------------------\n");
        System.out.println("*******************************\u5b9a\u65f6\u4f1a\u8bae\u901a\u77e5\u5f00\u59cb****************************");
        List<Meeting> sendList = this.meetingDao.select4SendMsg();
        if (sendList.size() <= 0) {
            return;
        }
        Long nowTime = new Date().getTime();
        for (Meeting meeting : sendList) {
            Long senTime;
            Long startTime = meeting.getStartTime().toInstant(ZoneOffset.of("+8")).toEpochMilli();
            if (StringUtil.isEmpty((String)meeting.getRemindTime()) && (senTime = Long.valueOf(nowTime - startTime)) <= 30000L && senTime >= 0L) {
                this.meetingManager.sendMsg(meeting, 4);
                break;
            }
            List<String> list = Arrays.asList(meeting.getRemindTime().split(","));
            for (String str : list) {
                Long senTime2;
                String type = str.trim();
                Long sendTime = 0L;
                if ("2".equalsIgnoreCase(type)) {
                    sendTime = startTime;
                    senTime2 = nowTime - sendTime;
                    if (senTime2 <= 30000L && senTime2 >= 0L) {
                        this.meetingManager.sendMsg(meeting, 4);
                        break;
                    }
                }
                if ("3".equalsIgnoreCase(type)) {
                    sendTime = startTime - 300000L;
                    senTime2 = nowTime - sendTime;
                    if (senTime2 <= 30000L && senTime2 >= 0L) {
                        this.meetingManager.sendMsg(meeting, 4);
                        break;
                    }
                }
                if ("4".equalsIgnoreCase(type)) {
                    sendTime = startTime - 900000L;
                    senTime2 = nowTime - sendTime;
                    if (senTime2 <= 30000L && senTime2 >= 0L) {
                        this.meetingManager.sendMsg(meeting, 4);
                        break;
                    }
                }
                if ("5".equalsIgnoreCase(type)) {
                    sendTime = startTime - 3600000L;
                    senTime2 = nowTime - sendTime;
                    if (senTime2 <= 30000L && senTime2 >= 0L) {
                        this.meetingManager.sendMsg(meeting, 4);
                        break;
                    }
                }
                if (!"6".equalsIgnoreCase(type)) continue;
                sendTime = startTime - 86400000L;
                senTime2 = nowTime - sendTime;
                if (senTime2 > 30000L || senTime2 < 0L) continue;
                this.meetingManager.sendMsg(meeting, 4);
                break;
            }
            System.out.println("*******************************\u5b9a\u65f6\u4f1a\u8bae\u901a\u77e5\u7ed3\u675f****************************");
        }
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4f01\u4e1a\u5fae\u4fe1\u901a\u77e5\u63a8\u9001\u3011\u6267\u884c---\u7ed3\u675f-------------------------------\n");
    }

    @Scheduled(cron="0/30 * * * * ? ")
    @Transactional
    public void updateStatus() {
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4f1a\u8bae\u72b6\u6001\u4fee\u6539\u3011\u6267\u884c---\u5f00\u59cb-------------------------------\n");
        List<Meeting> list = this.meetingDao.selectByStatus(1);
        LocalDateTime now = LocalDateTime.now();
        for (Meeting meeting : list) {
            Duration duration = Duration.between(now, meeting.getStartTime());
            long millis = duration.toMillis();
            if (!now.isAfter(meeting.getStartTime()) && !now.isEqual(meeting.getStartTime()) && millis >= 30000L) continue;
            this.meetingManager.updateStatus(meeting.getId(), 2);
        }
        List<Meeting> runList = this.meetingDao.selectByStatus(2);
        for (Meeting meeting : runList) {
            if (meeting.getMeetingType() == 1) {
                if (!now.isAfter(meeting.getEndTime()) && !now.isEqual(meeting.getEndTime())) continue;
                this.meetingManager.updateStatus(meeting.getId(), 3);
                continue;
            }
            if (meeting.getMeetingType() != 2) continue;
            LocalDateTime endTime = meeting.getEndTime();
            if (now.isAfter(meeting.getEndTime()) || now.isEqual(meeting.getEndTime())) {
                this.meetingManager.updateStatus(meeting.getId(), 3);
                continue;
            }
            if (!StringUtil.isNotEmpty((String)meeting.getConferenceNumber())) continue;
            HistoryConferenceVO historyConferenceVO = new HistoryConferenceVO();
            historyConferenceVO.setConferenceNumber(meeting.getConferenceNumber());
            historyConferenceVO.setPage(1);
            historyConferenceVO.setNumPerPage(10);
            historyConferenceVO.setOption(1);
            List<ConferenceStatus> historyConferenceList = this.zteManager.getHistoryConferenceList(historyConferenceVO);
            if (null == historyConferenceList || historyConferenceList.size() <= 0) continue;
            this.meetingManager.updateStatus(meeting.getId(), 3);
        }
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4f1a\u8bae\u72b6\u6001\u4fee\u6539\u3011\u6267\u884c---\u7ed3\u675f-------------------------------\n");
    }

    @Transactional
    public void synMeetingByZte() {
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4e2d\u5174\u4f1a\u8bae\u5217\u8868\u6570\u636e\u540c\u6b65\u3011\u6267\u884c---\u5f00\u59cb-------------------------------\n");
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u540c\u6b65\u6b63\u5728\u8fdb\u884c\u7684\u4f1a\u8bae\u4efb\u52a1\u3011\u6267\u884c.........\n");
        this.meetingManager.synConferenceInfo();
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u540c\u6b65\u9884\u7ea6\u7684\u4f1a\u8bae\u4efb\u52a1\u3011\u6267\u884c.........\n");
        this.meetingManager.synConferenceReserved();
        log.info("\n------------------------------\t\u5b9a\u65f6\u4efb\u52a1\u3010\u4e2d\u5174\u4f1a\u8bae\u5217\u8868\u6570\u636e\u540c\u6b65\u3011\u6267\u884c---\u7ed3\u675f-------------------------------\n");
    }
}

