/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.artfess.base.context.BaseContext;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.xqxt.meeting.dao.BizMeetingAccessoryDao;
import com.artfess.xqxt.meeting.manager.BizMeetingAccessoryManager;
import com.artfess.xqxt.meeting.model.BizMeetingAccessory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizMeetingAccessoryManagerImpl
extends BaseManagerImpl<BizMeetingAccessoryDao, BizMeetingAccessory>
implements BizMeetingAccessoryManager {
    @Value(value="${file.tempFilePath}")
    private String tempFilePath;
    @Resource
    private BaseContext baseContext;

    @Override
    public String upload(MultipartFile file, String id) throws IOException {
        System.out.println(file);
        if (file == null || file.isEmpty()) {
            return "";
        }
        String fileName = file.getOriginalFilename();
        String prefixName = fileName.substring(0, fileName.lastIndexOf("."));
        String suffixName = fileName.substring(fileName.lastIndexOf(".") + 1);
        int fileSize = (int)file.getSize();
        Long code = BizMeetingAccessoryManagerImpl.getCode();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateNow = sdf.format(date);
        File directory = new File(".");
        String filePath = directory.getCanonicalPath();
        String name = prefixName + "." + suffixName;
        String tempFilePathSuffer = this.tempFilePath.substring(this.tempFilePath.lastIndexOf(".") + 1);
        String path = filePath + tempFilePathSuffer + dateNow + "/" + name;
        File dest = new File(path);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        BizMeetingAccessory aiFile = new BizMeetingAccessory();
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(path));
            outputStream.write(file.getBytes());
            outputStream.flush();
            outputStream.close();
            aiFile.setName(name);
            aiFile.setSuffix(suffixName);
            aiFile.setFileSize(fileSize);
            aiFile.setUrl(path);
            aiFile.setCreateBy(this.baseContext.getCurrentUserId());
            aiFile.setCreateName(this.baseContext.getCurrentUserName());
            if (StringUtils.isNotEmpty((CharSequence)id)) {
                aiFile.setSourceId(id);
            }
            aiFile.setCreateTime(LocalDateTime.now());
            ((BizMeetingAccessoryDao)this.baseMapper).insert((Object)aiFile);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return aiFile.getId();
    }

    @Override
    public void download(Long id, HttpServletRequest req, HttpServletResponse res) {
        if (id != null) {
            BizMeetingAccessory entity = (BizMeetingAccessory)((Object)this.getById(id));
            String path = entity.getUrl();
            this.setDownloadContent(entity.getName(), req, res);
            res.setContentLength(entity.getFileSize().intValue());
            File file = new File(path);
            if (file.exists()) {
                byte[] buffer = new byte[1024];
                try (FileInputStream fis = new FileInputStream(file);
                     BufferedInputStream bis = new BufferedInputStream(fis);){
                    ServletOutputStream os = res.getOutputStream();
                    int i = bis.read(buffer);
                    while (i != -1) {
                        os.write(buffer, 0, i);
                        i = bis.read(buffer);
                    }
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void preview(Long id, HttpServletRequest req, HttpServletResponse res) {
        if (id != null) {
            BizMeetingAccessory entity = (BizMeetingAccessory)((Object)this.getById(id));
            String path = entity.getUrl();
            res.setContentLength(entity.getFileSize().intValue());
            File file = new File(path);
            byte[] buffer = FileUtil.readBytes((String)path);
            if (file.exists()) {
                try {
                    res.setContentType("*/*");
                    res.setCharacterEncoding("UTF-8");
                    ServletOutputStream outputStream = res.getOutputStream();
                    IoUtil.write((OutputStream)outputStream, (boolean)true, (byte[])buffer);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void setDownloadContent(String fileName, HttpServletRequest request, HttpServletResponse response) {
        String agent = request.getHeader("User-Agent");
        try {
            fileName = null != agent && agent.toUpperCase().indexOf("MSIE") > 0 ? URLEncoder.encode(fileName, "UTF-8") : new String(fileName.getBytes("UTF-8"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        response.setContentType("application/x-msdownload;");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
    }

    private static Long getCode() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String newDate = sdf.format(new Date());
        int randomNum = (int)((Math.random() * 9.0 + 1.0) * 10000.0);
        String result = String.valueOf(randomNum);
        String s = newDate + result;
        Long code = Long.parseLong(s);
        return code;
    }
}

