/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.service.impl;

import com.artfess.base.attachment.Attachment;
import com.artfess.base.attachment.AttachmentService;
import com.artfess.base.attachment.AttachmentServiceFactory;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.attachmentService.FtpAttachmentServiceImpl;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.service.FilePreview;
import com.artfess.file.util.AppFileUtil;
import com.artfess.file.util.FileUtils;
import com.artfess.file.util.OfficeToPdf;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OfficeFilePreviewImpl
implements FilePreview {
    @Autowired
    FileUtils fileUtils;
    @Value(value="${file.file.dir}")
    String fileDir;
    @Resource
    AttachmentServiceFactory attachmentServiceFactory;
    @Autowired
    private OfficeToPdf officeToPdf;

    @Override
    public String filePreviewHandle(DefaultFile fileMode, Map map) {
        String fileName = fileMode.getId() + "." + fileMode.getExtensionName();
        String suffix = fileMode.getExtensionName();
        boolean isHtml = suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx");
        String filePath = this.fileDir + fileMode.getId() + "." + fileMode.getExtensionName();
        String checkfilePath = filePath.substring(0, filePath.lastIndexOf(".") + 1) + (isHtml ? "html" : "pdf");
        boolean falg = this.checkFile(checkfilePath);
        if (!falg) {
            String outFilePath;
            if (!new File(filePath).exists()) {
                try {
                    File dirFile = new File(this.fileDir);
                    if (!dirFile.exists()) {
                        dirFile.mkdirs();
                    }
                    String separator = File.separator;
                    if (!filePath.contains(File.separator)) {
                        separator = File.separator.equals("/") ? "\\\\" : "/";
                    }
                    AppFileUtil.createPath(filePath.substring(0, filePath.lastIndexOf(separator)), fileName);
                    AttachmentService attachmentService = this.attachmentServiceFactory.getCurrentServices(AppFileUtil.getSaveType(BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getProp6() : ""));
                    if (attachmentService instanceof FtpAttachmentServiceImpl && DefaultFile.SAVE_TYPE_FOLDER.equals(fileMode.getStoreType())) {
                        AttachmentServiceFactory attachmentHandlerFactory = (AttachmentServiceFactory)AppUtil.getBean(AttachmentServiceFactory.class);
                        attachmentService = attachmentHandlerFactory.getCurrentServices(DefaultFile.SAVE_TYPE_FOLDER);
                    }
                    attachmentService.download((Attachment)fileMode, (OutputStream)new FileOutputStream(filePath), BeanUtils.isNotEmpty((Object)((Object)fileMode)) ? fileMode.getProp6() : "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.hasText((String)(outFilePath = filePath.substring(0, filePath.lastIndexOf(".") + 1) + (isHtml ? "html" : "pdf")))) {
                this.officeToPdf.openOfficeToPDF(filePath, outFilePath);
                File f = new File(filePath);
                if (f.exists()) {
                    f.delete();
                }
            }
        }
        map.put("pdfUrl", "/file/onlinePreviewController/v1/getFileByPathAndId_" + fileMode.getId() + "_" + (isHtml ? "html" : "pdf"));
        return isHtml ? "html" : "pdf";
    }

    private boolean checkFile(String path) {
        File file = new File(path);
        return file.exists();
    }
}

