/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.xqxt.meeting.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.artfess.xqxt.meeting.dao.BizMeetingTopicDao;
import com.artfess.xqxt.meeting.manager.BizMeetingOptionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingQuestionManager;
import com.artfess.xqxt.meeting.manager.BizMeetingTopicManager;
import com.artfess.xqxt.meeting.manager.BizMeetingVoteManager;
import com.artfess.xqxt.meeting.model.BizMeetingOption;
import com.artfess.xqxt.meeting.model.BizMeetingQuestion;
import com.artfess.xqxt.meeting.model.BizMeetingTopic;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizMeetingTopicManagerImpl
extends BaseManagerImpl<BizMeetingTopicDao, BizMeetingTopic>
implements BizMeetingTopicManager {
    @Autowired
    private BizMeetingQuestionManager questionManager;
    @Autowired
    private BizMeetingOptionManager optionManager;
    @Autowired
    private BizMeetingVoteManager voteManager;

    public PageList<BizMeetingTopic> query(QueryFilter<BizMeetingTopic> queryFilter) {
        PageList result = super.query(queryFilter);
        List allQuestions = this.questionManager.list();
        List allOptions = this.optionManager.list();
        result.getRows().forEach(r -> this.fillRealate((BizMeetingTopic)((Object)r), allQuestions, allOptions));
        User currentUser = ContextUtil.getCurrentUser();
        List allVote = this.voteManager.list();
        result.getRows().forEach(r -> r.getQuestionList().forEach(ql -> {
            long count = allVote.stream().filter(v -> v.getUserId().equals(currentUser.getId()) && v.getQuestionId().equals(ql.getId())).count();
            ql.setIsVoted(count >= 1L);
        }));
        return result;
    }

    public BizMeetingTopic getById(Serializable id) {
        BizMeetingTopic result = (BizMeetingTopic)((Object)super.getById(id));
        List allQuestions = this.questionManager.list();
        List allOptions = this.optionManager.list();
        this.fillRealate(result, allQuestions, allOptions);
        return result;
    }

    private void fillRealate(BizMeetingTopic topic, List<BizMeetingQuestion> allQuestions, List<BizMeetingOption> allOptions) {
        ArrayList questionTemp = Lists.newArrayList();
        allQuestions.forEach(q -> {
            if (q.getTopicId().equals(topic.getId())) {
                ArrayList optionTemp = Lists.newArrayList();
                allOptions.forEach(o -> {
                    if (o.getQuestionId().equals(q.getId())) {
                        optionTemp.add(o);
                    }
                });
                q.setOptionList(optionTemp);
                questionTemp.add(q);
            }
        });
        topic.setQuestionList(questionTemp);
    }

    @Transactional
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        boolean result;
        ArrayList questionIds = Lists.newArrayList();
        ArrayList optionIds = Lists.newArrayList();
        List allTopic = this.list();
        idList.forEach(id -> allTopic.forEach(at -> {
            if (id.equals(at.getId())) {
                if (BeanUtils.isEmpty(at.getQuestionList())) {
                    return;
                }
                at.getQuestionList().forEach(ql -> {
                    questionIds.add(ql.getId());
                    if (BeanUtils.isEmpty(ql.getOptionList())) {
                        return;
                    }
                    ql.getOptionList().forEach(ol -> optionIds.add(ol.getId()));
                });
            }
        }));
        boolean bl = super.removeByIds(idList) && BeanUtils.isEmpty((Object)questionIds) ? true : (result = this.questionManager.removeByIds(questionIds) && BeanUtils.isEmpty((Object)optionIds) ? true : this.optionManager.removeByIds(optionIds));
        if (!result) {
            throw new RuntimeException("\u64cd\u4f5c\u5931\u8d25\uff0c\u56de\u6eda\u4e8b\u52a1......");
        }
        return result;
    }
}

