export declare function linearMap(val: number, domain: number[], range: number[], clamp?: boolean): number;
export declare function parsePercent(percent: number | string, all: number): number;
export declare function round(x: number | string, precision?: number): number;
export declare function round(x: number | string, precision: number, returnStr: false): number;
export declare function round(x: number | string, precision: number, returnStr: true): string;
export declare function asc<T extends number[]>(arr: T): T;
export declare function getPrecision(val: string | number): number;
export declare function getPrecisionSafe(val: string | number): number;
export declare function getPixelPrecision(dataExtent: [number, number], pixelExtent: [number, number]): number;
export declare function getPercentWithPrecision(valueList: number[], idx: number, precision: number): number;
export declare const MAX_SAFE_INTEGER = 9007199254740991;
export declare function remRadian(radian: number): number;
export declare function isRadianAroundZero(val: number): boolean;
export declare function parseDate(value: unknown): Date;
export declare function quantity(val: number): number;
export declare function quantityExponent(val: number): number;
export declare function nice(val: number, round?: boolean): number;
export declare function quantile(ascArr: number[], p: number): number;
declare type IntervalItem = {
    interval: [number, number];
    close: [0 | 1, 0 | 1];
};
export declare function reformIntervals(list: IntervalItem[]): IntervalItem[];
export declare function numericToNumber(val: unknown): number;
export declare function isNumeric(val: unknown): val is number;
export declare function getRandomIdBase(): number;
export declare function getGreatestCommonDividor(a: number, b: number): number;
export declare function getLeastCommonMultiple(a: number, b: number): number;
export {};
