import directive from "@/directive";
import validate from "@/validate";
import HtInput from '@/components/HtInput.vue';
import HtCheckbox from '@/components/HtCheckbox.vue';
import HtTable from '@/components/HtTable.vue';
import HtTableColumn from '@/components/HtTableColumn';
import HtTableSearchPanel from '@/components/HtTableSearchPanel';
import HtTableSearchField from '@/components/HtTableSearchField';
import HtRadio from '@/components/HtRadio.vue';
import HtDate from '@/components/datetime/HtDate.vue';
import HtTimeSelect from '@/components/datetime/HtTimeSelect.vue';
import HtTimePicker from '@/components/datetime/HtTimePicker.vue';
import HtSelect from '@/components/HtSelect.vue';
import HtFile from '@/components/HtFile.vue';
import HtDemension from '@/components/HtDemension.vue';
import HtTree from '@/components/HtTree.vue';
import HtAddQueryStrategy from '@/components/HtAddQueryStrategy.vue';
import HtSidebarDialog from '@/components/common/HtSidebarDialog.vue';
import Selector from "@/components/common/Selector.vue";
import HtRoleSelector from '@/components/HtRoleSelector.vue';
import HtUserSelector from '@/components/HtUserSelector.vue';
import HtOrgSelector from '@/components/HtOrgSelector.vue';
import HtJobSelector from '@/components/HtJobSelector.vue';
import HtPostSelector from '@/components/HtPostSelector.vue';
import HtUserDialog from '@/components/dialog/HtUserDialog.vue';
import HtDialog from '@/components/dialog/HtDialog.vue';
import HtOrgPostDialog from '@/components/dialog/HtOrgPostDialog.vue';
import HtTreeDialog from '@/components/dialog/HtTreeDialog.vue';
import HtTreeListDialog from '@/components/dialog/HtTreeListDialog.vue';
import HtFormItem from '@/components/common/HtFormItem.vue';
import HtSaveButton from '@/components/common/HtSaveButton.vue';
import HtDuration from '@/components/HtDuration.vue';
import HtFieldTail from '@/components/HtFieldTail.vue';
import FileUpload from '@/components/common/FileUpload.vue';
import locale from '@/locale';
import config from '../../package.json';

const HotentUi = {
    version: config.version,
    locale: locale.use,
    i18n: locale.i18n,
    HtInput,
    HtCheckbox,
    HtRadio,
    HtDate,
    HtTimeSelect,
    HtTimePicker,
    HtTable,
    HtTableColumn,
    HtTableSearchPanel,
    HtTableSearchField,
    HtSelect,
    HtFile,
    HtDemension,
    HtTree,
    HtAddQueryStrategy,
    HtSidebarDialog,
    Selector,
    HtRoleSelector,
    HtUserSelector,
    HtOrgSelector,
    HtJobSelector,
    HtPostSelector,
    HtFormItem,
    HtSaveButton,
    HtUserDialog,
    HtDialog,
    HtTreeDialog,
    HtTreeListDialog,
    HtOrgPostDialog,
    HtDuration,
    HtFieldTail,
    FileUpload
};

HotentUi.install = (Vue, opts = {  }) => {
    if(!opts.smallScreenDialog){
        opts.smallScreenDialog = false;
    }
    if(!opts.paginationBackground){
        opts.paginationBackground = false
    }
    if(!opts.readonlyInput){
        opts.readonlyInput = false
    }
    Vue.prototype.$smallScreenDialog = opts.smallScreenDialog;
    Vue.prototype.$paginationBackground = opts.paginationBackground;
    Vue.prototype.$readonlyInput = opts.readonlyInput;
    locale.use(opts.locale);
    locale.i18n(opts.i18n);
    Vue.use(directive);
    Vue.use(validate);

    Object.keys(HotentUi).forEach(name => {
        Vue.component(name, HotentUi[name])
    });

    Vue.component("ht-vnode", {
        functional: true,
        render: (h, ctx) => {
            // 复制父组件的属性到子组件中
            let assembly = { ...ctx.props.vnode.componentOptions.propsData, ...ctx.props };
            delete assembly["vnode"];
            ctx.props.vnode.componentOptions.propsData = assembly;
            ctx.props.vnode.componentOptions.listeners = ctx.listeners;
            return ctx.props.vnode;
        }
    });
}

if (typeof window !== 'undefined' && window.Vue) {
    HotentUi.install(window.Vue);
}

export default HotentUi;
