const CompressionPlugin = require('compression-webpack-plugin');

module.exports = {
  publicPath: '/ui',
  outputDir: "lib",
  lintOnSave: false,
  configureWebpack: config => {
    if (process.env.NODE_ENV === 'production') {
      // gzip压缩
      config.plugins = [
        ...config.plugins,
        new CompressionPlugin({
          // 要压缩的文件类型
          test: /\.js$|\.html$|\.css/,
          // 大于该尺寸的文件才压缩（单位byte)
          threshold: 10240,
          // 是否删除原文件
          deleteOriginalAssets: false
        })
      ];
      // 删除调试语句
      config.optimization.minimizer[0].options.terserOptions.compress.warnings = false;
      config.optimization.minimizer[0].options.terserOptions.compress.drop_console = true;
      config.optimization.minimizer[0].options.terserOptions.compress.drop_debugger = true;
      config.optimization.minimizer[0].options.terserOptions.compress.pure_funcs = ['console.log'];
    }
  },
  chainWebpack: config => {
    config.devServer.disableHostCheck(true);
  },
  productionSourceMap: false
}
