/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.util;

import com.artfess.file.model.FileType;
import com.google.common.collect.Lists;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class FileUtils {
    Logger log = LoggerFactory.getLogger(this.getClass());
    final String REDIS_FILE_PREVIEW_PDF_KEY = "converted-preview-pdf-file";
    final String REDIS_FILE_PREVIEW_IMGS_KEY = "converted-preview-imgs-file";
    @Value(value="${file.file.dir}")
    String fileDir;
    @Value(value="${file.converted.file.charset}")
    String charset;
    @Value(value="${file.simText}")
    String[] simText;
    @Value(value="${file.media}")
    String[] media;
    @Value(value="${file.upload}")
    private String basepath;

    public String getFileDir() {
        return this.fileDir;
    }

    public FileType typeFromUrl(String fileType) {
        fileType = fileType.substring(fileType.lastIndexOf(".") + 1, fileType.length());
        if (this.listPictureTypes().contains(fileType.toLowerCase())) {
            return FileType.picture;
        }
        if (this.listArchiveTypes().contains(fileType.toLowerCase())) {
            return FileType.compress;
        }
        if (this.listOfficeTypes().contains(fileType.toLowerCase())) {
            return FileType.office;
        }
        if (Arrays.asList(this.simText).contains(fileType.toLowerCase())) {
            return FileType.simText;
        }
        if (Arrays.asList(this.media).contains(fileType.toLowerCase())) {
            return FileType.media;
        }
        if ("pdf".equalsIgnoreCase(fileType)) {
            return FileType.pdf;
        }
        return FileType.other;
    }

    public String getFileNameFromURL(String url) {
        String noQueryUrl = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = noQueryUrl.substring(noQueryUrl.lastIndexOf("/") + 1);
        return fileName;
    }

    public static String getSuffixFromFileName(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") == -1) {
            return "";
        }
        return fileName.substring(fileName.lastIndexOf("."));
    }

    public String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    public List<String> listPictureTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("jpg");
        list.add("jpeg");
        list.add("png");
        list.add("gif");
        list.add("bmp");
        list.add("ico");
        list.add("RAW");
        return list;
    }

    public List<String> listArchiveTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("rar");
        list.add("zip");
        list.add("jar");
        list.add("7-zip");
        list.add("tar");
        list.add("gzip");
        list.add("7z");
        return list;
    }

    public List<String> listOfficeTypes() {
        ArrayList list = Lists.newArrayList();
        list.add("docx");
        list.add("doc");
        list.add("xls");
        list.add("xlsx");
        list.add("ppt");
        list.add("pptx");
        list.add("wps");
        list.add("et");
        return list;
    }

    public String getRelativePath(String absolutePath) {
        return absolutePath.substring(this.fileDir.length());
    }

    public String getFileEncodeUTFGBK(String path) {
        String enc = Charset.forName("GBK").name();
        File file = new File(path);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] b = new byte[3];
            ((InputStream)in).read(b);
            ((InputStream)in).close();
            if (b[0] == -17 && b[1] == -69 && b[2] == -65) {
                enc = Charset.forName("UTF-8").name();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\u6587\u4ef6\u7f16\u7801\u683c\u5f0f\u4e3a:" + enc);
        return enc;
    }

    public void doActionConvertedFile(String outFilePath) {
        Throwable throwable;
        Throwable throwable2;
        StringBuffer sb = new StringBuffer();
        try {
            throwable2 = null;
            try (FileInputStream inputStream = new FileInputStream(outFilePath);){
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, this.charset));){
                    String line;
                    while (null != (line = reader.readLine())) {
                        if (line.contains("charset=gb2312")) {
                            line = line.replace("charset=gb2312", "charset=utf-8");
                        }
                        sb.append(line);
                    }
                    sb.append("<script src=\"js/jquery-3.0.0.min.js\" type=\"text/javascript\"></script>");
                    sb.append("<script src=\"js/excel.header.js\" type=\"text/javascript\"></script>");
                    sb.append("<link rel=\"stylesheet\" href=\"http://cdn.static.runoob.com/libs/bootstrap/3.3.7/css/bootstrap.min.css\">");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable reader) {
                throwable2 = reader;
                throw reader;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable2 = null;
            try (FileOutputStream fos = new FileOutputStream(outFilePath);){
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fos));){
                    writer.write(sb.toString());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String suffixFromUrl(String url) {
        String nonPramStr = url.substring(0, url.indexOf("?") != -1 ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        return fileType;
    }

    public static long getVideoTime(MultipartFile contentFile) throws Exception {
        CommonsMultipartFile cf = (CommonsMultipartFile)contentFile;
        DiskFileItem fi = (DiskFileItem)cf.getFileItem();
        File f = fi.getStoreLocation();
        Encoder encoder = new Encoder();
        MultimediaInfo m = encoder.getInfo(f);
        long second = m.getDuration() / 1000L;
        return second;
    }
}

