/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.process.def.EventScript;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class EventScriptBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<EventScript> {
    @Override
    protected String getXml(String defId, String nodeId, EventScript eventScript) {
        String eventType = eventScript.getScriptType().getKey();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:scripts";
        String xScriptPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:scripts/ext:script[@scriptType='" + eventType + "']";
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        String scriptsXml = "<ext:scripts xmlns:ext=\"http://www.jee-soft.cn/bpm\"></ext:scripts>";
        Element parentEl = (Element)root.selectSingleNode(xParentPath);
        Element scriptsEl = (Element)root.selectSingleNode(xPath);
        if (scriptsEl == null) {
            Document scriptDom = Dom4jUtil.loadXml((String)scriptsXml);
            parentEl.add(scriptDom.getRootElement());
        }
        String scriptXML = this.getScriptXml(eventScript);
        DefXmlHandlerUtil.handXmlDom(root, scriptXML, xPath, xScriptPath);
        return root.asXML();
    }

    private String getScriptXml(EventScript eventScript) {
        String script = eventScript.getContent();
        if (StringUtil.isEmpty((String)script)) {
            return "";
        }
        String scriptXml = "<ext:script xmlns:ext=\"http://www.jee-soft.cn/bpm\" scriptType=\"" + eventScript.getScriptType().getKey() + "\"><ext:content><![CDATA[" + script + "]]></ext:content></ext:script>";
        return scriptXml;
    }
}

