/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.uc.dao.DemensionDao;
import com.artfess.uc.dao.OrgUserDao;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OperateLogManager;
import com.artfess.uc.manager.OrgAuthManager;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.PropertiesService;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserGroupManager;
import com.artfess.uc.manager.UserImportManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserParamsManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.OperateLog;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.UcBaseModel;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.params.org.OaAsyncObject;
import com.artfess.uc.params.user.ExcelDataVo;
import com.artfess.uc.params.user.UserImportVo;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OperateLogUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class UserImportManagerImpl
implements UserImportManager {
    protected static Logger logger = LoggerFactory.getLogger(UserImportManagerImpl.class);
    protected static String IMPORT_NEW_SUFFIX = "_imp";
    @Autowired
    private UserDao userDao;
    @Autowired
    OrgUserDao orgUserDao;
    @Autowired
    OrgManager orgService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    PropertiesService propertiesService;
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    UserParamsManager userParamsService;
    @Autowired
    UserGroupManager userGroupService;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    ParamsManager paramsService;
    @Autowired
    UserManager userService;
    @Autowired
    DemensionDao demensionDao;
    @Autowired
    OperateLogManager operateLogService;
    @Autowired
    PwdStrategyManager pwdStrategyManager;
    @Autowired
    PasswordEncoder passwordEncoder;

    @Transactional
    public Map<String, Object> importUser(MultipartFile file, String demId, boolean repeatConver) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        Boolean result = true;
        String preCode = "";
        String console = "";
        String reqUrl = "/api/user/v1/users/importExcelUser";
        Demension demension = (Demension)this.demensionService.get((Serializable)((Object)demId));
        if (BeanUtils.isEmpty((Object)demension)) {
            console = "\u672a\u9009\u62e9\u5bfc\u5165\u7ef4\u5ea6";
            throw new RuntimeException(console);
        }
        preCode = demension.getDemCode();
        ArrayNode logArray = JsonUtil.getMapper().createArrayNode();
        if (file == null || file.isEmpty()) {
            result = false;
            console = "\u6587\u4ef6\u4e3a\u7a7a\uff01";
            throw new RuntimeException(console);
        }
        String fileExt = file.getOriginalFilename().substring(file.getOriginalFilename().indexOf("."));
        if (!fileExt.equalsIgnoreCase(".XLS") && !fileExt.equalsIgnoreCase(".XLSX")) {
            result = false;
            console = "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u662fexcel\u7c7b\u578b\uff01";
            throw new RuntimeException(console);
        }
        Boolean isExcel2003 = true;
        if (fileExt.equalsIgnoreCase(".XLSX")) {
            isExcel2003 = false;
        }
        Object wb = null;
        try (InputStream inputStream = file.getInputStream();){
            wb = isExcel2003.booleanValue() ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        }
        ArrayList<Org> orgList = new ArrayList<Org>();
        ArrayList<User> userList = new ArrayList<User>();
        HashMap<String, User> updUserList = new HashMap<String, User>();
        ArrayList<OrgUser> orgUserList = new ArrayList<OrgUser>();
        ArrayList<OrgPost> orgPostList = new ArrayList<OrgPost>();
        ArrayList<OrgJob> orgJobList = new ArrayList<OrgJob>();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        HashMap<String, String> orgPostAddMap = new HashMap<String, String>();
        HashMap<String, OrgPost> orgPostMapList = new HashMap<String, OrgPost>();
        HashMap<String, String> userMap = new HashMap<String, String>();
        HashMap<String, String> userAccountMap = new HashMap<String, String>();
        HashMap<String, String> isMasterMap = new HashMap<String, String>();
        int sheets = wb.getNumberOfSheets();
        logger.info("\u5f00\u59cb\u5bfc\u5165");
        HashSet<Object> delAccounts = new HashSet();
        List<String> delUser = this.userDao.getDelAccountDatas();
        if (BeanUtils.isNotEmpty(delUser)) {
            delAccounts = new HashSet<String>(delUser);
        }
        ArrayList<ExcelDataVo> excelDataList = new ArrayList<ExcelDataVo>();
        for (int s = 0; s < sheets; ++s) {
            try {
                Sheet sheet = wb.getSheetAt(s);
                if (sheet.getPhysicalNumberOfRows() < 2) {
                    this.doLog(false, reqUrl, "", "sheet" + (s + 1) + "\u6ca1\u6709\u586b\u5199\u6570\u636e!", true, true);
                    return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u6ca1\u6709\u586b\u5199\u6570\u636e!", null);
                }
                HashMap headMap = new HashMap();
                for (int i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
                    Row row = sheet.getRow(0);
                    headMap.put(row.getCell(i).getStringCellValue().trim(), i);
                }
                int begin = sheet.getFirstRowNum();
                int end = sheet.getLastRowNum();
                for (int i = begin + 1; i <= end; ++i) {
                    try {
                        Row row = sheet.getRow(i);
                        if (BeanUtils.isEmpty((Object)row)) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u672a\u5bfc\u5165", null);
                        }
                        if (BeanUtils.isEmpty(headMap.get("\u8d26\u53f7"))) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u4e3a\u7a7a\uff0c\u672a\u5bfc\u5165", null);
                        }
                        Cell cell = row.getCell(((Integer)headMap.get("\u8d26\u53f7")).intValue());
                        if (BeanUtils.isEmpty((Object)cell) || StringUtil.isEmpty((String)cell.getStringCellValue())) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u4e3a\u7a7a\uff0c\u672a\u5bfc\u5165", null);
                        }
                        String accountRegex = "^[a-zA-Z0-9_-]{2,20}$";
                        String userAccount = cell.getStringCellValue().trim().toLowerCase();
                        if (!Pattern.matches(accountRegex, userAccount)) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u6821\u9a8c\u5931\u8d25\uff08\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u6709\u7a7a\u683c\uff09\uff0c\u672a\u5bfc\u5165", userAccount);
                        }
                        if (userAccount.trim().length() > 30) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u957f\u5ea6\u5927\u4e8e30\uff0c\u672a\u5bfc\u5165", userAccount);
                        }
                        String userName = "";
                        if (headMap.get("\u59d3\u540d") == null || !BeanUtils.isNotEmpty((Object)row.getCell(((Integer)headMap.get("\u59d3\u540d")).intValue())) || !StringUtil.isNotEmpty((String)row.getCell(((Integer)headMap.get("\u59d3\u540d")).intValue()).getStringCellValue())) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u59d3\u540d\u4e3a\u7a7a\uff0c\u672a\u5bfc\u5165", null);
                        }
                        userName = row.getCell(((Integer)headMap.get("\u59d3\u540d")).intValue()).getStringCellValue().trim();
                        if (userName.trim().length() > 30) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u59d3\u540d\u957f\u5ea6\u5927\u4e8e30\uff0c\u672a\u5bfc\u5165", userName);
                        }
                        if (!this.checkSameUser(userAccount, userName, userMap)) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u5df2\u5b58\u5728", userAccount);
                        }
                        if (delAccounts.contains(userAccount)) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u8d26\u53f7\u5728\u6570\u636e\u5e93\u4e2d\u5df2\u88ab\u903b\u8f91\u5220\u9664\uff0c\u82e5\u8981\u6dfb\u52a0\u6b64\u8d26\u53f7\u7528\u6237\uff0c\u8bf7\u5148\u7269\u7406\u5220\u9664\u6b64\u6570\u636e", userAccount);
                        }
                        String orgInfo = "";
                        if (BeanUtils.isNotEmpty(headMap.get("\u7ec4\u7ec7\u5355\u5143\u540d\u79f0")) && BeanUtils.isNotEmpty((Object)row.getCell(((Integer)headMap.get("\u7ec4\u7ec7\u5355\u5143\u540d\u79f0")).intValue()))) {
                            orgInfo = row.getCell(((Integer)headMap.get("\u7ec4\u7ec7\u5355\u5143\u540d\u79f0")).intValue()).getStringCellValue().trim();
                        }
                        String sex = "";
                        if (headMap.get("\u6027\u522b") != null && BeanUtils.isNotEmpty((Object)row.getCell(((Integer)headMap.get("\u6027\u522b")).intValue())) && StringUtil.isNotEmpty((String)row.getCell(((Integer)headMap.get("\u6027\u522b")).intValue()).getStringCellValue()) && StringUtil.isNotEmpty((String)(sex = row.getCell(((Integer)headMap.get("\u6027\u522b")).intValue()).getStringCellValue().trim())) && !"\u7537".equals(sex) && !"\u5973".equals(sex) && !"\u672a\u77e5".equals(sex)) {
                            sex = "\u672a\u77e5";
                        }
                        Object userStatus = "";
                        if (headMap.get("\u5458\u5de5\u72b6\u6001") != null && BeanUtils.isNotEmpty((Object)row.getCell(((Integer)headMap.get("\u5458\u5de5\u72b6\u6001")).intValue()))) {
                            row.getCell(((Integer)headMap.get("\u5458\u5de5\u72b6\u6001")).intValue()).setCellType(CellType.STRING);
                            userStatus = row.getCell(((Integer)headMap.get("\u5458\u5de5\u72b6\u6001")).intValue()).getStringCellValue().trim();
                        }
                        String email = "";
                        if (headMap.get("\u90ae\u7bb1") != null && row.getCell(((Integer)headMap.get("\u90ae\u7bb1")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u90ae\u7bb1")).intValue()).setCellType(CellType.STRING);
                            email = row.getCell(((Integer)headMap.get("\u90ae\u7bb1")).intValue()).getStringCellValue();
                            if (StringUtil.isNotEmpty((String)email)) {
                                email = email.toLowerCase();
                            }
                            if (StringUtil.isNotEmpty((String)email) && !this.checkEmail(email)) {
                                return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u672a\u5bfc\u5165\u90ae\u7bb1", email);
                            }
                        }
                        String mobile = "";
                        if (headMap.get("\u624b\u673a\u53f7\u7801") != null && row.getCell(((Integer)headMap.get("\u624b\u673a\u53f7\u7801")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u624b\u673a\u53f7\u7801")).intValue()).setCellType(CellType.STRING);
                            mobile = row.getCell(((Integer)headMap.get("\u624b\u673a\u53f7\u7801")).intValue()).getStringCellValue();
                            if (StringUtil.isNotEmpty((String)mobile) && (!StringUtils.isNumeric((String)mobile) || mobile.trim().length() != 11)) {
                                return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u672a\u5bfc\u5165\u624b\u673a\u53f7\u7801", mobile);
                            }
                        }
                        String isMaster = "";
                        if (headMap.get("\u662f\u5426\u4e3b\u7ec4\u7ec7") != null && row.getCell(((Integer)headMap.get("\u662f\u5426\u4e3b\u7ec4\u7ec7")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u662f\u5426\u4e3b\u7ec4\u7ec7")).intValue()).setCellType(CellType.STRING);
                            isMaster = row.getCell(((Integer)headMap.get("\u662f\u5426\u4e3b\u7ec4\u7ec7")).intValue()).getStringCellValue();
                        }
                        String isCharge = "";
                        if (headMap.get("\u90e8\u95e8\u8d1f\u8d23\u4eba") != null && row.getCell(((Integer)headMap.get("\u90e8\u95e8\u8d1f\u8d23\u4eba")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u90e8\u95e8\u8d1f\u8d23\u4eba")).intValue()).setCellType(CellType.STRING);
                            isCharge = row.getCell(((Integer)headMap.get("\u90e8\u95e8\u8d1f\u8d23\u4eba")).intValue()).getStringCellValue();
                        }
                        if (StringUtil.isEmpty((String)isCharge)) {
                            isCharge = "0";
                        }
                        String address = "";
                        if (headMap.get("\u5730\u5740") != null && row.getCell(((Integer)headMap.get("\u5730\u5740")).intValue()) != null) {
                            address = row.getCell(((Integer)headMap.get("\u5730\u5740")).intValue()).getStringCellValue();
                        }
                        String userNumber = "";
                        if (headMap.get("\u5458\u5de5\u7f16\u53f7") != null && row.getCell(((Integer)headMap.get("\u5458\u5de5\u7f16\u53f7")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u5458\u5de5\u7f16\u53f7")).intValue()).setCellType(CellType.STRING);
                            userNumber = row.getCell(((Integer)headMap.get("\u5458\u5de5\u7f16\u53f7")).intValue()).getStringCellValue().trim();
                        }
                        if (userNumber.trim().length() > 30) {
                            return this.recordLog(logArray, "Excel\u8868\u683csheet" + (s + 1) + "\u7b2c" + (i + 1) + "\u884c\u5458\u5de5\u7f16\u53f7\u957f\u5ea6\u5927\u4e8e30\uff0c\u672a\u5bfc\u5165", userNumber);
                        }
                        String education = "";
                        if (headMap.get("\u5b66\u5386") != null && row.getCell(((Integer)headMap.get("\u5b66\u5386")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u5b66\u5386")).intValue()).setCellType(CellType.STRING);
                            education = row.getCell(((Integer)headMap.get("\u5b66\u5386")).intValue()).getStringCellValue().trim();
                        }
                        Object idCard = "";
                        if (headMap.get("\u8eab\u4efd\u8bc1\u53f7") != null && row.getCell(((Integer)headMap.get("\u8eab\u4efd\u8bc1\u53f7")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u8eab\u4efd\u8bc1\u53f7")).intValue()).setCellType(CellType.STRING);
                            idCard = row.getCell(((Integer)headMap.get("\u8eab\u4efd\u8bc1\u53f7")).intValue()).getStringCellValue().trim();
                        }
                        Date birth = null;
                        if (headMap.get("\u751f\u65e5") != null && row.getCell(((Integer)headMap.get("\u751f\u65e5")).intValue()) != null) {
                            if (row.getCell(((Integer)headMap.get("\u751f\u65e5")).intValue()).getCellType() == CellType.NUMERIC) {
                                birth = HSSFDateUtil.getJavaDate((double)row.getCell(((Integer)headMap.get("\u751f\u65e5")).intValue()).getNumericCellValue());
                            } else if (row.getCell(((Integer)headMap.get("\u751f\u65e5")).intValue()).getCellType() == CellType.STRING) {
                                String birthday = row.getCell(((Integer)headMap.get("\u751f\u65e5")).intValue()).getStringCellValue().trim();
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                birth = sdf.parse(birthday);
                            }
                        }
                        Date entryDate = null;
                        if (headMap.get("\u5165\u804c\u65e5\u671f") != null && row.getCell(((Integer)headMap.get("\u5165\u804c\u65e5\u671f")).intValue()) != null) {
                            if (row.getCell(((Integer)headMap.get("\u5165\u804c\u65e5\u671f")).intValue()).getCellType() == CellType.NUMERIC) {
                                entryDate = HSSFDateUtil.getJavaDate((double)row.getCell(((Integer)headMap.get("\u5165\u804c\u65e5\u671f")).intValue()).getNumericCellValue());
                            } else if (row.getCell(((Integer)headMap.get("\u5165\u804c\u65e5\u671f")).intValue()).getCellType() == CellType.STRING) {
                                String entryDay = row.getCell(((Integer)headMap.get("\u5165\u804c\u65e5\u671f")).intValue()).getStringCellValue().trim();
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                entryDate = sdf.parse(entryDay);
                            }
                        }
                        String phone = "";
                        if (headMap.get("\u7535\u8bdd") != null && row.getCell(((Integer)headMap.get("\u7535\u8bdd")).intValue()) != null) {
                            row.getCell(((Integer)headMap.get("\u7535\u8bdd")).intValue()).setCellType(CellType.STRING);
                            phone = row.getCell(((Integer)headMap.get("\u7535\u8bdd")).intValue()).getStringCellValue();
                        }
                        String jobStr = "";
                        if (headMap.get("\u804c\u52a1") != null && row.getCell(((Integer)headMap.get("\u804c\u52a1")).intValue()) != null) {
                            jobStr = row.getCell(((Integer)headMap.get("\u804c\u52a1")).intValue()).getStringCellValue();
                        }
                        String postStr = "";
                        if (headMap.get("\u5c97\u4f4d") != null && row.getCell(((Integer)headMap.get("\u5c97\u4f4d")).intValue()) != null) {
                            postStr = row.getCell(((Integer)headMap.get("\u5c97\u4f4d")).intValue()).getStringCellValue();
                        }
                        String weixin = "";
                        if (headMap.get("\u5fae\u4fe1\u53f7") != null && row.getCell(((Integer)headMap.get("\u5fae\u4fe1\u53f7")).intValue()) != null) {
                            weixin = row.getCell(((Integer)headMap.get("\u5fae\u4fe1\u53f7")).intValue()).getStringCellValue();
                        }
                        ExcelDataVo vo = new ExcelDataVo(orgInfo, userName, sex, mobile, userAccount, (String)userStatus, address, postStr, jobStr, weixin, email, isCharge, isMaster, userNumber, education, (String)idCard, birth, entryDate, phone);
                        excelDataList.add(vo);
                        continue;
                    }
                    catch (Exception e) {
                        return this.recordLog(logArray, e.getMessage(), "");
                    }
                }
                continue;
            }
            catch (Exception e) {
                logger.error(String.format("\u3010\u5bfc\u5165\u7528\u6237\u65f6\u51fa\u9519\u3011\uff1a%s", ExceptionUtil.getMessage((Throwable)e)));
            }
        }
        if (BeanUtils.isNotEmpty(excelDataList)) {
            ArrayList<String> accounts = new ArrayList<String>();
            ArrayList<String> orgPaths = new ArrayList<String>();
            for (ExcelDataVo excelDataVo : excelDataList) {
                accounts.add(excelDataVo.getAccount());
                if (!StringUtil.isNotEmpty((String)excelDataVo.getOrgName())) continue;
                orgPaths.add(excelDataVo.getOrgName());
            }
            List<User> databaseUserList = this.userService.getByAccounts(accounts);
            HashMap<String, User> accountUserMap = new HashMap<String, User>();
            if (BeanUtils.isNotEmpty(databaseUserList)) {
                for (User user : databaseUserList) {
                    accountUserMap.put(user.getAccount(), user);
                }
            }
            List<Object> databaseOrgList = new ArrayList();
            HashMap<String, List<Org>> pathOrgMap = new HashMap<String, List<Org>>();
            if (BeanUtils.isNotEmpty(orgPaths)) {
                BeanUtils.removeDuplicate(orgPaths);
                databaseOrgList = this.orgService.getByPathNames(orgPaths);
                if (BeanUtils.isNotEmpty(databaseOrgList)) {
                    for (Org org : databaseOrgList) {
                        String pname = org.getPathName();
                        List porgs = null;
                        porgs = pathOrgMap.containsKey(pname) ? (List)pathOrgMap.get(pname) : new ArrayList();
                        porgs.add(org);
                        pathOrgMap.put(pname, porgs);
                    }
                }
            }
            List databaseOrgs = this.orgService.getAll();
            HashMap<String, Org> hashMap = new HashMap<String, Org>();
            if (BeanUtils.isNotEmpty((Object)databaseOrgs)) {
                for (Org org : databaseOrgs) {
                    if ("1".equals(org.getIsDelete())) continue;
                    hashMap.put(org.getCode(), org);
                    String pname = org.getPathName();
                    Object porgs = null;
                    boolean exist = false;
                    if (pathOrgMap.containsKey(pname)) {
                        porgs = (List)pathOrgMap.get(pname);
                        for (Object org2 : databaseOrgs) {
                            if (!((Org)org2).getPathName().equals(pname)) continue;
                            exist = true;
                            break;
                        }
                    } else {
                        porgs = new ArrayList();
                    }
                    if (exist) continue;
                    porgs.add(org);
                    pathOrgMap.put(pname, (List<Org>)porgs);
                }
            }
            HashMap<String, OrgJob> jobCodeMap = new HashMap<String, OrgJob>();
            HashMap<String, List<OrgJob>> jobNameMap = new HashMap<String, List<OrgJob>>();
            List databaseJobs = this.orgJobService.getAll();
            if (BeanUtils.isNotEmpty((Object)databaseJobs)) {
                for (OrgJob orgJob : databaseJobs) {
                    if ("1".equals(orgJob.getIsDelete())) continue;
                    jobCodeMap.put(orgJob.getCode(), orgJob);
                    List<OrgJob> nameJobs = null;
                    nameJobs = jobNameMap.containsKey(orgJob.getName()) ? (List)jobNameMap.get(orgJob.getName()) : new ArrayList<OrgJob>();
                    nameJobs.add(orgJob);
                    jobNameMap.put(orgJob.getName(), nameJobs);
                }
            }
            HashMap<String, List<OrgPost>> postNameMap = new HashMap<String, List<OrgPost>>();
            HashMap<String, Object> postCodeMap = new HashMap<String, Object>();
            List databasePosts = this.orgPostService.getAll();
            if (BeanUtils.isNotEmpty((Object)databasePosts)) {
                for (Object orgPost : databasePosts) {
                    if ("1".equals(((UcBaseModel)orgPost).getIsDelete())) continue;
                    postCodeMap.put(((OrgPost)orgPost).getCode(), orgPost);
                    List<Object> namePosts = null;
                    namePosts = postNameMap.containsKey(((OrgPost)orgPost).getName()) ? (List)postNameMap.get(((OrgPost)orgPost).getName()) : new ArrayList<Object>();
                    namePosts.add(orgPost);
                    postNameMap.put(((OrgPost)orgPost).getName(), namePosts);
                }
            }
            HashMap<String, String> newJobCodeMap = new HashMap<String, String>();
            for (ExcelDataVo excelDataVo : excelDataList) {
                try {
                    Org currentOrg = null;
                    int subIndex = 1;
                    String orgInfo = excelDataVo.getOrgName();
                    List porgs = (List)pathOrgMap.get(orgInfo);
                    if (BeanUtils.isNotEmpty((Object)porgs)) {
                        for (Org porg : porgs) {
                            if (!demId.equals(porg.getDemId())) continue;
                            currentOrg = porg;
                            break;
                        }
                    }
                    if (!orgInfo.startsWith("/")) {
                        subIndex = 0;
                    }
                    if (currentOrg == null) {
                        String[] orgNameArr = orgInfo.substring(subIndex).split("/");
                        HashMap<String, String> pathNameMap = new HashMap<String, String>();
                        for (int j = 0; j <= orgNameArr.length - 1; ++j) {
                            if (j == 0) {
                                pathNameMap.put("\u7236\u7ea7\u8def\u5f84", "");
                                pathNameMap.put("\u5b50\u7ea7\u8def\u5f84", "/" + orgNameArr[j]);
                            } else {
                                pathNameMap.put("\u7236\u7ea7\u8def\u5f84", (String)pathNameMap.get("\u5b50\u7ea7\u8def\u5f84"));
                                pathNameMap.put("\u5b50\u7ea7\u8def\u5f84", (String)pathNameMap.get("\u5b50\u7ea7\u8def\u5f84") + "/" + orgNameArr[j]);
                            }
                            List selectOrgList = (List)pathOrgMap.get(pathNameMap.get("\u5b50\u7ea7\u8def\u5f84"));
                            Org nowOrg = null;
                            if (BeanUtils.isNotEmpty((Object)selectOrgList)) {
                                for (Org org : selectOrgList) {
                                    if (!demId.equals(org.getDemId())) continue;
                                    nowOrg = org;
                                    break;
                                }
                            }
                            if (BeanUtils.isEmpty(nowOrg) && StringUtil.isNotEmpty((String)orgNameArr[j])) {
                                if (j == 0) {
                                    Org org = new Org();
                                    org.setId(UniqueIdUtil.getSuid());
                                    org.setName(orgNameArr[j]);
                                    org.setDemId(demId);
                                    org.setParentId("0");
                                    org.setPathName((String)pathNameMap.get("\u5b50\u7ea7\u8def\u5f84"));
                                    org.setPath(demId + "." + org.getId() + ".");
                                    String code = preCode + "_" + PinyinUtil.getPinYinHeadChar((String)orgNameArr[j]).replace("-", "_");
                                    if (hashMap.containsKey(code) && org.getPathName().equals(((Org)hashMap.get(code)).getPathName())) {
                                        currentOrg = (Org)hashMap.get(code);
                                        continue;
                                    }
                                    if (orgMap.containsKey(code = code + "_" + org.getId().substring(org.getId().length() - 3)) && ((String)pathNameMap.get("\u5b50\u7ea7\u8def\u5f84")).equals(orgMap.get(code))) {
                                        code = code + "_" + org.getId().substring(org.getId().length() - 3);
                                    }
                                    org.setCode(code);
                                    orgMap.put(code, org.getPathName());
                                    currentOrg = this.dealOrg(org, orgList, preCode, orgMap, hashMap);
                                    continue;
                                }
                                currentOrg = this.dealOrgUnder((String)pathNameMap.get("\u7236\u7ea7\u8def\u5f84"), (String)pathNameMap.get("\u5b50\u7ea7\u8def\u5f84"), orgList, demId, preCode, orgMap, pathOrgMap, hashMap);
                                continue;
                            }
                            currentOrg = nowOrg;
                        }
                    }
                    List<OrgJob> currentReldefs = null;
                    if (currentOrg != null && StringUtil.isNotEmpty((String)excelDataVo.getJob())) {
                        currentReldefs = this.dealOrgJob(excelDataVo.getJob(), orgJobList, preCode, jobCodeMap, jobNameMap, newJobCodeMap);
                    }
                    ArrayList<OrgPost> rels = new ArrayList<OrgPost>();
                    if (currentOrg != null && StringUtil.isNotEmpty((String)excelDataVo.getPost()) && BeanUtils.isNotEmpty(currentReldefs)) {
                        String relNameStr = excelDataVo.getPost();
                        String[] relNames = relNameStr.split(";");
                        boolean isOneRelDef = currentReldefs.size() == 1;
                        for (int j = 0; j < relNames.length; ++j) {
                            OrgJob orgJob = isOneRelDef ? currentReldefs.get(0) : currentReldefs.get(j);
                            String relId = UniqueIdUtil.getSuid();
                            String relCode = PinyinUtil.getPinYinHeadChar((String)relNames[j]);
                            String jobCode = orgJob.getCode();
                            String postCode = currentOrg.getCode() + "_" + jobCode + "_" + relCode;
                            OrgPost rel = (OrgPost)postCodeMap.get(postCode);
                            if (BeanUtils.isNotEmpty((Object)rel) && !rel.getName().equals(relNames[j]) && BeanUtils.isEmpty((Object)(rel = this.getByRelNameAndCode(relNames[j], postCode, postNameMap)))) {
                                postCode = postCode + "_" + relId.substring(relId.length() - 3);
                            }
                            if (!isOneRelDef && (j >= currentReldefs.size() || !BeanUtils.isNotEmpty((Object)orgJob))) continue;
                            if (BeanUtils.isEmpty((Object)rel)) {
                                rel = new OrgPost();
                                rel.setId(relId);
                                rel.setRelDefId(orgJob.getId());
                                rel.setOrgId(currentOrg.getId());
                                rel.setCode(postCode);
                                rel.setName(relNames[j]);
                                OrgPost rel2 = (OrgPost)orgPostMapList.get(postCode);
                                if (BeanUtils.isEmpty((Object)rel2)) {
                                    rels.add(rel);
                                    orgPostAddMap.put(rel.getId(), postCode);
                                    orgPostMapList.put(postCode, rel);
                                    continue;
                                }
                                if (!rel.getName().equals(rel2.getName())) {
                                    postCode = postCode + "_" + relId.substring(relId.length() - 3);
                                    rel.setCode(postCode);
                                    rels.add(rel);
                                    orgPostAddMap.put(rel.getId(), postCode);
                                    orgPostMapList.put(postCode, rel);
                                    continue;
                                }
                                rel2.setCode(postCode);
                                rels.add(rel2);
                                continue;
                            }
                            rels.add(rel);
                        }
                    }
                    String account = excelDataVo.getAccount();
                    User user = (User)accountUserMap.get(account);
                    String userStatus = excelDataVo.getStatus();
                    if (BeanUtils.isEmpty((Object)user)) {
                        user = this.findUserFromNews(userList, account);
                        if (BeanUtils.isEmpty((Object)user)) {
                            user = new User();
                            user.setAccount(account.toLowerCase());
                            user.setFullname(excelDataVo.getName());
                            user.setAddress(excelDataVo.getAddress());
                            user.setSex(excelDataVo.getSex());
                            user.setStatus(3);
                            user.setEmail(excelDataVo.getEmail());
                            user.setMobile(excelDataVo.getMobile());
                            user.setPhone(excelDataVo.getPhone());
                            if (BeanUtils.isNotEmpty((Object)excelDataVo.getBirth())) {
                                user.setBirthday(DateFormatUtil.parse((Date)excelDataVo.getBirth()).toLocalDate());
                            }
                            if (BeanUtils.isNotEmpty((Object)excelDataVo.getEntryDate())) {
                                user.setEntryDate(DateFormatUtil.parse((Date)excelDataVo.getEntryDate()).toLocalDate());
                            }
                            user.setEducation(excelDataVo.getEducation());
                            user.setIdCard(excelDataVo.getIdCard());
                            PwdStrategy strategy = this.pwdStrategyManager.getDefault();
                            String defaultPswd = "123456";
                            if (strategy != null) {
                                defaultPswd = strategy.getInitPwd();
                            }
                            user.setPassword(this.passwordEncoder.encode((CharSequence)defaultPswd));
                            user.setFrom("EXCEL");
                            user.setCreateTime(LocalDateTime.now());
                            user.setVersion(1);
                        }
                    } else {
                        if (!user.getFullname().equals(excelDataVo.getName())) {
                            return this.recordLog(logArray, "\u8d26\u53f7\u3010" + account + "\u3011\u5df2\u5b58\u5728", excelDataVo.getName());
                        }
                        user.setFullname(excelDataVo.getName());
                        user.setAddress(excelDataVo.getAddress());
                        user.setSex(excelDataVo.getSex());
                        if ("\u5728\u804c".equals(userStatus) || StringUtil.isEmpty((String)userStatus)) {
                            user.setStatus(1);
                        } else if ("\u79bb\u804c".equals(userStatus)) {
                            user.setStatus(-2);
                        } else if ("\u672a\u6fc0\u6d3b".equals(userStatus)) {
                            user.setStatus(-1);
                        } else {
                            user.setStatus(0);
                        }
                        user.setEmail(excelDataVo.getEmail());
                        user.setMobile(excelDataVo.getMobile());
                        user.setPhone(excelDataVo.getPhone());
                        if (BeanUtils.isNotEmpty((Object)excelDataVo.getBirth())) {
                            user.setBirthday(DateFormatUtil.parse((Date)excelDataVo.getBirth()).toLocalDate());
                        }
                        if (BeanUtils.isNotEmpty((Object)excelDataVo.getEntryDate())) {
                            user.setEntryDate(DateFormatUtil.parse((Date)excelDataVo.getEntryDate()).toLocalDate());
                        }
                        user.setEducation(excelDataVo.getEducation());
                        user.setIdCard(excelDataVo.getIdCard());
                        if (repeatConver) {
                            this.orgUserService.delByUserId(user.getId());
                        }
                        user.setUpdateTime(LocalDateTime.now());
                        Integer v = BeanUtils.isNotEmpty((Object)user.getVersion()) ? user.getVersion() : 1;
                        user.setVersion(v);
                        updUserList.put(user.getAccount(), user);
                    }
                    try {
                        user = this.dealUser(user, userList);
                        userMap.put(user.getAccount(), user.getFullname());
                        userAccountMap.put(user.getUserNumber(), user.getAccount());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this.dealUserOrgPost(user, currentOrg, rels, orgUserList, orgPostList, orgPostAddMap, excelDataVo.getMainOrg(), excelDataVo.getCharge(), isMasterMap, demension.getId());
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    logger.error(String.format("\u3010\u5bfc\u5165\u7528\u6237\u65f6\u51fa\u9519\u3011\uff1a%s", ExceptionUtil.getMessage((Throwable)e)));
                }
            }
            orgPostMapList = null;
            orgMap = null;
            User cuser = ContextUtil.getCurrentUser();
            String roleId = "1";
            Role role = this.roleService.getByAlias("ybry");
            if (BeanUtils.isNotEmpty((Object)role)) {
                roleId = role.getId();
            }
            ArrayList<UserRole> userRoles = new ArrayList<UserRole>();
            if (BeanUtils.isNotEmpty(userList)) {
                for (User u : userList) {
                    String userId = u.getId();
                    UserRole userRole = new UserRole();
                    userRole.setId(UniqueIdUtil.getSuid());
                    userRole.setUserId(userId);
                    userRole.setRoleId(roleId);
                    userRole.setCreateTime(LocalDateTime.now());
                    if (BeanUtils.isNotEmpty((Object)cuser)) {
                        userRole.setCreateBy(cuser.getUserId());
                    }
                    userRoles.add(userRole);
                }
            }
            HashMap codeOrgMaps = new HashMap();
            if (BeanUtils.isNotEmpty(orgList)) {
                for (Org o : orgList) {
                    String code = o.getCode();
                    if (hashMap.containsKey(code)) {
                        System.out.println(code);
                    }
                    List porgs = null;
                    porgs = codeOrgMaps.containsKey(code) ? (List)pathOrgMap.get(code) : new ArrayList();
                    porgs.add(o);
                    pathOrgMap.put(code, porgs);
                }
            }
            if (BeanUtils.isNotEmpty(userList)) {
                this.userService.insertBatch(userList);
            }
            if (BeanUtils.isNotEmpty(updUserList.values())) {
                for (User user : updUserList.values()) {
                    this.userService.update((Model)user);
                }
            }
            if (BeanUtils.isNotEmpty(userRoles)) {
                this.userRoleService.insertBatch(userRoles);
            }
            if (BeanUtils.isNotEmpty(orgList)) {
                this.orgService.insertBatch(orgList);
            }
            if (BeanUtils.isNotEmpty(orgJobList)) {
                this.orgJobService.insertBatch(orgJobList);
            }
            if (BeanUtils.isNotEmpty(orgPostList)) {
                this.orgPostService.insertBatch(orgPostList);
            }
            if (BeanUtils.isNotEmpty(orgUserList)) {
                this.orgUserService.insertBatch(orgUserList);
                this.orgUserService.removeMores();
            }
        }
        if (BeanUtils.isEmpty(userList) && BeanUtils.isEmpty(orgList) && BeanUtils.isEmpty(updUserList) && BeanUtils.isEmpty(orgPostList) && BeanUtils.isEmpty(orgJobList) && BeanUtils.isEmpty(orgUserList)) {
            result = false;
            console = "\u672a\u5bfc\u5165\u6216\u66f4\u65b0\u4efb\u4f55\u7528\u6237\u3001\u7ec4\u7ec7\u4fe1\u606f\uff01";
        }
        logger.info("\u5bfc\u5165\u5b8c\u6210");
        rtnMap.put("result", result);
        rtnMap.put("console", console);
        rtnMap.put("log", logArray);
        return rtnMap;
    }

    private boolean checkSameUser(String account, String name, Map<String, String> userMap) {
        String mapName = userMap.get(account);
        if (StringUtil.isNotEmpty((String)mapName) && !mapName.equals(name)) {
            return false;
        }
        User user = this.userDao.getByAccount(account);
        return !BeanUtils.isNotEmpty((Object)user) || user.getFullname().equals(name);
    }

    private boolean checkSameUserNumber(String userNumber, String account, Map<String, String> userAccountMap) {
        String mapAccount = userAccountMap.get(userNumber);
        if (StringUtil.isNotEmpty((String)mapAccount) && !mapAccount.equals(account)) {
            return false;
        }
        User user = this.userDao.getByNumber(userNumber);
        return !BeanUtils.isNotEmpty((Object)user) || user.getAccount().equals(account);
    }

    private User findUserFromNews(List<User> users, String account) {
        for (User user : users) {
            if (!user.getAccount().equals(account)) continue;
            return user;
        }
        return null;
    }

    private Map<String, Object> recordLog(ArrayNode logArray, String msg, Object param) throws IOException {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        String reqUrl = "/api/user/v1/users/importExcelUser";
        this.doLog(false, reqUrl, BeanUtils.isNotEmpty((Object)param) ? JsonUtil.toJsonNode((Object)param) : "", msg, true, true);
        rtnMap.put("result", false);
        rtnMap.put("console", "\u5bfc\u5165\u5931\u8d25\uff1a" + msg);
        rtnMap.put("log", msg);
        return rtnMap;
    }

    private boolean checkEmail(String email) {
        try {
            String check = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
            Pattern regex = Pattern.compile(check);
            Matcher matcher = regex.matcher(email);
            return matcher.matches();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Org dealOrg(Org org, List<Org> orgList, String preCode, Map<String, String> orgMap, Map<String, Org> orgCodeMap) {
        Org rtn = null;
        if (BeanUtils.isEmpty(orgList)) {
            if (orgMap.containsKey(org.getCode()) && !org.getPathName().equals(orgMap.get(org.getCode()))) {
                org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
            }
            orgList.add(org);
            orgMap.put(org.getCode(), org.getPathName());
            rtn = org;
        } else {
            Boolean flag = true;
            for (int i = 0; i < orgList.size(); ++i) {
                Org systemOrg;
                if (orgList.get(i).getPathName().equals(org.getPathName())) {
                    flag = false;
                    rtn = orgList.get(i);
                }
                if (orgList.get(i).getName().equals(org.getName()) && orgList.get(i) != org) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + org.getId().substring(org.getId().length() - 3));
                }
                if (BeanUtils.isNotEmpty((Object)(systemOrg = orgCodeMap.get(org.getCode())))) {
                    org.setCode(preCode + "_" + PinyinUtil.getPinYinHeadChar((String)org.getName()) + org.getId().substring(org.getId().length() - 3) + (i + 1));
                }
                if (i != orgList.size() - 1 || !flag.booleanValue()) continue;
                if (BeanUtils.isNotEmpty((Object)orgMap.get(org.getCode()))) {
                    org.setCode(org.getCode() + "_" + org.getId().substring(org.getId().length() - 3));
                }
                orgList.add(org);
                orgMap.put(org.getCode(), org.getId());
                rtn = org;
            }
        }
        return rtn;
    }

    public Org dealOrgUnder(String supperPathName, String underPathName, List<Org> orgList, String demId, String preCode, Map<String, String> orgMap, Map<String, List<Org>> pathOrgMap, Map<String, Org> orgCodeMap) {
        String underName = underPathName.substring(underPathName.lastIndexOf("/") + 1);
        List<Org> chirList = pathOrgMap.get(underPathName);
        if (BeanUtils.isNotEmpty(chirList)) {
            for (Org org : chirList) {
                if (!demId.equals(org.getDemId())) continue;
                return org;
            }
        }
        List<Org> pList = pathOrgMap.get(supperPathName);
        ArrayList<Org> parentList = new ArrayList<Org>();
        if (BeanUtils.isNotEmpty(pList)) {
            for (Org org : pList) {
                if (!demId.equals(org.getDemId())) continue;
                parentList.add(org);
            }
        }
        Org chird = new Org();
        if (BeanUtils.isEmpty(parentList)) {
            for (int i = 0; i < orgList.size(); ++i) {
                if (!orgList.get(i).getPathName().equals(supperPathName)) continue;
                chird.setId(UniqueIdUtil.getSuid());
                chird.setParentId(orgList.get(i).getId());
                chird.setDemId(demId);
                chird.setName(underName);
                chird.setPathName(underPathName);
                chird.setPath(orgList.get(i).getPath() + chird.getId() + ".");
                String code = preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName);
                if (orgMap.containsKey(code) && !chird.getPathName().equals(orgMap.get(code))) {
                    code = code + "_" + chird.getId().substring(chird.getId().length() - 3);
                }
                chird.setCode(code);
            }
        } else {
            chird.setId(UniqueIdUtil.getSuid());
            chird.setParentId(((Org)parentList.get(0)).getId());
            chird.setDemId(demId);
            chird.setName(underName);
            chird.setPathName(underPathName);
            chird.setPath(((Org)parentList.get(0)).getPath() + chird.getId() + ".");
            String code = preCode + "_" + PinyinUtil.getPinYinHeadChar((String)underName);
            if (orgMap.containsKey(code) && !chird.getPathName().equals(orgMap.get(code))) {
                code = code + "_" + chird.getId().substring(chird.getId().length() - 3);
            }
            chird.setCode(code);
        }
        return this.dealOrg(chird, orgList, preCode, orgMap, orgCodeMap);
    }

    public List<OrgJob> dealOrgJob(String reldefNameStr, List<OrgJob> orgJobList, String preCode, Map<String, OrgJob> jobCodeMap, Map<String, List<OrgJob>> jobNameMap, Map<String, String> newJobCodeMap) {
        if (StringUtil.isEmpty((String)reldefNameStr)) {
            return null;
        }
        String[] reldefNames = reldefNameStr.split(";");
        ArrayList<OrgJob> rtn = new ArrayList<OrgJob>();
        for (String reldefName : reldefNames) {
            OrgJob reldef = null;
            List<OrgJob> selectList = jobNameMap.get(reldefName);
            if (BeanUtils.isNotEmpty(selectList)) {
                reldef = selectList.get(0);
            } else {
                Boolean flag = true;
                reldef = new OrgJob();
                reldef.setId(UniqueIdUtil.getSuid());
                String code = PinyinUtil.getPinYinHeadChar((String)reldefName);
                if (newJobCodeMap.containsKey(code) && !reldefName.equals(newJobCodeMap.get(code))) {
                    code = code + "_" + reldef.getId().substring(reldef.getId().length() - 3);
                }
                newJobCodeMap.put(code, reldefName);
                reldef.setCode(code);
                reldef.setName(reldefName);
                OrgJob sysOrgJob = jobCodeMap.get(reldef.getCode());
                if (BeanUtils.isNotEmpty((Object)sysOrgJob)) {
                    reldef.setCode(reldef.getCode() + reldef.getId());
                }
                if (BeanUtils.isEmpty(orgJobList)) {
                    orgJobList.add(reldef);
                } else {
                    for (int i = 0; i < orgJobList.size(); ++i) {
                        if (orgJobList.get(i).getName().equals(reldefName)) {
                            flag = false;
                            reldef = orgJobList.get(i);
                        }
                        if (i != orgJobList.size() - 1 || !flag.booleanValue()) continue;
                        orgJobList.add(reldef);
                    }
                }
            }
            if (!BeanUtils.isNotEmpty((Object)reldef)) continue;
            rtn.add(reldef);
        }
        return rtn;
    }

    public User dealUser(User user, List<User> userList) throws Exception {
        User rtn = new User();
        if (StringUtil.isNotEmpty((String)user.getId())) {
            rtn = user;
        } else {
            Boolean flag = true;
            if (BeanUtils.isEmpty(userList)) {
                user.setId(UniqueIdUtil.getSuid());
                rtn = user;
                userList.add(user);
            } else {
                for (int i = 0; i < userList.size(); ++i) {
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) != user) {
                        logger.info("Excel\u8868\u683c\u4e2d\u7528\u6237\u8d26\u53f7\u91cd\u590d\uff1a" + userList.get(i).getAccount());
                    }
                    if (userList.get(i).getAccount().equals(user.getAccount()) && userList.get(i) == user) {
                        flag = false;
                        rtn = userList.get(i);
                    }
                    if (i != userList.size() - 1 || !flag.booleanValue()) continue;
                    user.setId(UniqueIdUtil.getSuid());
                    rtn = user;
                    userList.add(user);
                }
            }
        }
        return rtn;
    }

    public void dealUserOrgPost(User user, Org org, List<OrgPost> orgPosts, List<OrgUser> orgUserList, List<OrgPost> orgPostList, Map<String, String> orgPostAddMap, String isMaster, String isCharge, Map<String, String> isMasterMap, String demId) throws SQLException {
        if (BeanUtils.isEmpty((Object)org)) {
            return;
        }
        if (BeanUtils.isNotEmpty(orgPosts)) {
            for (OrgPost orgPost : orgPosts) {
                OrgUser orgUser = new OrgUser();
                if (StringUtil.isNotEmpty((String)orgPostAddMap.get(orgPost.getId()))) {
                    Boolean flag = true;
                    if (BeanUtils.isEmpty(orgPostList)) {
                        orgPostList.add(orgPost);
                    } else {
                        for (int i = 0; i < orgPostList.size(); ++i) {
                            if (orgPostList.get(i).getOrgId().equals(orgPost.getOrgId()) && orgPostList.get(i).getName().equals(orgPost.getName())) {
                                orgPost = orgPostList.get(i);
                                flag = false;
                            }
                            if (!flag.booleanValue() || i != orgPostList.size() - 1) continue;
                            orgPostList.add(orgPost);
                        }
                    }
                }
                QueryFilter filter = QueryFilter.build();
                filter.addFilter("orgId", (Object)orgPost.getOrgId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("relId", (Object)orgPost.getId(), QueryOP.EQUAL, FieldRelation.AND);
                List sysOrgUserList = this.orgUserService.query(filter).getRows();
                if (!BeanUtils.isEmpty((Object)sysOrgUserList)) continue;
                orgUser.setId(UniqueIdUtil.getSuid());
                orgUser.setOrgId(orgPost.getOrgId());
                orgUser.setRelId(orgPost.getId());
                orgUser.setUserId(user.getId());
                this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
                orgUserList.add(orgUser);
            }
        }
        OrgUser orgUser = new OrgUser();
        QueryFilter filter = QueryFilter.build();
        filter.addFilter("userId", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
        filter.addFilter("orgId", (Object)org.getId(), QueryOP.EQUAL, FieldRelation.AND);
        List sysOrgUserList = this.orgUserService.query(filter).getRows();
        boolean isExitOrg = false;
        for (OrgUser orgUser2 : sysOrgUserList) {
            if (!BeanUtils.isEmpty((Object)orgUser2.getRelId())) continue;
            isExitOrg = true;
        }
        if (!isExitOrg) {
            orgUser.setId(UniqueIdUtil.getSuid());
            orgUser.setOrgId(org.getId());
            orgUser.setUserId(user.getId());
            this.dealMasterAndCharge(isMaster, isCharge, orgUser, isMasterMap, demId);
            orgUserList.add(orgUser);
        }
    }

    private void dealMasterAndCharge(String isMaster, String isCharge, OrgUser orgUser, Map<String, String> isMasterMap, String demId) {
        if (StringUtil.isNotEmpty((String)isMaster) && (isMaster.equals("1") || isMaster.equals("\u662f")) && this.hasMaster(orgUser.getUserId(), orgUser.getOrgId(), demId) && StringUtil.isEmpty((String)isMasterMap.get(orgUser.getUserId() + "_" + demId))) {
            orgUser.setIsMaster(1);
            isMasterMap.put(orgUser.getUserId() + "_" + demId, "1");
        } else {
            orgUser.setIsMaster(0);
        }
        if (StringUtil.isNotEmpty((String)isCharge)) {
            if (isCharge.equals("1")) {
                orgUser.setIsCharge(1);
            } else if (isCharge.equals("2") && BeanUtils.isEmpty(this.orgUserDao.getChargesByOrgId(orgUser.getOrgId(), 2))) {
                orgUser.setIsCharge(2);
            }
        } else {
            orgUser.setIsCharge(0);
        }
    }

    private boolean hasMaster(String userId, String orgId, String demId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        List<OrgUser> orgUsers = this.orgUserDao.getByParms(map);
        if (BeanUtils.isNotEmpty(orgUsers)) {
            for (OrgUser orgUser : orgUsers) {
                Org org;
                if (orgUser.getOrgId().equals(orgId) || orgUser.getIsMaster() != 1 || !BeanUtils.isNotEmpty((Object)(org = (Org)this.orgService.get((Serializable)((Object)orgUser.getOrgId())))) || !org.getDemId().equals(demId)) continue;
                return false;
            }
        }
        return true;
    }

    private OrgPost getByRelNameAndCode(String name, String code, Map<String, List<OrgPost>> postNameMap) {
        List<OrgPost> orgPosts = postNameMap.get(name);
        if (BeanUtils.isNotEmpty(orgPosts)) {
            for (OrgPost orgPost : orgPosts) {
                if (!orgPost.getCode().startsWith(code)) continue;
                return orgPost;
            }
        }
        return null;
    }

    @Transactional
    private void bindRole(User user) {
        if (BeanUtils.isNotEmpty((Object)user)) {
            String userId = user.getId();
            if (this.userRoleService.getByRoleIdUserId("1", userId) != null) {
                return;
            }
            UserRole userRole = new UserRole();
            userRole.setId(UniqueIdUtil.getSuid());
            userRole.setUserId(userId);
            userRole.setRoleId("1");
            this.userRoleService.create((Model)userRole);
        }
    }

    @Override
    @Transactional
    public CommonResult<String> importExcelUser(MultipartFile file, String demCode, boolean repeatConver) {
        try {
            Demension demension = this.demensionDao.getByCode(demCode);
            if (BeanUtils.isEmpty((Object)demension)) {
                return new CommonResult(false, "\u6839\u636e\u7ef4\u5ea6\u7f16\u7801\u3010" + demCode + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\uff01", (Object)"");
            }
            Map<String, Object> rtn = this.importUser(file, demension.getId(), repeatConver);
            Boolean isTrue = (Boolean)rtn.get("result");
            String msg = isTrue != false ? "\u5bfc\u5165\u6210\u529f\uff01" : "\u5bfc\u5165\u5931\u8d25";
            String log = BeanUtils.isNotEmpty((Object)rtn.get("console")) ? rtn.get("console").toString() : "";
            return new CommonResult(isTrue.booleanValue(), msg, (Object)log);
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage(), (Object)"");
        }
    }

    @Override
    @Transactional
    public CommonResult<String> importZipUser(MultipartFile file, UserImportVo importVo) throws Exception {
        try {
            String fileDir = StringUtil.substringBeforeLast((String)file.getOriginalFilename(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String unZipFilePath = rootRealPath + File.separator + fileDir;
            HashMap<String, String> errUserIds = new HashMap<String, String>();
            this.importUser(importVo, unZipFilePath, errUserIds);
            if (importVo.isOrg()) {
                HashMap<String, String> errDemIds = new HashMap<String, String>();
                HashMap<String, String> errOrgIds = new HashMap<String, String>();
                HashMap<String, String> errJobIds = new HashMap<String, String>();
                HashMap<String, String> errPostIds = new HashMap<String, String>();
                this.importDemension(importVo, unZipFilePath, errDemIds);
                this.importOrg(importVo, unZipFilePath, errDemIds, errOrgIds);
                this.importJob(importVo, unZipFilePath, errJobIds);
                this.importPost(importVo, unZipFilePath, errOrgIds, errJobIds, errPostIds);
                this.importOrgUser(importVo, unZipFilePath, errUserIds, errOrgIds, errPostIds);
            }
            if (importVo.isRole()) {
                HashMap<String, String> errRoleIds = new HashMap<String, String>();
                this.importRole(importVo, unZipFilePath, errRoleIds);
                this.importUserRole(importVo, unZipFilePath, errRoleIds, errUserIds);
            }
            FileUtil.deleteDir((File)new File(unZipFilePath));
            return new CommonResult(true, "\u6570\u636e\u5bfc\u5165\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(true, "\u6570\u636e\u5bfc\u5165\u5931\u8d25\uff01" + e.getMessage(), (Object)"");
        }
    }

    @Transactional
    private void importUser(UserImportVo importVo, String unZipFilePath, Map<String, String> errUserIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "user");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String fullname = null;
                User user = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    fullname = (String)this.getCellValue(headMap, row, "fullname", "String");
                    String account = (String)this.getCellValue(headMap, row, "account", "String");
                    String userNumber = (String)this.getCellValue(headMap, row, "userNumber", "String");
                    user = (User)this.userService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)user)) {
                        if (user.getAccount().equals(account) || StringUtil.isNotEmpty((String)userNumber) && userNumber.equals(user.getUserNumber())) {
                            if (!importVo.isCover()) {
                                continue;
                            }
                        } else {
                            String newId = UniqueIdUtil.getSuid();
                            user.setId(newId);
                            errUserIds.put(id, newId);
                        }
                    } else {
                        user = this.userService.getByAccount(account);
                        if (BeanUtils.isNotEmpty((Object)user)) {
                            if (user.getFullname().equals(fullname)) continue;
                            this.doLog(false, "/api/user/v1/users/importZipUser", fullname, "\u8d26\u53f7\u76f8\u540c\uff0c\u59d3\u540d\u4e0d\u540c", false, isAdd);
                            System.out.println("\u8d26\u53f7\u76f8\u540c\uff0c\u59d3\u540d\u4e0d\u540c");
                            errUserIds.put(id, id);
                            continue;
                        }
                        user = this.userService.getByNumber(userNumber);
                        if (BeanUtils.isNotEmpty((Object)user)) {
                            if (user.getFullname().equals(fullname)) continue;
                            this.doLog(false, "/api/user/v1/users/importZipUser", userNumber, "\u5de5\u53f7\u76f8\u540c\uff0c\u59d3\u540d\u4e0d\u540c", false, isAdd);
                            System.out.println("\u5de5\u53f7\u76f8\u540c\uff0c\u59d3\u540d\u4e0d\u540c");
                            errUserIds.put(id, id);
                            continue;
                        }
                    }
                    if (BeanUtils.isEmpty((Object)user)) {
                        user = new User();
                        isAdd = true;
                    }
                    String password = (String)this.getCellValue(headMap, row, "password", "String");
                    String email = (String)this.getCellValue(headMap, row, "email", "String");
                    String mobile = (String)this.getCellValue(headMap, row, "mobile", "String");
                    LocalDateTime createTime = (LocalDateTime)this.getCellValue(headMap, row, "createTime", "datetime");
                    String address = (String)this.getCellValue(headMap, row, "address", "String");
                    String photo = (String)this.getCellValue(headMap, row, "photo", "String");
                    String sex = (String)this.getCellValue(headMap, row, "sex", "String");
                    String from = (String)this.getCellValue(headMap, row, "from", "String");
                    Integer status = (Integer)this.getCellValue(headMap, row, "status", "int");
                    Integer hasSyncToWx = (Integer)this.getCellValue(headMap, row, "hasSyncToWx", "int");
                    String notifyType = (String)this.getCellValue(headMap, row, "notifyType", "String");
                    String idCard = (String)this.getCellValue(headMap, row, "idCard", "String");
                    String phone = (String)this.getCellValue(headMap, row, "phone", "String");
                    LocalDate birthday = (LocalDate)this.getCellValue(headMap, row, "birthday", "date");
                    LocalDate entryDate = (LocalDate)this.getCellValue(headMap, row, "entryDate", "date");
                    String education = (String)this.getCellValue(headMap, row, "education", "String");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    if (isAdd || !isAdd && importVo.isCover()) {
                        user.setAccount(account.toLowerCase());
                        user.setUserNumber(userNumber);
                        user.setFullname(fullname);
                        user.setPassword(password);
                        user.setEmail(email);
                        user.setMobile(mobile);
                        user.setCreateTime(createTime);
                        user.setAddress(address);
                        user.setPhoto(photo);
                        user.setSex(sex);
                        user.setFrom(from);
                        user.setStatus(status);
                        user.setHasSyncToWx(hasSyncToWx);
                        user.setNotifyType(notifyType);
                        user.setIdCard(idCard);
                        user.setPhone(phone);
                        user.setBirthday(birthday);
                        user.setEntryDate(entryDate);
                        user.setEducation(education);
                        user.setUpdateTime(updateTime);
                        user.setIsDelete(isDelete);
                    }
                    if (isAdd) {
                        user.setId(id);
                        this.userService.create((Model)user);
                        this.doLog(true, "/api/user/v1/users/importZipUser", user, "", false, isAdd);
                        continue;
                    }
                    if (!importVo.isCover()) continue;
                    this.userService.update((Model)user);
                    this.doLog(true, "/api/user/v1/users/importZipUser", user, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", user, "\u7528\u6237\u3010" + fullname + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.info("\u7528\u6237\u3010" + fullname + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importDemension(UserImportVo importVo, String unZipFilePath, Map<String, String> errDemIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "demension");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String demName = null;
                Demension dem = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    String demCode = (String)this.getCellValue(headMap, row, "demCode", "String");
                    demName = (String)this.getCellValue(headMap, row, "demName", "String");
                    dem = (Demension)this.demensionService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)dem)) {
                        if (!dem.getDemCode().equals(demCode)) {
                            String newId;
                            id = newId = UniqueIdUtil.getSuid();
                            errDemIds.put(id, newId);
                            dem = null;
                        }
                    } else {
                        dem = this.demensionDao.getByCode(demCode);
                        if (BeanUtils.isNotEmpty((Object)dem)) {
                            if (!dem.getDemName().equals(demName)) {
                                demCode = demCode + IMPORT_NEW_SUFFIX;
                            } else {
                                errDemIds.put(id, dem.getId());
                            }
                        }
                    }
                    if (BeanUtils.isEmpty((Object)dem)) {
                        dem = new Demension();
                        dem.setId(id);
                        isAdd = true;
                    }
                    if (!isAdd && (isAdd || !importVo.isCover())) continue;
                    String demDesc = (String)this.getCellValue(headMap, row, "demDesc", "String");
                    Integer isDefault = (Integer)this.getCellValue(headMap, row, "isDefault", "int");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    dem.setDemCode(demCode);
                    dem.setDemDesc(demDesc);
                    dem.setDemName(demName);
                    dem.setIsDefault(isDefault);
                    dem.setUpdateTime(updateTime);
                    dem.setIsDelete(isDelete);
                    if (isAdd) {
                        this.demensionService.create((Model)dem);
                        this.doLog(true, "/api/user/v1/users/importZipUser", dem, "", false, isAdd);
                        continue;
                    }
                    this.demensionService.update((Model)dem);
                    this.doLog(true, "/api/user/v1/users/importZipUser", dem, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", dem, "\u7ef4\u5ea6\u3010" + demName + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, false);
                    logger.error("\u7ef4\u5ea6\u3010" + demName + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importOrg(UserImportVo importVo, String unZipFilePath, Map<String, String> errDemIds, Map<String, String> errOrgIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "org");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String name = null;
                Org org = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    name = (String)this.getCellValue(headMap, row, "name", "String");
                    String code = (String)this.getCellValue(headMap, row, "code", "String");
                    String parentId = (String)this.getCellValue(headMap, row, "parentId", "String");
                    org = (Org)this.orgService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)org)) {
                        if (!org.getCode().equals(code)) {
                            String newId;
                            id = newId = UniqueIdUtil.getSuid();
                            errOrgIds.put(id, newId);
                            org = null;
                        }
                    } else {
                        org = this.orgService.getByCode(code);
                        if (BeanUtils.isNotEmpty((Object)org)) {
                            if (!org.getName().equals(name)) {
                                code = code + IMPORT_NEW_SUFFIX;
                            } else {
                                errOrgIds.put(id, org.getId());
                            }
                        }
                    }
                    if (BeanUtils.isEmpty((Object)org)) {
                        org = new Org();
                        org.setId(id);
                        isAdd = true;
                    }
                    if (!isAdd && (isAdd || !importVo.isCover())) continue;
                    String grade = (String)this.getCellValue(headMap, row, "grade", "String");
                    String demId = (String)this.getCellValue(headMap, row, "demId", "String");
                    Object orderNoStr = this.getCellValue(headMap, row, "orderNo", "String");
                    Long orderNo = BeanUtils.isEmpty((Object)orderNoStr) ? null : Long.valueOf(Long.parseLong((String)orderNoStr));
                    String path = (String)this.getCellValue(headMap, row, "path", "String");
                    String pathName = (String)this.getCellValue(headMap, row, "pathName", "String");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    org.setCode(code);
                    org.setName(name);
                    org.setDemId(StringUtil.isNotEmpty((String)errDemIds.get(demId)) ? errDemIds.get(demId) : demId);
                    org.setParentId(parentId);
                    org.setGrade(grade);
                    org.setOrderNo(orderNo);
                    org.setPath(path);
                    org.setPathName(pathName);
                    org.setUpdateTime(updateTime);
                    org.setIsDelete(isDelete);
                    if (isAdd) {
                        this.orgService.create((Model)org);
                        this.doLog(true, "/api/user/v1/users/importZipUser", org, "", false, isAdd);
                        continue;
                    }
                    this.orgService.update((Model)org);
                    this.doLog(true, "/api/user/v1/users/importZipUser", org, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", org, "\u7ec4\u7ec7\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u7ec4\u7ec7\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importOrgUser(UserImportVo importVo, String unZipFilePath, Map<String, String> errUserIds, Map<String, String> errOrgIds, Map<String, String> errPostIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "orgUser");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String id = null;
                OrgUser orgUser = null;
                try {
                    Row row = sheet.getRow(i);
                    id = (String)this.getCellValue(headMap, row, "id", "String");
                    orgUser = (OrgUser)this.orgUserService.get((Serializable)((Object)id));
                    boolean isAdd = false;
                    if (BeanUtils.isEmpty((Object)orgUser)) {
                        isAdd = true;
                        orgUser = new OrgUser();
                        orgUser.setId(UniqueIdUtil.getSuid());
                    }
                    String orgId = (String)this.getCellValue(headMap, row, "orgId", "String");
                    String userId = (String)this.getCellValue(headMap, row, "userId", "String");
                    String relId = (String)this.getCellValue(headMap, row, "relId", "String");
                    Integer isMaster = (Integer)this.getCellValue(headMap, row, "isMaster", "int");
                    Integer isCharge = (Integer)this.getCellValue(headMap, row, "isCharge", "int");
                    LocalDateTime startDate = (LocalDateTime)this.getCellValue(headMap, row, "startDate", "date");
                    LocalDateTime endDate = (LocalDateTime)this.getCellValue(headMap, row, "endDate", "date");
                    Integer isRelActive = (Integer)this.getCellValue(headMap, row, "isRelActive", "int");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    orgUser.setOrgId(StringUtil.isNotEmpty((String)errOrgIds.get(orgId)) ? errOrgIds.get(orgId) : orgId);
                    orgUser.setUserId(StringUtil.isNotEmpty((String)errUserIds.get(userId)) ? errUserIds.get(userId) : userId);
                    orgUser.setRelId(StringUtil.isNotEmpty((String)errPostIds.get(relId)) ? errPostIds.get(relId) : relId);
                    orgUser.setIsMaster(isMaster);
                    orgUser.setIsCharge(isCharge);
                    orgUser.setStartDate(startDate);
                    orgUser.setEndDate(endDate);
                    orgUser.setIsRelActive(isRelActive);
                    orgUser.setUpdateTime(updateTime);
                    orgUser.setIsDelete(isDelete);
                    if (isAdd) {
                        this.orgUserService.create((Model)orgUser);
                        this.doLog(true, "/api/user/v1/users/importZipUser", orgUser, "", false, isAdd);
                        continue;
                    }
                    this.orgUserService.update((Model)orgUser);
                    this.doLog(true, "/api/user/v1/users/importZipUser", orgUser, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", orgUser, "\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbId\u4e3a\u3010" + id + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u7528\u6237\u7ec4\u7ec7\u5173\u7cfbId\u4e3a\u3010" + id + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importJob(UserImportVo importVo, String unZipFilePath, Map<String, String> errJobIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "job");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String name = null;
                OrgJob job = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    name = (String)this.getCellValue(headMap, row, "name", "String");
                    String code = (String)this.getCellValue(headMap, row, "code", "String");
                    job = (OrgJob)this.orgJobService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)job)) {
                        if (!job.getCode().equals(code)) {
                            String newId;
                            id = newId = UniqueIdUtil.getSuid();
                            errJobIds.put(id, newId);
                            job = null;
                        }
                    } else {
                        job = this.orgJobService.getByCode(code);
                        if (BeanUtils.isNotEmpty((Object)job)) {
                            if (!job.getName().equals(name)) {
                                code = code + IMPORT_NEW_SUFFIX;
                            } else {
                                errJobIds.put(id, job.getId());
                            }
                        }
                    }
                    if (BeanUtils.isEmpty((Object)job)) {
                        job = new OrgJob();
                        job.setId(id);
                        isAdd = true;
                    }
                    if (!isAdd && (isAdd || !importVo.isCover())) continue;
                    String postLevel = (String)this.getCellValue(headMap, row, "postLevel", "String");
                    String description = (String)this.getCellValue(headMap, row, "description", "String");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    job.setCode(code);
                    job.setName(name);
                    job.setPostLevel(postLevel);
                    job.setDescription(description);
                    job.setUpdateTime(updateTime);
                    job.setIsDelete(isDelete);
                    if (isAdd) {
                        this.orgJobService.create((Model)job);
                        this.doLog(true, "/api/user/v1/users/importZipUser", job, "", false, isAdd);
                        continue;
                    }
                    this.orgJobService.update((Model)job);
                    this.doLog(true, "/api/user/v1/users/importZipUser", job, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", job, "\u804c\u52a1\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u804c\u52a1\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importPost(UserImportVo importVo, String unZipFilePath, Map<String, String> errOrgIds, Map<String, String> errJobIds, Map<String, String> errPostIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "post");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String relName = null;
                OrgPost post = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    relName = (String)this.getCellValue(headMap, row, "relName", "String");
                    String relCode = (String)this.getCellValue(headMap, row, "relCode", "String");
                    post = (OrgPost)this.orgPostService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)post)) {
                        if (!post.getCode().equals(relCode)) {
                            String newId;
                            id = newId = UniqueIdUtil.getSuid();
                            errPostIds.put(id, newId);
                            post = null;
                        }
                    } else {
                        post = this.orgPostService.getByCode(relCode);
                        if (BeanUtils.isNotEmpty((Object)post)) {
                            if (!post.getName().equals(relName)) {
                                relCode = relCode + IMPORT_NEW_SUFFIX;
                            } else {
                                errPostIds.put(id, post.getId());
                            }
                        }
                    }
                    if (BeanUtils.isEmpty((Object)post)) {
                        post = new OrgPost();
                        post.setId(id);
                        isAdd = true;
                    }
                    if (!isAdd && (isAdd || !importVo.isCover())) continue;
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    String orgId = (String)this.getCellValue(headMap, row, "orgId", "String");
                    String relDefId = (String)this.getCellValue(headMap, row, "relDefId", "String");
                    Integer isCharge = (Integer)this.getCellValue(headMap, row, "isCharge", "int");
                    post.setCode(relCode);
                    post.setName(relName);
                    post.setOrgId(StringUtil.isNotEmpty((String)errOrgIds.get(orgId)) ? errOrgIds.get(orgId) : orgId);
                    post.setRelDefId(StringUtil.isNotEmpty((String)errJobIds.get(relDefId)) ? errJobIds.get(relDefId) : relDefId);
                    post.setIsCharge(isCharge);
                    post.setUpdateTime(updateTime);
                    post.setIsDelete(isDelete);
                    if (isAdd) {
                        this.orgPostService.create((Model)post);
                        this.doLog(true, "/api/user/v1/users/importZipUser", post, "", false, isAdd);
                        continue;
                    }
                    this.orgPostService.update((Model)post);
                    this.doLog(true, "/api/user/v1/users/importZipUser", post, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", post, "\u5c97\u4f4d\u3010" + relName + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u5c97\u4f4d\u3010" + relName + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importRole(UserImportVo importVo, String unZipFilePath, Map<String, String> errRoleIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "role");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String name = null;
                Role role = null;
                try {
                    boolean isAdd = false;
                    Row row = sheet.getRow(i);
                    String id = (String)this.getCellValue(headMap, row, "id", "String");
                    name = (String)this.getCellValue(headMap, row, "name", "String");
                    String code = (String)this.getCellValue(headMap, row, "code", "String");
                    role = (Role)this.roleService.get((Serializable)((Object)id));
                    if (BeanUtils.isNotEmpty((Object)role)) {
                        if (!role.getCode().equals(code)) {
                            String newId;
                            id = newId = UniqueIdUtil.getSuid();
                            errRoleIds.put(id, newId);
                            role = null;
                        }
                    } else {
                        role = this.roleService.getByAlias(code);
                        if (BeanUtils.isNotEmpty((Object)role)) {
                            if (!role.getName().equals(name)) {
                                code = code + IMPORT_NEW_SUFFIX;
                            } else {
                                errRoleIds.put(id, role.getId());
                            }
                        }
                    }
                    if (BeanUtils.isEmpty((Object)role)) {
                        role = new Role();
                        role.setId(id);
                        isAdd = true;
                    }
                    if (!isAdd && (isAdd || !importVo.isCover())) continue;
                    String description = (String)this.getCellValue(headMap, row, "description", "String");
                    Integer enabled = (Integer)this.getCellValue(headMap, row, "enabled", "int");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    role.setCode(code);
                    role.setName(name);
                    role.setRoleType(2);
                    role.setEnabled(enabled);
                    role.setDescription(description);
                    role.setUpdateTime(updateTime);
                    role.setIsDelete(isDelete);
                    if (isAdd) {
                        this.roleService.create((Model)role);
                        this.doLog(true, "/api/user/v1/users/importZipUser", role, "", false, isAdd);
                        continue;
                    }
                    this.roleService.update((Model)role);
                    this.doLog(true, "/api/user/v1/users/importZipUser", role, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", role, "\u89d2\u8272\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u89d2\u8272\u3010" + name + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    @Transactional
    private void importUserRole(UserImportVo importVo, String unZipFilePath, Map<String, String> errRoleIds, Map<String, String> errUserIds) throws FileNotFoundException, IOException {
        Sheet sheet = this.getSheet(unZipFilePath, "userRole");
        if (BeanUtils.isNotEmpty((Object)sheet)) {
            Map<String, Integer> headMap = this.getHeadMap(sheet);
            int begin = sheet.getFirstRowNum();
            int end = sheet.getLastRowNum();
            for (int i = begin + 1; i <= end; ++i) {
                String id = null;
                UserRole userRole = null;
                try {
                    Row row = sheet.getRow(i);
                    id = (String)this.getCellValue(headMap, row, "id", "String");
                    userRole = (UserRole)this.userRoleService.get((Serializable)((Object)id));
                    boolean isAdd = false;
                    if (BeanUtils.isEmpty((Object)userRole)) {
                        isAdd = true;
                        userRole = new UserRole();
                        userRole.setId(UniqueIdUtil.getSuid());
                    }
                    String roleId = (String)this.getCellValue(headMap, row, "roleId", "String");
                    String userId = (String)this.getCellValue(headMap, row, "userId", "String");
                    LocalDateTime updateTime = (LocalDateTime)this.getCellValue(headMap, row, "updateTime", "date");
                    String isDelete = (String)this.getCellValue(headMap, row, "isDelete", "String");
                    userRole.setRoleId(StringUtil.isNotEmpty((String)errRoleIds.get(roleId)) ? errRoleIds.get(roleId) : roleId);
                    userRole.setUserId(StringUtil.isNotEmpty((String)errUserIds.get(userId)) ? errUserIds.get(userId) : userId);
                    userRole.setUpdateTime(updateTime);
                    userRole.setIsDelete(isDelete);
                    if (isAdd) {
                        this.userRoleService.create((Model)userRole);
                        this.doLog(true, "/api/user/v1/users/importZipUser", userRole, "", false, isAdd);
                        continue;
                    }
                    this.userRoleService.update((Model)userRole);
                    this.doLog(true, "/api/user/v1/users/importZipUser", userRole, "", false, isAdd);
                    continue;
                }
                catch (Exception e) {
                    this.doLog(false, "/api/user/v1/users/importZipUser", userRole, "\u7528\u6237\u89d2\u8272Id\u4e3a\u3010" + id + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage(), false, true);
                    logger.error("\u7528\u6237\u89d2\u8272Id\u4e3a\u3010" + id + "\u3011\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
    }

    private Map<String, Integer> getHeadMap(Sheet sheet) {
        HashMap<String, Integer> headMap = new HashMap<String, Integer>();
        for (int i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
            Row row = sheet.getRow(0);
            headMap.put(row.getCell(i).getStringCellValue().trim(), i);
        }
        return headMap;
    }

    private Sheet getSheet(String unZipFilePath, String type) throws FileNotFoundException, IOException {
        HSSFSheet sheet = null;
        File excelFile = new File(unZipFilePath + File.separator + type + ".xls");
        if (excelFile.exists() && BeanUtils.isNotEmpty((Object)excelFile)) {
            HSSFWorkbook wb = new HSSFWorkbook((InputStream)new FileInputStream(excelFile));
            sheet = wb.getSheetAt(0);
        }
        return sheet;
    }

    private Object getCellValue(Map<String, Integer> headMap, Row row, String field, String type) throws ParseException {
        Object value = null;
        if (BeanUtils.isNotEmpty((Object)headMap.get(field))) {
            Cell cell = row.getCell(headMap.get(field).intValue());
            if ("String".equals(type)) {
                if (BeanUtils.isNotEmpty((Object)cell) && StringUtil.isNotEmpty((String)cell.getStringCellValue())) {
                    value = cell.getStringCellValue().trim();
                }
            } else if ("int".equals(type)) {
                if (BeanUtils.isNotEmpty((Object)cell) && BeanUtils.isNotEmpty((Object)cell.getStringCellValue())) {
                    value = Integer.valueOf(cell.getStringCellValue());
                }
            } else if ("boolean".equals(type)) {
                if (BeanUtils.isNotEmpty((Object)cell) && BeanUtils.isNotEmpty((Object)cell.getBooleanCellValue())) {
                    value = cell.getBooleanCellValue();
                }
            } else if ("date".equals(type) || "datetime".equals(type)) {
                if (cell.getCellType() == CellType.NUMERIC) {
                    value = HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue());
                } else if (cell.getCellType() == CellType.STRING) {
                    String formate = "datetime".equals(type) ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
                    SimpleDateFormat sdf = new SimpleDateFormat(formate);
                    SimpleDateFormat sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.UK);
                    if (StringUtil.isNotEmpty((String)cell.getStringCellValue())) {
                        String dateStr = cell.getStringCellValue().trim();
                        Date date = sdf1.parse(dateStr);
                        String sDate = sdf.format(date);
                        value = sdf.parse(sDate);
                    }
                }
            }
        }
        return value;
    }

    private void doLog(boolean isSuccess, String reqUrl, Object param, String msg, boolean isExcel, boolean isAdd) {
        block5: {
            try {
                if (isSuccess) {
                    String preMsg = isAdd ? "\u65b0\u589e\u6570\u636e\uff1a" : "\u66f4\u65b0\u6570\u636e\uff1a";
                    OperateLogUtil.doLogAsync(new OperateLog(1, "POST", reqUrl, isExcel ? "\u5bfc\u5165Excel\u7528\u6237\u6570\u636e" : "\u5bfc\u5165Zip\u7528\u6237\u6570\u636e", preMsg + JsonUtil.toJsonNode((Object)param), "", ""));
                    break block5;
                }
                String params = "";
                try {
                    params = BeanUtils.isNotEmpty((Object)param) ? JsonUtil.toJson((Object)param) : "";
                }
                catch (Exception e) {
                    params = param.toString();
                }
                OperateLogUtil.doLogAsync(new OperateLog(0, "POST", reqUrl, isExcel ? "\u5bfc\u5165Excel\u7528\u6237\u6570\u636e" : "\u5bfc\u5165Zip\u7528\u6237\u6570\u636e", params, "", msg));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public CommonResult<String> syncADUsers(String action, String ip) throws Exception {
        return null;
    }

    @Override
    public CommonResult<String> syncSoap(OaAsyncObject oaAsyncObject, String ip) throws Exception {
        return null;
    }
}

