/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.uc.dao.BizUserApprovalRecordDao;
import com.artfess.uc.dto.UserApprovalRecordDTO;
import com.artfess.uc.manager.BizUserApprovalRecordManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.BizUserApprovalRecord;
import com.artfess.uc.model.User;
import com.artfess.uc.vo.UserApprovalRecordVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizUserApprovalRecordManagerImpl
extends BaseManagerImpl<BizUserApprovalRecordDao, BizUserApprovalRecord>
implements BizUserApprovalRecordManager {
    @Resource
    private BaseContext baseContext;
    @Resource
    private UserManager userManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void todo(UserApprovalRecordDTO dto) {
        BizUserApprovalRecord applyStart = new BizUserApprovalRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)applyStart));
        applyStart.setApprovalUserId(this.baseContext.getCurrentUserId());
        applyStart.setApprovalUserName(this.baseContext.getCurrentUserName());
        applyStart.setApprovalUserAccount(this.baseContext.getCurrentUserAccout());
        switch (dto.getTodoType()) {
            case "start_r": {
                applyStart.setApprovalNode("\u63d0\u4ea4\u7533\u8bf7");
                applyStart.setApprovalResult(3);
                applyStart.setProcessingTime(0L);
                break;
            }
            case "start": {
                this.updateUserStatus(dto.getUserId(), 3);
                applyStart.setApprovalNode("\u63d0\u4ea4\u7533\u8bf7");
                applyStart.setApprovalResult(3);
                applyStart.setIntranetPort("\u91cd\u65b0\u53d1\u8d77\u5ba1\u6279");
                applyStart.setProcessingTime(this.getProcessingTime(dto.getUserId()));
                break;
            }
            case "agree": {
                this.updateUserStatus(dto.getUserId(), 1);
                applyStart.setApprovalNode("\u7ba1\u7406\u5458\u5ba1\u6838");
                applyStart.setApprovalResult(1);
                applyStart.setProcessingTime(this.getProcessingTime(dto.getUserId()));
                break;
            }
            case "reject": {
                this.updateUserStatus(dto.getUserId(), 4);
                applyStart.setApprovalNode("\u7ba1\u7406\u5458\u5ba1\u6838");
                applyStart.setApprovalResult(0);
                applyStart.setProcessingTime(this.getProcessingTime(dto.getUserId()));
                break;
            }
            default: {
                throw new RuntimeException("\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38\uff0c\u65e0\u6cd5\u5224\u65ad\uff01");
            }
        }
        applyStart.setApprovalNode("\u63d0\u4ea4\u7533\u8bf7");
        applyStart.setApprovalOrgId(this.baseContext.getCurrentOrgId());
        applyStart.setApprovalOrgName(this.baseContext.getCurrentOrgName());
        applyStart.setApprovalDeptId(this.baseContext.getCurrentOrgName());
        applyStart.setApprovalDeptName(this.baseContext.getCurrentDeptId());
        applyStart.setApprovalDate(LocalDateTime.now());
        this.save((Object)applyStart);
    }

    @Override
    public CommonResult<List<UserApprovalRecordVO>> getRecordByUserId(String userId) {
        Assert.hasText((String)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList vo = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizUserApprovalRecord::getUserId, (Object)userId);
        queryWrapper.orderByAsc(AutoFillModel::getCreateTime);
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(e -> {
                UserApprovalRecordVO applyRecordVo = new UserApprovalRecordVO();
                BeanUtils.copyProperties((Object)e, (Object)applyRecordVo);
                vo.add(applyRecordVo);
            });
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", vo);
    }

    private long getProcessingTime(String userId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizUserApprovalRecord::getUserId, (Object)userId);
        queryWrapper.orderByDesc(AutoFillModel::getCreateTime);
        queryWrapper.last("limit 1");
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            LocalDateTime lastTime = ((BizUserApprovalRecord)((Object)list.get(0))).getApprovalDate();
            Duration duration = Duration.between(lastTime, LocalDateTime.now());
            return duration.getSeconds();
        }
        return 0L;
    }

    private void updateUserStatus(String userId, Integer status) {
        User user = (User)this.userManager.getById((Serializable)((Object)userId));
        user.setStatus(status);
        this.userManager.updateById(user);
    }
}

