/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.typehandle;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ShortTypeHandle
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
        if (parameter instanceof LocalDateTime) {
            parameter = Timestamp.valueOf((LocalDateTime)parameter);
        }
        ps.setObject(i, parameter);
    }

    public Object getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object result = rs.getObject(columnName);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object result = rs.getObject(columnIndex);
        return rs.wasNull() ? null : this.dealResult(result);
    }

    public Object getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object result = cs.getObject(columnIndex);
        return cs.wasNull() ? null : this.dealResult(result);
    }

    private Object dealResult(Object result) throws SQLException {
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                return 1;
            }
            return 0;
        }
        return result;
    }

    public void setParameter(PreparedStatement ps, int i, Object obj, JdbcType jdbcType) throws SQLException {
        if (obj == null) {
            ps.setInt(i, 0);
            return;
        }
        Boolean par = (Boolean)obj;
        if (par.booleanValue()) {
            ps.setInt(i, 1);
        } else {
            ps.setInt(i, 0);
        }
    }
}

