/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.patrol.manager.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.context.BaseContext;
import com.artfess.base.entity.BizDelModel;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.redis.util.RedisUtil;
import com.artfess.rescue.base.manager.BizBaseTeamMemberManager;
import com.artfess.rescue.base.manager.BizCarTaskLogManager;
import com.artfess.rescue.base.model.BizBaseRoad;
import com.artfess.rescue.base.model.BizBaseTeamMember;
import com.artfess.rescue.base.model.BizCarTaskLog;
import com.artfess.rescue.patrol.dao.BizInspectionTaskDao;
import com.artfess.rescue.patrol.dto.CountByContentToUserDTO;
import com.artfess.rescue.patrol.dto.CountByUserDTO;
import com.artfess.rescue.patrol.manager.BizInspectionResultDetailManager;
import com.artfess.rescue.patrol.manager.BizInspectionResultManager;
import com.artfess.rescue.patrol.manager.BizInspectionTaskManager;
import com.artfess.rescue.patrol.model.BizInspectionResult;
import com.artfess.rescue.patrol.model.BizInspectionResultDetail;
import com.artfess.rescue.patrol.model.BizInspectionTask;
import com.artfess.rescue.patrol.vo.BaseTaskLedgerVO;
import com.artfess.rescue.patrol.vo.CountByContentToUserVO;
import com.artfess.rescue.patrol.vo.CountByContentVO;
import com.artfess.rescue.patrol.vo.CountByRoadVO;
import com.artfess.rescue.patrol.vo.InspectBaseLedgerVO;
import com.artfess.rescue.patrol.vo.ResultLedgerVO;
import com.artfess.rescue.report.dto.FilterDto;
import com.artfess.rescue.uc.manager.RescueOrgManager;
import com.artfess.rescue.uc.vo.OrgInfoVO;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizInspectionTaskManagerImpl
extends BaseManagerImpl<BizInspectionTaskDao, BizInspectionTask>
implements BizInspectionTaskManager {
    @Resource
    BaseContext baseContext;
    @Resource
    BizInspectionResultManager resultManager;
    @Resource
    BizInspectionResultDetailManager detailManager;
    @Resource
    private SysIdentityManager sysIdentityManager;
    @Resource
    private RescueOrgManager rescueOrgManager;
    @Resource
    private BizBaseTeamMemberManager bizBaseTeamMemberManager;
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private BizCarTaskLogManager carTaskLogManager;
    private static final String TEAM_MEMBER_KEY = "team:member:";

    @Override
    public PageList<BizInspectionTask> powerList(QueryFilter<BizInspectionTask> queryFilter) {
        String userId = this.baseContext.getCurrentUserId();
        if (userId == null) {
            return new PageList();
        }
        queryFilter.addFilter("t.is_dele_", (Object)"0", QueryOP.EQUAL);
        return new PageList(((BizInspectionTaskDao)this.baseMapper).queryByPower((IPage<BizInspectionTask>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()), userId));
    }

    @Override
    public BizInspectionTask findById(String id) {
        BizInspectionTask task = ((BizInspectionTaskDao)this.baseMapper).findById(id);
        if (task == null) {
            return new BizInspectionTask();
        }
        LambdaQueryWrapper resultWrapper = new LambdaQueryWrapper();
        resultWrapper.eq(BizInspectionResult::getTaskId, (Object)task.getId());
        resultWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        BizInspectionResult result = (BizInspectionResult)((Object)this.resultManager.getOne((Wrapper)resultWrapper, false));
        if (result != null) {
            LocalDateTime linkStartTime = result.getLinkStartTime();
            if ((2 == task.getTaskStatus() || 3 == task.getTaskStatus()) && linkStartTime != null) {
                long seconds = ChronoUnit.SECONDS.between(linkStartTime, LocalDateTime.now());
                result.setTimeSpent(result.getTimeSpent() + seconds);
            }
            if (!StringUtil.isEmpty((String)task.getTeamName())) {
                result.setTeamName(task.getTeamName());
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BizCarTaskLog::getTaskId, (Object)id)).orderByDesc(BizCarTaskLog::getCreateTime)).last("limit 1");
            BizCarTaskLog taskLog = (BizCarTaskLog)((Object)this.carTaskLogManager.getOne((Wrapper)wrapper));
            if (taskLog != null) {
                result.setStartMileage(taskLog.getStartMileage());
                result.setEndMileage(taskLog.getEndMileage());
            }
            List<BizInspectionResultDetail> details = this.detailManager.findByList(result.getTaskId());
            task.setResultDetails(details);
        }
        task.setResult(result);
        return task;
    }

    @Override
    public boolean saveInfo(BizInspectionTask inspectionTask) {
        String taskCode = this.sysIdentityManager.nextId("xjjhrwlsh");
        inspectionTask.setTaskNo(taskCode);
        inspectionTask.setTaskDate(LocalDate.now());
        inspectionTask.setTaskStatus(1);
        return this.save((Object)inspectionTask);
    }

    @Override
    public PageList<BizInspectionTask> queryPage(QueryFilter<BizInspectionTask> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        queryFilter.addFilter("t.is_dele_", (Object)"0", QueryOP.EQUAL);
        IPage<BizInspectionTask> result = ((BizInspectionTaskDao)this.baseMapper).queryPage((IPage<BizInspectionTask>)this.convert2IPage(pageBean), (Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateByStatus(String id, String taskStatus) {
        Assert.hasText((String)id, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizInspectionResult::getTaskId, (Object)id);
        queryWrapper.eq(BizDelModel::getIsDele, (Object)"0");
        BizInspectionResult inspectionResult = (BizInspectionResult)((Object)this.resultManager.getOne((Wrapper)queryWrapper));
        if ("3".equals(taskStatus)) {
            inspectionResult.setLinkStartTime(LocalDateTime.now());
        }
        if ("5".equals(taskStatus)) {
            long seconds = ChronoUnit.SECONDS.between(inspectionResult.getLinkStartTime(), LocalDateTime.now());
            inspectionResult.setTimeSpent(inspectionResult.getTimeSpent() + seconds);
            inspectionResult.setLinkStartTime(LocalDateTime.now());
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(BizInspectionTask::getId, (Object)id)).set(BizInspectionTask::getTaskStatus, (Object)taskStatus);
        return this.update((Wrapper)wrapper);
    }

    @Override
    public PageList<BizInspectionTask> pushInspectList(QueryFilter<BizInspectionTask> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("task_status_", Arrays.asList(2, 3, 5), QueryOP.IN);
        IPage<BizInspectionTask> iPage = ((BizInspectionTaskDao)this.baseMapper).queryByWorkbench((IPage<BizInspectionTask>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(iPage);
    }

    @Override
    public CommonResult<JSONObject> countByRoad(QueryFilter<BizInspectionTask> queryFilter) {
        JSONObject object = new JSONObject();
        this.setInspectionQueryFilter(queryFilter);
        queryFilter.addFilter("t.is_dele_", (Object)"0", QueryOP.EQUAL);
        QueryWrapper convert2Wrapper = this.convert2Wrapper(queryFilter, this.currentModelClass());
        List<CountByRoadVO> countByRoadVOS = ((BizInspectionTaskDao)this.baseMapper).selectCountByRoad((Wrapper<BizInspectionTask>)convert2Wrapper);
        object.put("data", countByRoadVOS);
        object.put("total", (Object)((BizInspectionTaskDao)this.baseMapper).salesSummaryByRoad((Wrapper<BizInspectionTask>)convert2Wrapper));
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)object);
    }

    @Override
    public CommonResult<JSONObject> countByUser(QueryFilter<BizInspectionTask> queryFilter) {
        ArrayList vos = new ArrayList();
        this.setInspectionQueryFilter(queryFilter);
        List<CountByUserDTO> countByUserDTOS = ((BizInspectionTaskDao)this.baseMapper).selectCountByUser((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        HashMap<String, List> userOfResult = new HashMap<String, List>();
        Optional.ofNullable(countByUserDTOS).orElse(Collections.emptyList()).stream().filter(dto -> dto != null && dto.getInspectUserId() != null).forEach(dto -> Arrays.stream(dto.getInspectUserId().split(",")).forEach(userId -> userOfResult.computeIfAbsent((String)userId, k -> new ArrayList()).add(dto)));
        AtomicReference<BigDecimal> totalTime = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> totalMileage = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicLong totalOutlierPoint = new AtomicLong(0L);
        AtomicLong totalHandleScene = new AtomicLong(0L);
        AtomicLong totalTaskNum = new AtomicLong(0L);
        userOfResult.forEach((k, v) -> {
            CountByRoadVO vo = new CountByRoadVO();
            vo.setRoadId(((CountByUserDTO)v.get(0)).getRoadId());
            vo.setRoadName(((CountByUserDTO)v.get(0)).getRoadName());
            vo.setTeamId(((CountByUserDTO)v.get(0)).getTeamId());
            vo.setTeamName(((CountByUserDTO)v.get(0)).getTeamName());
            String userName = (String)this.redisUtil.get(TEAM_MEMBER_KEY + k, String.class);
            if (StringUtil.isNotEmpty((String)userName)) {
                vo.setUserName(userName);
            } else {
                BizBaseTeamMember bizBaseTeamMember = (BizBaseTeamMember)this.bizBaseTeamMemberManager.get((Serializable)((Object)k));
                if (Objects.isNull((Object)bizBaseTeamMember)) {
                    return;
                }
                vo.setUserName(bizBaseTeamMember.getName());
                this.redisUtil.set(TEAM_MEMBER_KEY + k, (Object)bizBaseTeamMember.getName(), 600L);
            }
            AtomicReference<BigDecimal> time = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> taskMileage = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicLong outlierPoint = new AtomicLong(0L);
            AtomicLong handleScene = new AtomicLong(0L);
            AtomicLong taskNum = new AtomicLong(0L);
            v.forEach(e -> {
                time.set(((BigDecimal)time.get()).add(e.getTaskTime()));
                taskMileage.set(((BigDecimal)taskMileage.get()).add(e.getTaskMileage()));
                outlierPoint.addAndGet(e.getHandleAll().intValue());
                handleScene.addAndGet(e.getHandleScene().intValue());
                taskNum.addAndGet(e.getTaskNum().intValue());
            });
            vo.setTaskNum((int)taskNum.get());
            vo.setHandleAll((int)outlierPoint.get());
            vo.setHandleScene((int)handleScene.get());
            vo.setOutlierPoint(vo.getHandleAll());
            vo.setHandleCenter(vo.getHandleAll() - vo.getHandleScene());
            vo.setTaskTime(time.get());
            vo.setTaskMileage(taskMileage.get());
            vos.add(vo);
            totalTime.set(((BigDecimal)totalTime.get()).add(time.get()));
            totalMileage.set(((BigDecimal)totalMileage.get()).add(taskMileage.get()));
            totalOutlierPoint.addAndGet(outlierPoint.get());
            totalHandleScene.addAndGet(handleScene.get());
            totalTaskNum.addAndGet(taskNum.get());
        });
        List sortedVos = vos.stream().sorted(Comparator.comparing(CountByRoadVO::getRoadId)).collect(Collectors.toList());
        CountByRoadVO totalVo = new CountByRoadVO();
        totalVo.setRoadId("0");
        totalVo.setRoadName("\u6c47\u603b");
        totalVo.setTaskNum((int)totalTaskNum.get());
        totalVo.setHandleAll((int)totalOutlierPoint.get());
        totalVo.setHandleScene((int)totalHandleScene.get());
        totalVo.setOutlierPoint(totalVo.getHandleAll());
        totalVo.setHandleCenter(totalVo.getHandleAll() - totalVo.getHandleScene());
        totalVo.setTaskTime(totalTime.get());
        totalVo.setTaskMileage(totalMileage.get());
        JSONObject result = new JSONObject();
        result.put("data", sortedVos);
        result.put("total", (Object)totalVo);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @Override
    public CommonResult<JSONObject> countContent(QueryFilter<BizInspectionTask> queryFilter) {
        JSONObject object = new JSONObject();
        this.setInspectionQueryFilter(queryFilter);
        List<CountByContentVO> countByUserDTOS = ((BizInspectionTaskDao)this.baseMapper).selectCountContent((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        object.put("data", countByUserDTOS);
        CountByContentVO vo = ((BizInspectionTaskDao)this.baseMapper).summaryCountContent((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        object.put("total", (Object)vo);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", (Object)object);
    }

    @Override
    public CommonResult<List<CountByContentToUserVO>> countUserContent(QueryFilter<BizInspectionTask> queryFilter) {
        ArrayList vos = new ArrayList();
        this.setInspectionQueryFilter(queryFilter);
        queryFilter.addFilter("d.TYPE_", Arrays.asList(3, 5, 11), QueryOP.IN);
        List<CountByContentToUserDTO> dtoList = ((BizInspectionTaskDao)this.baseMapper).selectCountContentToUser((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (CollectionUtils.isNotEmpty(dtoList)) {
            HashMap<String, List> userOfResult = new HashMap<String, List>();
            dtoList.forEach(dto -> {
                String inspectUserId = dto.getInspectUserId();
                if (StringUtil.isNotEmpty((String)inspectUserId)) {
                    List<String> userIds = Arrays.asList(dto.getInspectUserId().split(","));
                    userIds.forEach(userId -> userOfResult.computeIfAbsent((String)userId, k -> new ArrayList()).add(dto));
                }
            });
            userOfResult.forEach((k, v) -> {
                CountByContentToUserVO vo = new CountByContentToUserVO();
                vo.setRoadId(((CountByContentToUserDTO)v.get(0)).getRoadId());
                vo.setRoadName(((CountByContentToUserDTO)v.get(0)).getRoadName());
                vo.setTeamId(((CountByContentToUserDTO)v.get(0)).getTeamId());
                vo.setTeamName(((CountByContentToUserDTO)v.get(0)).getTeamName());
                String userName = (String)this.redisUtil.get(TEAM_MEMBER_KEY + k, String.class);
                if (StringUtil.isNotEmpty((String)userName)) {
                    vo.setUserName(userName);
                } else {
                    BizBaseTeamMember bizBaseTeamMember = (BizBaseTeamMember)this.bizBaseTeamMemberManager.get((Serializable)((Object)k));
                    if (Objects.isNull((Object)bizBaseTeamMember)) {
                        return;
                    }
                    vo.setUserName(bizBaseTeamMember.getName());
                    this.redisUtil.set(TEAM_MEMBER_KEY + k, (Object)bizBaseTeamMember.getName(), 600L);
                }
                Map<Integer, List<CountByContentToUserDTO>> typeMap = v.stream().filter(e -> e.getType() != null).collect(Collectors.groupingBy(CountByContentToUserDTO::getType));
                AtomicLong edgeNet = new AtomicLong(0L);
                AtomicLong infoBoard = new AtomicLong(0L);
                AtomicLong movableMedianBarrier = new AtomicLong(0L);
                AtomicLong crashFacility = new AtomicLong(0L);
                AtomicLong signsAndLines = new AtomicLong(0L);
                AtomicLong signs = new AtomicLong(0L);
                AtomicLong guardrail = new AtomicLong(0L);
                AtomicLong antiGlareBoard = new AtomicLong(0L);
                AtomicLong land = new AtomicLong(0L);
                AtomicLong environmentalFacility = new AtomicLong(0L);
                typeMap.forEach((typeKey, typeValues) -> {
                    switch (typeKey) {
                        case 3: {
                            typeValues.forEach(typeValue -> {
                                String typeContent;
                                switch (typeContent = typeValue.getTypeContent()) {
                                    case "\u8fb9\u7f51": {
                                        edgeNet.addAndGet(1L);
                                        break;
                                    }
                                    case "\u6807\u5fd7\u6807\u7ebf": {
                                        signsAndLines.addAndGet(1L);
                                        break;
                                    }
                                    case "\u9632\u649e\u8bbe\u65bd": {
                                        crashFacility.addAndGet(1L);
                                        break;
                                    }
                                    case "\u4e2d\u5206\u5e26\u6d3b\u52a8\u62a4\u680f": {
                                        movableMedianBarrier.addAndGet(1L);
                                        break;
                                    }
                                    case "\u9632\u7729\u677f": {
                                        antiGlareBoard.addAndGet(1L);
                                        break;
                                    }
                                    case "\u62a4\u680f": {
                                        guardrail.addAndGet(1L);
                                        break;
                                    }
                                    case "\u6807\u5fd7\u6807\u724c": {
                                        signs.addAndGet(1L);
                                        break;
                                    }
                                    case "\u60c5\u62a5\u677f": {
                                        infoBoard.addAndGet(1L);
                                        break;
                                    }
                                }
                            });
                            break;
                        }
                        case 5: {
                            land.addAndGet(1L);
                            break;
                        }
                        case 11: {
                            environmentalFacility.addAndGet(1L);
                            break;
                        }
                    }
                });
                vo.setEdgeNet((int)edgeNet.get());
                vo.setInfoBoard((int)infoBoard.get());
                vo.setMovableMedianBarrier((int)movableMedianBarrier.get());
                vo.setCrashFacility((int)crashFacility.get());
                vo.setSignsAndLines((int)signsAndLines.get());
                vo.setSigns((int)signs.get());
                vo.setGuardrail((int)guardrail.get());
                vo.setAntiGlareBoard((int)antiGlareBoard.get());
                vo.setLand((int)land.get());
                vo.setEnvironmentalFacility((int)environmentalFacility.get());
                vos.add(vo);
            });
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f\uff01", vos);
    }

    private void setInspectionQueryFilter(QueryFilter<BizInspectionTask> queryFilter) {
        List<OrgInfoVO> orgInfoVOS = this.rescueOrgManager.roadTree();
        ArrayList roadIds = new ArrayList();
        orgInfoVOS.forEach(orgInfoVO -> {
            List roadIdList = orgInfoVO.getRoadList().stream().map(BizBaseRoad::getId).collect(Collectors.toList());
            roadIds.addAll(roadIdList);
        });
        queryFilter.addFilter("t.ROAD_ID_", roadIds, QueryOP.IN);
        List<Integer> status = Collections.singletonList(4);
        queryFilter.addFilter("t.task_status_", status, QueryOP.IN);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResponseEntity<org.springframework.core.io.Resource> exportLedger(QueryFilter<BizInspectionTask> queryFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InspectBaseLedgerVO getTaskLedger(QueryFilter<BizInspectionTask> queryFilter) {
        InspectBaseLedgerVO vo = new InspectBaseLedgerVO();
        List<BaseTaskLedgerVO> voList = ((BizInspectionTaskDao)this.baseMapper).taskLedger((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            BaseTaskLedgerVO taskLedgerVO = voList.get(0);
            try {
                BeanUtils.copyNotNullProperties((Object)vo, (Object)taskLedgerVO);
                List<ResultLedgerVO> resultMap = this.detailManager.getResultDetails(Arrays.asList(vo.getId()));
                if (resultMap != null && resultMap.size() > 0) {
                    vo.setResults(resultMap);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return vo;
    }

    @Override
    public JSONObject countTaskSummary(FilterDto dto) {
        JSONObject object = new JSONObject();
        object.put("data", ((BizInspectionTaskDao)this.baseMapper).countTaskGroup(dto));
        object.put("total", (Object)((BizInspectionTaskDao)this.baseMapper).countTaskSummary(dto));
        return object;
    }

    @Override
    public void ledgerExport(HttpServletResponse response, QueryFilter<BizInspectionTask> queryFilter) {
        List<BaseTaskLedgerVO> voList = ((BizInspectionTaskDao)this.baseMapper).taskLedger((Wrapper<BizInspectionTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (voList != null && !voList.isEmpty()) {
            BaseTaskLedgerVO vo = voList.get(0);
            TemplateExportParams params = new TemplateExportParams("model/inspectTask.xlsx", new Integer[0]);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String tempName = "\u65e5\u5e38\u5de1\u67e5\u8bb0\u5f55\u8868.xlsx";
            map.put("teamName", vo.getTeamName());
            map.put("roadName", vo.getRoadName());
            map.put("carCode", vo.getCarCode());
            map.put("taskDate", vo.getTaskDate());
            map.put("weather", vo.getWeather());
            map.put("startMileage", vo.getStartMileage());
            map.put("endMileage", vo.getEndMileage());
            map.put("mileage", vo.getMileage());
            map.put("createName", vo.getCreateName());
            map.put("inspectUsersName", vo.getInspectUsersName());
            map.put("carAppearance", vo.getCarAppearance());
            map.put("carEngine", vo.getCarEngine());
            map.put("carFfe", vo.getCarFfe());
            map.put("carLight", vo.getCarLight());
            map.put("carOp", vo.getCarOp());
            List<ResultLedgerVO> resultMap = this.detailManager.getResultDetails(Collections.singletonList(vo.getId()));
            if (resultMap != null && resultMap.size() > 0) {
                map.put("list", resultMap);
            }
            this.exportExcelWorkbook(tempName, params, map, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportExcelWorkbook(String fileName, TemplateExportParams params, Map<String, Object> map, HttpServletResponse response) {
        Workbook workbook;
        try {
            workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Excel \u751f\u6210\u5931\u8d25", e);
        }
        try {
            if (!(workbook instanceof XSSFWorkbook)) {
                throw new RuntimeException("\u4ec5\u652f\u6301 .xlsx \u683c\u5f0f\u7684 Excel \u5bfc\u51fa");
            }
            XSSFWorkbook xssfWorkbook = (XSSFWorkbook)workbook;
            XSSFSheet sheet = xssfWorkbook.getSheetAt(0);
            int startRow = 7;
            Object object = map.get("list");
            if (object != null) {
                List results = (List)object;
                this.clearExistingMergedRegions(sheet, startRow, results.size());
                for (int i = 0; i < results.size(); ++i) {
                    int currentRow = startRow + i;
                    this.addSpecificMergedRegions(sheet, currentRow);
                }
            }
            OutputStream os = null;
            try {
                String encodedFileName = URLEncoder.encode(fileName, "UTF-8");
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
                response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
                response.addHeader("fileName", encodedFileName);
                os = response.getOutputStream();
                xssfWorkbook.write(os);
            }
            finally {
                if (os != null) {
                    try {
                        os.flush();
                        os.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("\u6587\u4ef6\u6d41\u5173\u95ed\u5931\u8d25", e);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Excel \u5408\u5e76\u5355\u5143\u683c\u5904\u7406\u5931\u8d25", e);
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void clearExistingMergedRegions(XSSFSheet sheet, int startRow, int rowCount) {
        ArrayList<Integer> regionsToRemove = new ArrayList<Integer>();
        int endRow = startRow + rowCount - 1;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            if (region.getFirstRow() < startRow || region.getLastRow() > endRow) continue;
            regionsToRemove.add(i);
        }
        Collections.reverse(regionsToRemove);
        Iterator iterator = regionsToRemove.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            sheet.removeMergedRegion(index);
        }
    }

    private void addSpecificMergedRegions(XSSFSheet sheet, int startRow) {
        this.setCellStyles(sheet, startRow);
        this.mergeCells(sheet, startRow, startRow, 1, 2);
        this.mergeCells(sheet, startRow, startRow, 3, 6);
        this.mergeCells(sheet, startRow, startRow, 7, 8);
    }

    private void setCellStyles(XSSFSheet sheet, int rowNum) {
        XSSFRow row = sheet.getRow(rowNum) != null ? sheet.getRow(rowNum) : sheet.createRow(rowNum);
        CellStyle style = this.createBaseStyle((Workbook)sheet.getWorkbook());
        for (int col : new int[]{1, 2, 3, 4, 5, 6, 7, 8}) {
            Cell cell = row.getCell(col) != null ? row.getCell(col) : row.createCell(col);
            cell.setCellStyle(style);
        }
    }

    private static CellStyle createCustomStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setFontHeightInPoints((short)10);
        style.setFont(font);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        return style;
    }

    private static void applyStyleToMergedRegion(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, CellStyle style) {
        for (int r = firstRow; r <= lastRow; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) {
                row = sheet.createRow(r);
            }
            for (int c = firstCol; c <= lastCol; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) {
                    cell = row.createCell(c);
                }
                cell.setCellStyle(style);
            }
        }
    }

    private CellStyle createBaseStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)8);
        font.setFontName("\u5b8b\u4f53");
        style.setFont(font);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private void mergeCells(XSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress region = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(region);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
    }
}

