/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rescue.event.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.rescue.event.dao.BizRescueHandleDao;
import com.artfess.rescue.event.dao.BizRescueInfoDao;
import com.artfess.rescue.event.dto.RescueInfoDto;
import com.artfess.rescue.event.manager.BizRescueCarManager;
import com.artfess.rescue.event.manager.BizRescueCostManager;
import com.artfess.rescue.event.manager.BizRescueDispatchManager;
import com.artfess.rescue.event.manager.BizRescueHandleManager;
import com.artfess.rescue.event.model.BizRescueCar;
import com.artfess.rescue.event.model.BizRescueCost;
import com.artfess.rescue.event.model.BizRescueDispatch;
import com.artfess.rescue.event.model.BizRescueHandle;
import com.artfess.rescue.file.model.BizRescueFileCommon;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizRescueHandleManagerImpl
extends BaseManagerImpl<BizRescueHandleDao, BizRescueHandle>
implements BizRescueHandleManager {
    @Resource
    FileManager fileManager;
    @Resource
    BizRescueInfoDao rescueInfoDao;
    @Resource
    BizRescueCostManager costManager;
    @Resource
    BizRescueDispatchManager dispatchManager;
    @Resource
    BizRescueCarManager carManager;

    @Override
    public int countNode(String rescueId, String nodeName) {
        LambdaQueryWrapper handleWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)handleWrapper.eq(BizRescueHandle::getRescueId, (Object)rescueId)).eq(BeanUtils.isNotEmpty((Object)nodeName), BizRescueHandle::getRescueNode, (Object)nodeName)).eq(BizRescueHandle::getIsDele, (Object)"0");
        return super.count((Wrapper)handleWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveInfo(BizRescueHandle entity) {
        BizRescueCost cost;
        boolean save;
        JSONObject team;
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            entity.setHandleUserId(user.getUserId());
            entity.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            entity.setHandleTeamId(team.getString("teamId"));
            entity.setHandleTeamName(team.getString("teamName"));
        }
        if (!(save = this.save((Object)entity))) {
            throw new ApplicationException("\u5904\u7f6e\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        }
        this.saveAttachments(entity);
        String rescueNode = entity.getRescueNode();
        String status = null;
        String costType = null;
        switch (rescueNode) {
            case "100": {
                status = "6";
                costType = "2";
                break;
            }
            case "99": {
                status = "4";
                break;
            }
            case "10": {
                costType = "1";
                break;
            }
            case "11": {
                status = "5";
                break;
            }
            case "101": {
                status = "3";
                break;
            }
        }
        if (status != null) {
            this.rescueInfoDao.updateByStatus(entity.getRescueId(), status, null);
        }
        if (costType != null && (cost = entity.getCost()) != null) {
            cost.setRescueId(entity.getRescueId());
            this.setCost(entity.getCost(), costType);
        }
        return true;
    }

    private void saveAttachments(BizRescueHandle entity) {
        List<BizRescueFileCommon> files = entity.getFiles();
        if (CollectionUtils.isNotEmpty(files)) {
            List fileIds = files.stream().map(BizRescueFileCommon::getFileId).collect(Collectors.toList());
            this.fileManager.updateFileBizIdByIds(fileIds, entity.getId());
        }
    }

    void setCost(BizRescueCost cost, String costType) {
        if (cost != null) {
            boolean save;
            cost.setCostTime(LocalDateTime.now());
            cost.setCostType(costType);
            if (costType.equals("2") && BeanUtils.isNotEmpty((Object)cost.getTrailingMileage())) {
                cost.setTotalMileage(cost.getTrailingMileage());
            }
            if (!(save = this.costManager.save((Object)cost))) {
                throw new ApplicationException("\u82b1\u8d39\u91d1\u989d\u8bb0\u5f55\u5931\u8d25");
            }
        }
    }

    @Override
    @Transactional
    public boolean updateInfo(BizRescueHandle entity) {
        boolean update = this.updateById((Object)entity);
        if (!update) {
            return false;
        }
        this.saveAttachments(entity);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean accept(RescueInfoDto dto) {
        LocalDateTime now = LocalDateTime.now();
        String currentUserId = ContextUtil.getCurrentUserId();
        String currentUserName = ContextUtil.getCurrentUserName();
        String id = dto.getId();
        JSONObject team = ContextUtil.getCurrentTeam();
        String teamId = "";
        String teamName = "";
        String userId = "";
        if (team != null) {
            teamId = team.getString("teamId");
            teamName = team.getString("teamName");
            userId = team.getString("userId");
        }
        this.rescueInfoDao.updateByStatus(id, "2", userId);
        BizRescueCar car = dto.getCar();
        if (car.getDispatchTime() == null) {
            car.setDispatchTime(now);
        }
        car.setRescueId(id);
        boolean carSave = this.carManager.saveOrUpdate((Object)car);
        if (!carSave) {
            throw new ApplicationException("\u8f66\u8f86\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        }
        List<BizRescueDispatch> dispatches = dto.getDispatches();
        if (dispatches != null && !dispatches.isEmpty()) {
            LambdaQueryWrapper deleWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)deleWrapper.eq(BizRescueDispatch::getRescueId, (Object)id)).eq(BizRescueDispatch::getIsDele, (Object)"0");
            this.dispatchManager.remove((Wrapper)deleWrapper);
            for (BizRescueDispatch d : dispatches) {
                d.setRescueId(id);
                d.setDispatchTime(now);
                d.setDispatchCarCode(car.getDispatchCarCode());
                d.setDispatchCarType(car.getDispatchCarType());
                d.setDispatchTeamName(teamName);
            }
            boolean saveOrUpdateBatch = this.dispatchManager.saveOrUpdateBatch(dispatches);
            if (!saveOrUpdateBatch) {
                throw new ApplicationException("\u4eba\u5458\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
            }
        }
        BizRescueHandle handle = dto.getHandle();
        handle.setRescueId(id);
        handle.setHandleUserId(currentUserId);
        handle.setHandleUserName(currentUserName);
        handle.setHandleTeamId(teamId);
        handle.setHandleTeamName(teamName);
        handle.setHandleTime(now);
        handle.setHandleInfo(currentUserName + "\u5df2\u63a5\u5355");
        handle.setRescueNode("3");
        boolean handleSave = this.save((Object)handle);
        if (!handleSave) {
            throw new ApplicationException("\u4e8b\u4ef6\u73af\u8282\u4fdd\u5b58\u5931\u8d25");
        }
        return true;
    }

    @Override
    public BizRescueHandle setHands() {
        JSONObject team;
        BizRescueHandle handle = new BizRescueHandle();
        LocalDateTime now = LocalDateTime.now();
        IUser user = ContextUtil.getCurrentUser();
        if (user != null) {
            handle.setHandleUserId(user.getUserId());
            handle.setHandleUserName(user.getFullname());
        }
        if ((team = ContextUtil.getCurrentTeam()) != null) {
            handle.setHandleTeamId(team.getString("teamId"));
            handle.setHandleTeamName(team.getString("teamName"));
        }
        handle.setHandleTime(now);
        return handle;
    }

    void chooseNode(int node, String rescueId) {
        Integer hand = ((BizRescueHandleDao)this.baseMapper).getMaxHandle(rescueId);
        if (node != 100 && node != 99 && node - hand > 1) {
            throw new BaseException("\u8bf7\u52ff\u8df3\u8fc7\u6d41\u7a0b,\u8fdb\u884c\u64cd\u4f5c");
        }
    }
}

