import { LinePatternCfg } from '../../types/pattern';
/**
 * linePattern 的 默认配置
 */
export declare const defaultLinePatternCfg: {
    rotation: number;
    spacing: number;
    opacity: number;
    backgroundColor: string;
    strokeOpacity: number;
    stroke: string;
    lineWidth: number;
};
/**
 * 绘制line
 *
 * @param context canvasContext
 * @param cfg linePattern 的配置
 * @param d 绘制 path 所需的 d
 */
export declare function drawLine(context: CanvasRenderingContext2D, cfg: LinePatternCfg, d: string): void;
/**
 * 创建 linePattern
 */
export declare function createLinePattern(cfg?: LinePatternCfg): CanvasPattern;
