import { DotPatternCfg } from '../../types/pattern';
/**
 * dotPattern的默认配置
 */
export declare const defaultDotPatternCfg: {
    size: number;
    padding: number;
    backgroundColor: string;
    opacity: number;
    rotation: number;
    fill: string;
    fillOpacity: number;
    stroke: string;
    lineWidth: number;
    isStagger: boolean;
};
/**
 * 绘制圆点
 *
 * @param context
 * @param cfg
 * @param x 圆点中心坐标x
 * @param y 圆点中心坐标y
 */
export declare function drawDot(context: CanvasRenderingContext2D, cfg: DotPatternCfg, x: number, y: number): void;
/**
 * 创建 dot pattern，返回 HTMLCanvasElement
 *
 * @param cfg
 * @returns HTMLCanvasElement
 */
export declare function createDotPattern(cfg?: DotPatternCfg): CanvasPattern;
