export declare const DEFAULT_Q: number[];
export declare const ALL_Q: number[];
/**
 * An Extension of Wilkinson's Algorithm for Position Tick Labels on Axes
 * https://www.yuque.com/preview/yuque/0/2019/pdf/185317/1546999150858-45c3b9c2-4e86-4223-bf1a-8a732e8195ed.pdf
 * @param dMin 最小值
 * @param dMax 最大值
 * @param m tick个数
 * @param onlyLoose 是否允许扩展min、max，不绝对强制，例如[3, 97]
 * @param Q nice numbers集合
 * @param w 四个优化组件的权重
 */
export default function extended(dMin: number, dMax: number, n?: number, onlyLoose?: boolean, Q?: number[], w?: [number, number, number, number]): {
    min: number;
    max: number;
    ticks: number[];
};
