"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_OPTIONS = void 0;
var plot_1 = require("../../core/plot");
var utils_1 = require("../../utils");
/**
 * 默认配置项
 */
exports.DEFAULT_OPTIONS = (0, utils_1.deepAssign)({}, plot_1.Plot.getDefaultOptions(), {
    layout: 'horizontal',
    size: {
        range: 30,
        measure: 20,
        target: 20,
    },
    xAxis: {
        tickLine: false,
        line: null,
    },
    bulletStyle: {
        range: {
            fillOpacity: 0.5,
        },
    },
    label: {
        measure: {
            position: 'right',
        },
    },
    tooltip: {
        // 默认关闭
        showMarkers: false,
    },
});
//# sourceMappingURL=constant.js.map