/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.api.impl.util;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.IgnoreOnAssembly;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.context.ICurrentContext;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Locale;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@IgnoreOnAssembly
public class ContextUtil {
    private static ContextUtil contextUtil;
    private ICurrentContext currentContext;

    public void setCurrentContext(ICurrentContext _currentContext) {
        contextUtil = this;
        ContextUtil.contextUtil.currentContext = _currentContext;
    }

    public static IUser getCurrentUser() {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            Assert.notNull((Object)authentication, (String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            Object principal = authentication.getPrincipal();
            if (principal instanceof UserFacade) {
                return (UserFacade)principal;
            }
            if (principal instanceof UserDetails) {
                UserDetails ud = (UserDetails)principal;
                UserFacade user = (UserFacade)JsonUtil.toBean((String)JsonUtil.toJson((Object)ud), UserFacade.class);
                return user;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static String getCurrentUserId() {
        IUser user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getUserId();
    }

    public static String getCurrentUserAccount() {
        IUser user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getUsername();
    }

    public static String getCurrentUserName() {
        IUser user = ContextUtil.getCurrentUser();
        return BeanUtils.isEmpty((Object)user) ? null : user.getFullname();
    }

    public static String getCurrentTeamId() {
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId)) {
            JSONObject team = service.getTeam(userId);
            if (team != null) {
                String teamId = team.get((Object)"teamId").toString();
                return teamId != null ? teamId : "";
            }
            return "";
        }
        return "";
    }

    public static JSONObject getCurrentTeam() {
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId)) {
            return service.getTeam(userId);
        }
        return null;
    }

    public static IGroup getCurrentGroup() {
        try {
            ObjectNode orgObj;
            UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            String userId = ContextUtil.getCurrentUserId();
            if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
                boolean isParent = orgObj.get("isParent").asBoolean();
                orgObj.put("isIsParent", isParent ? 1 : 0);
                orgObj.remove("isParent");
                IGroup org = (IGroup)JsonUtil.toBean((JsonNode)orgObj, Org.class);
                return org;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return null;
    }

    public static String getCurrentGroupId() {
        IGroup org = ContextUtil.getCurrentGroup();
        if (BeanUtils.isNotEmpty((Object)org)) {
            return org.getGroupId();
        }
        return "";
    }

    public static String getCurrentOrgId() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("id").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "id");
            }
        }
        return "";
    }

    public static String getCurrentOrgName() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("name").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "name");
            }
        }
        return "";
    }

    public static String getCurrentOrgAddvcd() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcd")) {
            return orgObj.get("addvcd").asText();
        }
        return "";
    }

    public static String getCurrentOrgAddvcdName() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcdName")) {
            return orgObj.get("addvcdName").asText();
        }
        return "";
    }

    public static String getCurrentOrgAddvcdFull() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && orgObj.has("addvcdFull")) {
            return orgObj.get("addvcdFull").asText();
        }
        return "";
    }

    public static String getCurrentOrgFullId() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgFullId = orgObj.get("path").asText();
            return orgFullId;
        }
        return "";
    }

    public static String getCurrentOrgCode() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("code").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "code");
            }
        }
        return "";
    }

    public static String getCurrentOrgGrade() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            String orgKind = orgObj.get("orgKind").asText();
            if (orgKind.equals("ogn")) {
                return orgObj.get("grade").asText();
            }
            if (orgKind.equals("dept")) {
                return ContextUtil.getParentOrgAttr(orgObj.get("parentId").asText(), "grade");
            }
        }
        return "";
    }

    public static String getCurrentGrade() {
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId)))) {
            return orgObj.get("grade").asText();
        }
        return "";
    }

    public static String getParentOrgAttr(String parentId, String attrName) {
        try {
            UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ObjectNode parentOrgObj = service.getOrgByIdOrCode(parentId);
            if (BeanUtils.isNotEmpty((Object)parentOrgObj)) {
                String orgKind = parentOrgObj.get("orgKind").asText();
                if (orgKind.equals("ogn")) {
                    return parentOrgObj.get(attrName).asText();
                }
                if (orgKind.equals("dept")) {
                    String parentOrgParentId = parentOrgObj.get("parentId").asText();
                    return ContextUtil.getParentOrgAttr(parentOrgParentId, attrName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String getCurrentDeptId() {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("id").asText();
        }
        return "";
    }

    public static String getCurrentDeptName() {
        String orgKind;
        ObjectNode orgObj;
        UCFeignService service = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        String userId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(orgObj = service.getMainGroup(userId))) && (orgKind = orgObj.get("orgKind").asText()).equals("dept")) {
            return orgObj.get("name").asText();
        }
        return "";
    }

    public static Locale getLocale() {
        return ContextUtil.contextUtil.currentContext.getLocale();
    }

    public static void clearCurrentUser() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearCurrentUser();
        }
    }

    public static void setCurrentUser(IUser user) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (BeanUtils.isEmpty((Object)authentication) || BeanUtils.isEmpty((Object)authentication.getPrincipal())) {
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)"\u4f20\u5165\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
            SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
        }
    }

    public static void switchCurrentUser(IUser user) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)"\u4f20\u5165\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
    }

    public static void setCurrentUserInJob(IUser user) {
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)"\u4f20\u5165\u7684\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
    }

    public static IUser getUserByAccount(String account) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)account), (String)"\u5fc5\u987b\u4f20\u5165\u7528\u6237\u8d26\u53f7");
        IUserService userServiceImpl = (IUserService)AppUtil.getBean(IUserService.class);
        IUser user = userServiceImpl.getUserByAccount(account);
        Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)user), (String)String.format("\u8d26\u53f7\u4e3a\uff1a%s\u7684\u7528\u6237\u4e0d\u5b58\u5728", account));
        return user;
    }

    public static void setCurrentUserByAccount(String account) {
        ContextUtil.setCurrentUser(ContextUtil.getUserByAccount(account));
    }

    public static void setCurrentOrg(IGroup group) {
        ContextUtil.contextUtil.currentContext.setCurrentGroup(group);
    }

    public static void setLocale(Locale locale) {
        ContextUtil.contextUtil.currentContext.setLocale(locale);
    }

    public static void cleanLocale() {
        if (contextUtil != null) {
            ContextUtil.contextUtil.currentContext.clearLocale();
        }
    }

    public static void clearAll() {
        ContextUtil.cleanLocale();
        ContextUtil.clearCurrentUser();
    }
}

