/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.JsonUtil;
import com.artfess.sysConfig.enums.BaseInfoStatus;
import com.artfess.sysConfig.persistence.dao.SysDictionaryCascadeDao;
import com.artfess.sysConfig.persistence.dao.SysDictionaryDao;
import com.artfess.sysConfig.persistence.dao.SysDictionaryDetailDao;
import com.artfess.sysConfig.persistence.manager.SysDictionaryDetailManager;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.model.SysDictionary;
import com.artfess.sysConfig.persistence.model.SysDictionaryDetail;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.sysConfig.vo.DictionaryDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysDictionaryManagerImpl
extends BaseManagerImpl<SysDictionaryDao, SysDictionary>
implements SysDictionaryManager {
    @Resource
    SysDictionaryDao sysDictionaryDao;
    @Resource
    SysDictionaryDetailManager sysDictionaryDetailManager;
    @Resource
    SysDictionaryCascadeDao sysDictionaryCascadeDao;
    @Resource
    SysDictionaryDetailDao sysDictionaryDetailDao;
    @Resource
    BaseContext baseContext;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u5b57\u5178\u7f13\u5b58");

    @Override
    @Transactional
    public String saveDictionary(SysDictionary sysDictionary) throws Exception {
        this.checkValidity(sysDictionary);
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String msg = "";
        List<SysDictionaryDetail> details = sysDictionary.getDetails();
        if (StringUtil.isBlank((String)sysDictionary.getId())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("TREE_ID_", sysDictionary.getTreeId());
            if (sysDictionary.getKindId() != 1) {
                map.put("TENANT_ID_", sysDictionary.getTenantId());
            }
            sysDictionary.setSn(this.getNextSequence(map));
            sysDictionary.setFlag(BaseInfoStatus.DRAFT.getId());
            msg = "\u65b0\u589e\u6210\u529f";
        } else {
            cache.delLike("sys:dict:all:" + sysDictionary.getTenantId());
            msg = "\u4fee\u6539\u6210\u529f";
        }
        this.saveOrUpdate((Object)sysDictionary);
        if (details != null && details.size() > 0) {
            for (int i = 0; i < details.size(); ++i) {
                SysDictionaryDetail detail = details.get(i);
                detail.setDictionaryId(sysDictionary.getId());
                if (StringUtils.isBlank((CharSequence)detail.getId())) {
                    HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
                    criteriaMap.put("DICTIONARY_ID_", sysDictionary.getId());
                    detail.setSn(this.sysDictionaryDetailManager.getNextDetailSequence(criteriaMap));
                }
                this.sysDictionaryDetailManager.saveOrUpdate((Object)detail);
            }
            String key = "sys:dictionary:new:" + sysDictionary.getCode().toUpperCase() + ":";
            cache.put((Object)key, (Object)JSONObject.toJSONString(sysDictionary.getDetails()));
        }
        this.syncDictionaryRedis();
        return msg;
    }

    @Override
    @Transactional
    public void deleteDictionaries(String ids) throws Exception {
        Assert.hasText((String)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idsList = Arrays.asList(ids.split(","));
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List list = this.sysDictionaryDao.selectBatchIds(idsList);
        for (SysDictionary sysDictionary : list) {
            Assert.isTrue((boolean)BaseInfoStatus.isDraft(sysDictionary.getFlag()), (String)String.format("%s\u72b6\u6001\u4e0d\u4e3a\u201c\u8349\u7a3f\u201d\u72b6\u6001,\u4e0d\u80fd\u5220\u9664\u3002", sysDictionary.getName()));
            String key = "sys:dictionary:new:" + sysDictionary.getCode().toUpperCase() + ":";
            cache.evict((Object)key);
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"LOWER_DIC_ID_", (Object)sysDictionary.getId());
            wrapper.or(wq -> {
                UpdateWrapper cfr_ignored_0 = (UpdateWrapper)wq.inSql((Object)"DETAIL_ID_", "select id_ from portal_sys_dictionary_detail  where DICTIONARY_ID_ = '" + sysDictionary.getId() + "'");
            });
            this.sysDictionaryCascadeDao.delete((Wrapper)wrapper);
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"DICTIONARY_ID_", (Object)sysDictionary.getId());
            this.sysDictionaryDetailDao.delete((Wrapper)updateWrapper);
        }
        cache.delLike("sys:dict:all:new:");
        this.sysDictionaryDao.deleteBatchIds(idsList);
        this.syncDictionaryRedis();
    }

    @Override
    public void updateDictionariesStatus(String ids, Integer status) {
        Assert.hasText((String)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        List<String> idsList = Arrays.asList(ids.split(","));
        this.sysDictionaryDao.updateDictionariesStatus(idsList, status);
        List list = this.sysDictionaryDao.selectBatchIds(idsList);
        if (status != 1) {
            for (SysDictionary sysDictionary : list) {
                String key = "sys:dictionary:new:" + sysDictionary.getCode().toUpperCase() + ":";
                cache.evict((Object)key);
            }
        }
        cache.delLike("sys:dict:all:new:");
    }

    @Override
    public SysDictionary loadDictionaryById(String id) {
        SysDictionary sysDictionary = (SysDictionary)((Object)this.sysDictionaryDao.selectById((Serializable)((Object)id)));
        if (sysDictionary != null) {
            SysDictionaryDetail sysDictionaryDetail = new SysDictionaryDetail();
            sysDictionaryDetail.setDictionaryId(id);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"DICTIONARY_ID_", (Object)id);
            List detail = this.sysDictionaryDetailDao.selectList((Wrapper)queryWrapper);
            sysDictionary.setDetails(detail);
        }
        return sysDictionary;
    }

    @Override
    public void moveDictionaries(String ids, String treeId) {
        Assert.hasText((String)ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)treeId, (String)"treeId\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> idsList = Arrays.asList(ids.split(","));
        this.sysDictionaryDao.moveDictionaries(idsList, treeId);
    }

    @Override
    public void updateDictionariesSequence(HashMap<String, Integer> map) {
        this.updateSequence(map);
    }

    @Override
    public void syncDictionaryRedis() throws IOException {
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"flag_", (Object)1);
        List list = this.sysDictionaryDao.selectList((Wrapper)queryWrapper);
        if (list.size() > 0) {
            cache.delLike("sys:dict:all:new:");
            HashMap<String, List> lowerRes = new HashMap<String, List>();
            for (SysDictionary sysDictionary : list) {
                String key2 = "sys:dictionary:new:" + sysDictionary.getCode().toUpperCase() + ":";
                this.setDictionaryDetails(sysDictionary, key2);
                List<DictionaryDetailVo> dictModelList = this.setDictionaryLowerDetails(sysDictionary, null);
                lowerRes.put(sysDictionary.getCode(), dictModelList);
            }
            if (lowerRes != null && lowerRes.size() > 0) {
                String tenantId = this.baseContext.getCurrentTenantId();
                cache.put((Object)("sys:dict:all:new:" + tenantId), (Object)JsonUtil.toJson(lowerRes));
                lowerRes.forEach((key, dictList) -> {
                    try {
                        cache.put((Object)("sys:dictionary:new:" + key.toUpperCase() + ":"), (Object)JsonUtil.toJson((Object)dictList));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    @Override
    public List<SysDictionary> queryLowerDictionary(String detailId) {
        return this.sysDictionaryDao.queryLowerDictionary(detailId);
    }

    @Override
    public Map<String, List<DictionaryDetailVo>> queryAllDictItems() throws IOException {
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        HashMap<String, List<DictionaryDetailVo>> res = null;
        String tenantId = this.baseContext.getCurrentTenantId();
        if (cache.get((Object)("sys:dict:all:new:" + tenantId)) != null) {
            res = JsonUtil.toMap((String)cache.get((Object)("sys:dict:all:new:" + tenantId)).toString());
        }
        if (res == null || res.size() == 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                queryWrapper.and(wq -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wq.eq((Object)"TENANT_ID_", (Object)tenantId)).or()).eq((Object)"KIND_ID_", (Object)1);
                });
            }
            queryWrapper.eq((Object)"FLAG_", (Object)1);
            List dictList = this.sysDictionaryDao.selectList((Wrapper)queryWrapper);
            res = new HashMap<String, List<DictionaryDetailVo>>();
            for (SysDictionary dict : dictList) {
                List<DictionaryDetailVo> dictModelList = this.setDictionaryLowerDetails(dict, null);
                res.put(dict.getCode(), dictModelList);
            }
            if (res != null && res.size() > 0) {
                cache.put((Object)("sys:dict:all:new:" + tenantId), (Object)JsonUtil.toJson(res));
            }
        }
        return res;
    }

    @Override
    public Map<String, List<SysDictionaryDetail>> queryDictItemsByCode(String codes) throws IOException {
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String tenantId = this.baseContext.getCurrentTenantId();
        List<String> codeList = Arrays.asList(codes.split(","));
        Map redisDict = null;
        HashMap res = null;
        if (cache.get((Object)("sys:dict:all:new:" + tenantId)) != null) {
            redisDict = JsonUtil.toMap((String)cache.get((Object)("sys:dict:all:new:" + tenantId)).toString());
        }
        if (redisDict != null && redisDict.size() > 0) {
            res = new HashMap();
            for (String code : codeList) {
                res.put(code, redisDict.get(code));
            }
        }
        if (redisDict == null || res == null) {
            res = new HashMap();
            QueryWrapper queryWrapper = new QueryWrapper();
            if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                queryWrapper.and(wq -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wq.eq((Object)"TENANT_ID_", (Object)tenantId)).or()).eq((Object)"KIND_ID_", (Object)1);
                });
            }
            ((QueryWrapper)queryWrapper.eq((Object)"FLAG_", (Object)1)).in((Object)"CODE_", codeList);
            List dictList = this.sysDictionaryDao.selectList((Wrapper)queryWrapper);
            for (SysDictionary dict : dictList) {
                String key = "sys:dictionary:new:" + dict.getCode().toUpperCase() + ":";
                List<SysDictionaryDetail> dictModelList = this.setDictionaryDetails(dict, key);
                res.put(dict.getCode(), dictModelList);
            }
        }
        return res;
    }

    @Override
    public String queryDictTextByKey(String code, String key, int kindId) {
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        String redisKey = "sys:cache:dict:new_" + code + ":" + key;
        String tenantId = null;
        if (kindId != 1) {
            tenantId = this.baseContext.getCurrentTenantId();
        }
        String val = "";
        return val;
    }

    @Override
    public List<DictModel> queryDictListItemsByCode(String code) {
        String tenantId = this.baseContext.getCurrentTenantId();
        return this.sysDictionaryDetailDao.queryDictModelItemsByCode(code, tenantId);
    }

    @Override
    public Map<String, List<DictModel>> dictMapByCode(String code) {
        String tenantId = this.baseContext.getCurrentTenantId();
        List<DictModel> modelList = this.sysDictionaryDetailDao.queryDictModelItemsByCode(code, tenantId);
        return modelList.stream().collect(Collectors.groupingBy(DictModel::getValue));
    }

    @Override
    public List<SysDictionaryDetail> queryLowerDictionaryDetail(String dictLowerId, String detailId) {
        return this.sysDictionaryDetailDao.queryLowerDictionaryDetail(dictLowerId, detailId);
    }

    private void checkValidity(SysDictionary sysDictionary) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(wq -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wq.eq((Object)"CODE_", (Object)sysDictionary.getCode())).eq(StringUtils.isNotBlank((CharSequence)sysDictionary.getTenantId()), (Object)"TENANT_ID_", (Object)sysDictionary.getTenantId())).or(qq -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qq.eq((Object)"CODE_", (Object)sysDictionary.getCode())).eq((Object)"KIND_ID_", (Object)1);
            });
        });
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)sysDictionary.getId()), (Object)"ID_", (Object)sysDictionary.getId());
        int num = this.sysDictionaryDao.selectCount((Wrapper)queryWrapper);
        if (num > 0) {
            throw new ApplicationException("\u7f16\u7801\u3010" + sysDictionary.getCode() + "\u3011\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u5c1d\u8bd5\uff01");
        }
    }

    private List<SysDictionaryDetail> setDictionaryDetails(SysDictionary sysDictionary, String key) {
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        QueryWrapper detailWrapper = new QueryWrapper();
        detailWrapper.eq((Object)"FLAG_", (Object)1);
        detailWrapper.eq((Object)"DICTIONARY_ID_", (Object)sysDictionary.getId());
        detailWrapper.orderByAsc((Object)"SN_");
        List detailEntityList = this.sysDictionaryDetailDao.selectList((Wrapper)detailWrapper);
        cache.put((Object)key, (Object)JSONObject.toJSONString((Object)detailEntityList));
        return detailEntityList;
    }

    private List<DictionaryDetailVo> setDictionaryLowerDetails(SysDictionary sysDictionary, String detailId) {
        QueryWrapper detailWrapper = new QueryWrapper();
        detailWrapper.eq((Object)"FLAG_", (Object)1);
        detailWrapper.eq((Object)"DICTIONARY_ID_", (Object)sysDictionary.getId());
        detailWrapper.inSql(StringUtils.isNotEmpty((CharSequence)detailId), (Object)"id_", "select c.LOWER_DETAIL_ID_ from portal_sys_dictionary_cascade c where c.DETAIL_ID_='" + detailId + "'");
        detailWrapper.orderByAsc((Object)"SN_");
        List detailEntityList = this.sysDictionaryDetailDao.selectList((Wrapper)detailWrapper);
        ArrayList<DictionaryDetailVo> detailList = null;
        if (detailEntityList != null) {
            detailList = new ArrayList<DictionaryDetailVo>();
            HashMap<String, List<DictionaryDetailVo>> res = null;
            for (SysDictionaryDetail detail : detailEntityList) {
                DictionaryDetailVo dicDetailVo = new DictionaryDetailVo();
                dicDetailVo.setId(detail.getId());
                dicDetailVo.setDictionaryId(detail.getDictionaryId());
                dicDetailVo.setName(detail.getName());
                dicDetailVo.setValue(detail.getValue());
                dicDetailVo.setSequence(detail.getSn());
                List<SysDictionary> list = this.queryLowerDictionary(detail.getId());
                for (SysDictionary dict : list) {
                    res = new HashMap<String, List<DictionaryDetailVo>>();
                    List<DictionaryDetailVo> dictModelList = this.setDictionaryLowerDetails(dict, detail.getId());
                    res.put(dict.getCode(), dictModelList);
                    dicDetailVo.setLowerDic(res);
                }
                detailList.add(dicDetailVo);
            }
        }
        return detailList;
    }
}

