/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.sysConfig.persistence.dao.DataDictDao;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.DataDict;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.sysConfig.vo.DataDictExcelVo;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="dataDictManager")
public class DataDictManagerImpl
extends BaseManagerImpl<DataDictDao, DataDict>
implements DataDictManager {
    @Resource
    SysTypeManager sysTypeManager;

    @Override
    public List<DataDict> getByTypeId(String typeId) {
        return ((DataDictDao)this.baseMapper).getByTypeId(typeId);
    }

    @Override
    public DataDict getByDictKey(String typeId, String key) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("typeId", typeId);
        params.put("key", key);
        return ((DataDictDao)this.baseMapper).getByDictKey(params);
    }

    public void removeByIds(String ... ids) {
        if (BeanUtils.isNotEmpty((Object)ids)) {
            for (String id : ids) {
                this.remove((Serializable)((Object)id));
                List<DataDict> childs = this.getChildrenByParentId(id);
                for (DataDict dict : childs) {
                    this.remove((Serializable)((Object)dict.getId()));
                }
            }
        }
        super.removeByIds(ids);
    }

    @Override
    public List<DataDict> getFirstChilsByParentId(String id) {
        return ((DataDictDao)this.baseMapper).getByParentId(id);
    }

    @Override
    public List<DataDict> getChildrenByParentId(String id) {
        List<DataDict> childs = ((DataDictDao)this.baseMapper).getByParentId(id);
        return this.getChilds(childs);
    }

    private List<DataDict> getChilds(List<DataDict> childs) {
        ArrayList<DataDict> dataDict = new ArrayList<DataDict>();
        if (BeanUtils.isNotEmpty(childs)) {
            for (DataDict dict : childs) {
                List<DataDict> children = ((DataDictDao)this.baseMapper).getByParentId(dict.getId());
                if (!BeanUtils.isNotEmpty(children)) continue;
                children = this.getChilds(children);
                dataDict.addAll(children);
            }
            dataDict.addAll(childs);
        }
        return dataDict;
    }

    @Override
    public void delByDictTypeId(String dictTypeId) {
        ((DataDictDao)this.baseMapper).delByDictTypeId(dictTypeId);
    }

    @Override
    public void updSn(String dicId, int sn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", dicId);
        params.put("sn", sn);
        ((DataDictDao)this.baseMapper).updSn(params);
    }

    @Override
    public CommonResult<String> removeByTypeIds(String typeIds) {
        if (StringUtil.isNotEmpty((String)typeIds)) {
            List<SysType> typeList = this.sysTypeManager.getChildByTypeId(typeIds);
            String[] typeIdList = new String[typeList.size() + 1];
            typeIdList[0] = typeIds;
            for (int i = 0; i < typeList.size(); ++i) {
                typeIdList[i + 1] = typeList.get(i).getId();
            }
            this.sysTypeManager.removeByIds(typeIdList);
            for (String typeId : typeIdList) {
                ((DataDictDao)this.baseMapper).delByDictTypeId(typeId);
            }
        }
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    @Transactional
    public void importData(List<MultipartFile> files, String typeId) throws Exception {
        Iterator<MultipartFile> it = files.iterator();
        HashMap<String, DataDict> data = new HashMap<String, DataDict>();
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            throw new BaseException("\u8bf7\u9009\u62e9\u6570\u636e\u5b57\u5178\u5206\u7c7b\u8fdb\u884c\u5bfc\u5165");
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List list = ExcelUtil.readExcel(DataDictExcelVo.class, (MultipartFile)file);
            LinkedList<DataDict> dataDictBuffer = new LinkedList<DataDict>();
            for (DataDictExcelVo vo : list) {
                String pKey = vo.getPidKey();
                String key = vo.getKey();
                String name = vo.getName();
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("typeId", typeId);
                params.put("key", key);
                DataDict dict = ((DataDictDao)this.baseMapper).getByDictKey(params);
                if (dict != null) {
                    throw new BaseException("\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                DataDict dataDict = new DataDict();
                dataDict.setTypeId(typeId);
                if (StringUtil.isEmpty((String)pKey)) {
                    dataDict.setParentId(typeId);
                } else {
                    HashMap<String, Object> pMap = new HashMap<String, Object>();
                    pMap.put("typeId", typeId);
                    pMap.put("key", pKey);
                    DataDict dtDict = ((DataDictDao)this.baseMapper).getByDictKey(pMap);
                    if (BeanUtils.isEmpty((Object)((Object)dtDict))) {
                        DataDict dmDict = (DataDict)((Object)data.get(pKey));
                        if (BeanUtils.isEmpty((Object)((Object)dmDict))) {
                            if (this.isParentKeyInList(pKey, list)) {
                                dataDict.setParentId(pKey);
                                dataDict.setKey(key);
                                dataDict.setName(name);
                                dataDictBuffer.add(dataDict);
                                continue;
                            }
                            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7236\u8282\u70b9key");
                        }
                        dataDict.setParentId(dmDict.getId());
                    }
                    dataDict.setParentId(dtDict.getId());
                }
                dataDict.setKey(key);
                dataDict.setName(name);
                this.create((Model)dataDict);
                data.put(key, dataDict);
            }
            this.handleSaveBuffer(dataDictBuffer, data);
        }
    }

    private boolean isParentKeyInList(String parentKey, List<DataDictExcelVo> list) {
        if (StringUtil.isEmpty((String)parentKey) || BeanUtils.isEmpty(list)) {
            return false;
        }
        for (DataDictExcelVo dataDictExcelVo : list) {
            if (!parentKey.equals(dataDictExcelVo.getPidKey())) continue;
            return true;
        }
        return false;
    }

    private void handleSaveBuffer(LinkedList<DataDict> list, Map<String, DataDict> data) {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        int count = 0;
        while (list.size() > 0) {
            DataDict dataDict = list.removeFirst();
            String parentKey = dataDict.getParentId();
            DataDict parent = data.get(parentKey);
            if (BeanUtils.isEmpty((Object)((Object)parent))) {
                list.addLast(dataDict);
                if (++count <= size) continue;
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e");
            }
            dataDict.setParentId(parent.getId());
            this.create((Model)dataDict);
            data.put(dataDict.getKey(), dataDict);
            size = list.size();
            count = 0;
        }
    }
}

