package com.artfess.report.bigScreen.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 可视化地图配置表
 *
 * @company 阿特菲斯
 * @author 王平
 * @since 2021-07-12
 */
@ApiModel(value="BladeVisualMap对象", description="可视化地图配置表")
public class BladeVisualMap extends BaseModel<BladeVisualMap> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "地图名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "地图数据")
    @TableField("map_data_")
    private String mapData;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getMapData() {
        return mapData;
    }

    public void setMapData(String mapData) {
        this.mapData = mapData;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BladeVisualMap{" +
            "id=" + id +
            ", name=" + name +
            ", mapData=" + mapData +
        "}";
    }
}
