/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.poi.util;

import com.artfess.poi.Excel;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.poi.util.HeaderNode;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHeader {
    private static final Logger log = LoggerFactory.getLogger(CustomHeader.class);

    public static void regionExport(List<HeaderNode> headerNodes, HttpServletResponse response, String fileName, String sheetName) throws IOException {
        Excel excel = new Excel();
        excel.sheet().sheetName(sheetName);
        HSSFWorkbook workbook = excel.getWorkBook();
        HSSFSheet sheet = workbook.getSheet(sheetName);
        HSSFCellStyle headStyle = workbook.createCellStyle();
        CustomHeader.defaultHeadStyle((CellStyle)headStyle);
        for (int i = 0; i <= 1; ++i) {
            sheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            int row = headerNode.getRow();
            if (row <= 1) {
                int col = headerNode.getColumn();
                excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName()).style(headStyle);
                CellRangeAddress region = headerNode.isOverNode() ? new CellRangeAddress(row, 3, col, col) : new CellRangeAddress(row, row, col, col + headerNode.getOverNodeCount() - 1);
                if (region.getNumberOfCells() <= 1) continue;
                sheet.addMergedRegionUnsafe(region);
                RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)region, (Sheet)sheet);
                continue;
            }
            excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName());
        }
    }

    public static void export(List<HeaderNode> headerNodes, HttpServletResponse response, String fileName, String sheetName) throws IOException {
        Excel excel = new Excel();
        excel.sheet().sheetName(sheetName);
        HSSFWorkbook workbook = excel.getWorkBook();
        HSSFSheet sheet = workbook.getSheet(sheetName);
        HSSFCellStyle headStyle = workbook.createCellStyle();
        CustomHeader.defaultHeadStyle((CellStyle)headStyle);
        for (int i = 0; i <= 1; ++i) {
            sheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            if (!StringUtils.isNotEmpty((CharSequence)headerNode.getHeaderName())) continue;
            excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName());
        }
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    private static void defaultHeadStyle(CellStyle headStyle) {
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
    }
}

