/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.consts;

import com.artfess.base.util.AppUtil;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class WeChatOffAccConsts {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    private static final String OPEN_AUTHORIZE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize";
    private static final String WX_URL = "https://api.weixin.qq.com/sns/oauth2";
    private static final String WX_Base_Url = "https://api.weixin.qq.com";

    public static SysExternalUnite getUnite() {
        SysExternalUniteManager manager = (SysExternalUniteManager)AppUtil.getBean(SysExternalUniteManager.class);
        return manager.getWeChatOfficialAccounts();
    }

    public static String generateMenuUrl(String baseUrl, String corpId) throws UnsupportedEncodingException {
        String redirectUri = baseUrl + "/weChatOffAcc?redirect=" + baseUrl + "/home";
        return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + URLEncoder.encode(redirectUri, "UTF-8") + "&response_type=code&scope=snsapi_base&state=artfess#wechat_redirect";
    }

    public static String getWxAccessToken(String code) {
        SysExternalUnite unite = WeChatOffAccConsts.getUnite();
        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + unite.getCorpId() + "&secret=" + unite.getCorpSecret() + "&code=" + code + "&grant_type=authorization_code";
        return url;
    }

    public static String refreshToken(String refreshToken) {
        SysExternalUnite unite = WeChatOffAccConsts.getUnite();
        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + unite.getCorpId() + "&grant_type=refresh_token" + "&refresh_token=" + refreshToken;
        return url;
    }

    public static String getWxUserInfo(String access_token, String openid) {
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=" + access_token + "&openid=" + openid;
        return url;
    }

    public static String send(String access_token) {
        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=" + access_token;
        return url;
    }

    public static String getTokenUrl() {
        SysExternalUnite unite = WeChatOffAccConsts.getUnite();
        String url = "https://api.weixin.qq.com/token?grant_type=client_credential&appid=" + unite.getCorpId() + "&secret=" + unite.getCorpSecret();
        return url;
    }

    public static String getWxAuthorize(String paramStr) throws UnsupportedEncodingException {
        SysExternalUnite unite = WeChatOffAccConsts.getUnite();
        String corpId = unite.getCorpId();
        String baseUrl = unite.getBaseUrl() + "/weChatOffAcc?params=" + paramStr;
        String redirect = URLEncoder.encode(baseUrl, "utf-8");
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + redirect + "&response_type=code&scope=snsapi_base&state=STATE#wechat_redirect";
        return url;
    }
}

