/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.core.runtime;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.helper.identity.BpmIdentityBuilder;
import com.artfess.bpm.api.helper.identity.BpmIdentityConverter;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.BpmUserCalcPlugin;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.plugindef.AbstractUserCalcPluginDef;
import com.artfess.bpm.plugin.usercalc.cusers.def.CusersPluginDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class AbstractUserCalcPlugin
implements BpmUserCalcPlugin,
ContextThread {
    private static ThreadLocal<Boolean> isPreVrewModel = new ThreadLocal();
    private BpmIdentityConverter bpmIdentityConverter;
    private BpmIdentityBuilder bpmIdentityBuilder;
    private BpmIdentityExtractService extractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);

    public static boolean isPreviewMode() {
        Boolean preVrewModel = isPreVrewModel.get();
        return preVrewModel != null && preVrewModel != false;
    }

    public static void cleanPreviewMode() {
        isPreVrewModel.remove();
    }

    public static void setPreviewMode(Boolean isPreview) {
        isPreVrewModel.set(isPreview);
    }

    protected BpmIdentityConverter getBpmIdentityConverter() {
        if (this.bpmIdentityConverter == null) {
            this.bpmIdentityConverter = (BpmIdentityConverter)AppUtil.getBean((String)"bpmIdentityConverter");
        }
        return this.bpmIdentityConverter;
    }

    protected BpmIdentityBuilder getBpmIdentityBuilder() {
        if (this.bpmIdentityBuilder == null) {
            this.bpmIdentityBuilder = (BpmIdentityBuilder)AppUtil.getBean(BpmIdentityBuilder.class);
        }
        return this.bpmIdentityBuilder;
    }

    protected List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) throws Exception {
        return null;
    }

    @Override
    public List<BpmIdentity> execute(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) throws Exception {
        if (AbstractUserCalcPlugin.isPreviewMode() && !this.supportPreView()) {
            return Collections.emptyList();
        }
        List<BpmIdentity> list = this.queryByPluginDef(pluginSession, pluginDef);
        if (BeanUtils.isEmpty(list)) {
            return list;
        }
        if (pluginDef instanceof CusersPluginDef && "startSuper".equals(((CusersPluginDef)pluginDef).getSource()) && BeanUtils.isEmpty((Object)list.get(0).getId())) {
            throw new BaseException("\u6d41\u7a0b\u53d1\u8d77\u4eba\u6ca1\u6709\u4e0a\u7ea7\u7528\u6237,\u8bf7\u8bbe\u7f6e\u4e0a\u7ea7");
        }
        ExtractType extractType = ((AbstractUserCalcPluginDef)pluginDef).getExtract();
        LinkedHashSet<BpmIdentity> set = new LinkedHashSet<BpmIdentity>();
        ArrayList<BpmIdentity> rtnList = new ArrayList<BpmIdentity>();
        list = this.extract(list, extractType);
        set.addAll(list);
        rtnList.addAll(set);
        return rtnList;
    }

    protected List<BpmIdentity> extract(List<BpmIdentity> bpmIdentities, ExtractType extractType) {
        if (BeanUtils.isEmpty(bpmIdentities)) {
            return Collections.EMPTY_LIST;
        }
        List<BpmIdentity> results = new ArrayList<BpmIdentity>();
        switch (extractType) {
            case EXACT_NOEXACT: {
                results = bpmIdentities;
                break;
            }
            case EXACT_EXACT_USER: {
                results = this.extractService.extractBpmIdentity(bpmIdentities);
                break;
            }
            case EXACT_GROUP_USER: {
                results = this.extractService.extractUserGroup(bpmIdentities);
                break;
            }
            case EXACT_EXACT_DELAY: {
                for (BpmIdentity identity : bpmIdentities) {
                    if (!"group".equals(identity.getType())) continue;
                    identity.setExtractType(ExtractType.EXACT_EXACT_DELAY);
                    results.add(identity);
                }
                break;
            }
        }
        return results;
    }

    public boolean supportPreView() {
        return true;
    }

    public void cleanAll() {
        AbstractUserCalcPlugin.cleanPreviewMode();
    }
}

