/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.form;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.ProcBoDef;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.engine.def.BpmDefUtil;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.BpmBusLink;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.http.client.ClientProtocolException;
import org.springframework.stereotype.Service;

@Service
public class BoDataServiceImpl
implements BoDataService {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    FormFeignService formRestfulService;

    @Override
    public List<ObjectNode> getDataByInst(BpmProcessInstance instance) throws Exception {
        DefaultBpmProcessDefExt defExt;
        List<ProcBoDef> boList;
        ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
        formRestParams.put("flowDefId", instance.getProcDefId());
        formRestParams.put("flowKey", instance.getProcDefKey());
        if (BeanUtils.isNotEmpty((Object)instance) && StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            DefaultBpmProcessInstance pInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            if (BeanUtils.isNotEmpty((Object)instance)) {
                formRestParams.put("parentFlowKey", pInstance.getProcDefKey());
            }
        }
        if (BeanUtils.isEmpty(boList = (defExt = BpmDefUtil.getProcessExt(instance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(instance))).getBoDefList())) {
            return Collections.emptyList();
        }
        Map<String, BpmBusLink> keyValueMap = this.bpmBusLinkManager.getMapByInstId(instance.getId());
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : keyValueMap.keySet()) {
            ObjectNode formPermissionObj;
            BpmBusLink link = keyValueMap.get(key);
            String id = StringUtil.isNotEmpty((String)link.getBusinesskeyStr()) ? link.getBusinesskeyStr() : link.getBusinesskey().toString();
            formRestParams.put("saveType", saveType);
            formRestParams.put("boid", id);
            formRestParams.put("code", link.getBoDefCode());
            formRestParams.put("nodeId", ContextThreadUtil.getCommuVar("nodeId", "").toString());
            Object formPermission = ContextThreadUtil.getCommuVar("formPermission", "");
            if (BeanUtils.isNotEmpty((Object)formPermission) && BeanUtils.isNotEmpty((Object)(formPermissionObj = (ObjectNode)JsonUtil.toJsonNode((String)formPermission.toString())).get("subRowAuth"))) {
                formRestParams.put("subRowAuthJosn", JsonUtil.toJson((Object)formPermissionObj.get("subRowAuth")));
            }
            ObjectNode boData = this.formRestfulService.getBodataById(formRestParams);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByBizKey(String businessKey) throws Exception {
        BpmProcessInstance instance = this.bpmProcessInstanceManager.getTopBpmProcessInstance(this.bpmProcessInstanceManager.getByBusinessKey(businessKey));
        DefaultBpmProcessDefExt defExt = BpmDefUtil.getProcessExt(instance);
        List<ProcBoDef> boList = defExt.getBoDefList();
        if (BeanUtils.isEmpty(boList)) {
            return Collections.emptyList();
        }
        Map<String, BpmBusLink> keyValueMap = this.bpmBusLinkManager.getMapByInstId(instance.getId());
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : keyValueMap.keySet()) {
            BpmBusLink link = keyValueMap.get(key);
            String id = StringUtil.isNotEmpty((String)link.getBusinesskeyStr()) ? link.getBusinesskeyStr() : link.getBusinesskey().toString();
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("saveType", saveType);
            formRestParams.put("boid", id);
            formRestParams.put("code", link.getBoDefCode());
            formRestParams.put("flowDefId", instance.getProcDefId());
            ObjectNode boData = this.formRestfulService.getBodataById(formRestParams);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByDefId(String defId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt();
        List<ProcBoDef> boList = defExt.getBoDefList();
        if (BeanUtils.isEmpty(boList)) {
            return null;
        }
        String saveType = defExt.isBoSaveToDb() ? "database" : "boObject";
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (ProcBoDef procBoDef : boList) {
            String boKey = procBoDef.getKey();
            ObjectNode boData = this.formRestfulService.getBodataByDefCode(saveType, boKey);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public List<ObjectNode> getDataByBoKeys(List<String> boKeyList) throws ClientProtocolException, IOException {
        ArrayList<ObjectNode> dataObjects = new ArrayList<ObjectNode>();
        for (String key : boKeyList) {
            ObjectNode boData = this.formRestfulService.getBodataByDefCode("database", key);
            dataObjects.add(boData);
        }
        return dataObjects;
    }

    @Override
    public ObjectNode getFormOpinionJson(String proInstId) throws Exception {
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        List<DefaultBpmCheckOpinion> opinionList = this.bpmCheckOpinionManager.getFormOpinionByInstId(proInstId);
        Map<String, Boolean> nodeTypeMap = this.convertNodeDef(proInstId);
        HashMap<String, String> identityMap = new HashMap<String, String>();
        for (DefaultBpmCheckOpinion opinion : opinionList) {
            ArrayNode ary;
            String formIdentity = opinion.getFormName();
            ObjectNode opinionJson = this.getJsonByOpinion(opinion);
            identityMap.put(formIdentity, opinion.getTaskKey());
            if (JsonUtil.isContainsKey((JsonNode)json, (String)formIdentity)) {
                ary = (ArrayNode)JsonUtil.toJsonNode((String)json.get(formIdentity).asText());
                ary.add((JsonNode)opinionJson);
                continue;
            }
            ary = JsonUtil.getMapper().createArrayNode();
            ary.add((JsonNode)opinionJson);
            json.set(formIdentity, (JsonNode)ary);
        }
        ObjectNode rtnJson = JsonUtil.getMapper().createObjectNode();
        Iterator it = json.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            ArrayNode ary = (ArrayNode)JsonUtil.toJsonNode((String)json.get(key).asText());
            String nodeId = (String)identityMap.get(key);
            boolean isSignTask = false;
            if (nodeTypeMap.containsKey(nodeId)) {
                isSignTask = nodeTypeMap.get(nodeId);
            }
            if (isSignTask) {
                rtnJson.set(key, (JsonNode)ary);
                continue;
            }
            ArrayNode tmpAry = JsonUtil.getMapper().createArrayNode();
            tmpAry.add(ary.get(ary.size() - 1));
            rtnJson.set(key, (JsonNode)tmpAry);
        }
        return rtnJson;
    }

    private Map<String, Boolean> convertNodeDef(String proInstId) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId));
        List<BpmNodeDef> nodeList = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (BpmNodeDef def : nodeList) {
            map.put(def.getNodeId(), NodeType.SIGNTASK.equals((Object)def.getType()));
        }
        return map;
    }

    private ObjectNode getJsonByOpinion(DefaultBpmCheckOpinion opinion) {
        ObjectNode json = JsonUtil.getMapper().createObjectNode();
        json.put("nodeId", opinion.getTaskKey());
        json.put("opinion", opinion.getOpinion());
        json.put("createTime", opinion.getCompleteTime().toString());
        json.put("status", opinion.getStatus());
        json.put("auditorName", opinion.getAuditorName());
        json.put("auditor", opinion.getAuditor());
        return json;
    }
}

