/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.reminders.plugin;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmReminderHistoryManager;
import com.artfess.bpm.persistence.manager.BpmTaskReminderManager;
import com.artfess.bpm.persistence.model.BpmReminderHistory;
import com.artfess.bpm.persistence.model.BpmTaskReminder;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.artfess.bpm.plugin.task.reminders.def.Reminder;
import com.artfess.bpm.plugin.task.reminders.def.RemindersPluginDef;
import com.artfess.bpm.plugin.task.reminders.def.WarningSet;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public class RemindersPlugin
extends AbstractBpmTaskPlugin {
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmTaskReminderManager bpmTaskReminderManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmReminderHistoryManager bpmReminderHistoryManager;

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        if (pluginSession.getEventType() == EventType.TASK_COMPLETE_EVENT) {
            this.bpmTaskReminderManager.deleteByTaskId(pluginSession.getBpmDelegateTask().getId());
            return null;
        }
        RemindersPluginDef reminderDef = (RemindersPluginDef)pluginDef;
        List<Reminder> reminderList = reminderDef.getReminderList();
        for (Reminder reminder : reminderList) {
            this.createReminder(reminder, pluginSession);
        }
        return null;
    }

    private void createReminder(Reminder reminder, BpmTaskPluginSession pluginSession) throws Exception {
        Boolean isSendMsg;
        Object object;
        BpmDelegateTask task = pluginSession.getBpmDelegateTask();
        String condition = reminder.getCondition();
        if (StringUtil.isNotEmpty((String)condition) && (object = this.executeScript(pluginSession, condition)) instanceof Boolean && !((Boolean)object).booleanValue()) {
            return;
        }
        BpmTaskReminder taskReminder = new BpmTaskReminder();
        taskReminder.setName(reminder.getName());
        taskReminder.setTaskId(task.getId());
        taskReminder.setDueAction(reminder.getDueAction());
        taskReminder.setDueScript(reminder.getDueScript());
        taskReminder.setDuration(reminder.getDueTime().longValue());
        taskReminder.setDateType(reminder.getDateType());
        if ("2".equals(reminder.getDateScriptType())) {
            taskReminder.setTypeScript(reminder.getTypeScript());
            JsonNode type = null;
            if (StringUtil.isNotEmpty((String)reminder.getTypeScript())) {
                type = (JsonNode)this.executeScript(pluginSession, reminder.getTypeScript());
            }
            if (BeanUtils.isNotEmpty(type)) {
                reminder.setDateType(type.asText());
            } else {
                reminder.setDateType("caltime");
            }
        }
        if ("2".equals(reminder.getDurationType())) {
            taskReminder.setDurationScript(reminder.getDurationScript());
            Double duration = null;
            if (StringUtil.isNotEmpty((String)reminder.getDurationScript())) {
                duration = Double.valueOf(this.executeScript(pluginSession, reminder.getDurationScript()).toString());
            }
            if (BeanUtils.isNotEmpty(duration)) {
                duration = duration * 60.0;
                reminder.setDueTime(duration.intValue());
                taskReminder.setDuration(reminder.getDueTime().longValue());
            } else {
                reminder.setDueTime(0);
                taskReminder.setDuration(reminder.getDueTime().longValue());
            }
        }
        if ("2".equals(reminder.getRelTimeType())) {
            taskReminder.setRelTimeScript(reminder.getRelTimeScript());
            Double relTime = null;
            if (StringUtil.isNotEmpty((String)reminder.getRelTimeScript())) {
                relTime = Double.valueOf(this.executeScript(pluginSession, reminder.getRelTimeScript()).toString());
            }
            if (BeanUtils.isNotEmpty(relTime)) {
                relTime = relTime * 60.0;
                reminder.setMsgSendTime(relTime.intValue());
            } else {
                reminder.setMsgSendTime(0);
            }
        }
        int sendMsg = (isSendMsg = reminder.getIsSendMsg()) != false ? 1 : 0;
        taskReminder.setIsSendMsg(sendMsg);
        if (sendMsg == 1) {
            taskReminder.setHtmlMsg(reminder.getHtmlMsg());
            taskReminder.setPlainMsg(reminder.getPlainMsg());
            taskReminder.setMsgCount(reminder.getMsgCount());
            taskReminder.setMsgType(reminder.getMsgType());
            taskReminder.setMsgInterval(reminder.getMsgInterval());
            taskReminder.setSendPerson(reminder.getSendPerson());
        }
        this.calcReminderDates(task, reminder, taskReminder);
    }

    @Transactional
    void calcReminderDates(BpmDelegateTask task, Reminder reminder, BpmTaskReminder taskReminder) throws Exception {
        LocalDateTime relDate = null;
        String relNodeId = reminder.getRelNodeId();
        String relNodeEvent = reminder.getRelNodeEvent();
        boolean isRelCreateEvent = "create".equals(relNodeEvent);
        if (task.getTaskDefinitionKey().equals(relNodeId) && isRelCreateEvent) {
            relDate = task.getCreateTime();
        } else {
            List<DefaultBpmCheckOpinion> dpcOpinions = this.bpmCheckOpinionManager.getByInstNodeId(ContextThreadUtil.getActionCmd().getInstId(), relNodeId);
            if (BeanUtils.isNotEmpty(dpcOpinions)) {
                DefaultBpmCheckOpinion dpcOpinion = dpcOpinions.get(dpcOpinions.size() - 1);
                relDate = isRelCreateEvent ? dpcOpinion.getCreateTime() : dpcOpinion.getCompleteTime();
            } else {
                throw new RuntimeException("\u50ac\u529e\u63d2\u4ef6\u76f8\u5bf9\u8282\u70b9\u5c1a\u672a\u5904\u7406\u3002\u8ba1\u7b97\u76f8\u5bf9\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38\uff01");
            }
        }
        if (relDate == null || TimeUtil.getTimeMillis((LocalDateTime)relDate) > TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now()) + 2000L) {
            throw new RuntimeException("\u50ac\u529e\u63d2\u4ef6\u76f8\u5bf9\u65f6\u95f4\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38");
        }
        LocalDateTime msgBeginDate = null;
        List<BpmIdentity> list = task.getExecutors();
        long sendTime = DateUtil.getCurrentTimeInMillis();
        long msgSendTime = DateUtil.getCurrentTimeInMillis();
        if (BeanUtils.isNotEmpty(list)) {
            for (BpmIdentity item : list) {
                LocalDateTime dueDate;
                if ("caltime".equals(reminder.getDateType())) {
                    dueDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)reminder.getDueTime(), (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
                    if (reminder.getIsSendMsg().booleanValue()) {
                        msgBeginDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)reminder.getMsgSendTime(), (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
                    }
                } else {
                    sendTime = this.ucFeignService.computeSendDate(item.getId(), (long)reminder.getDueTime().intValue());
                    dueDate = LocalDateTime.ofEpochSecond(sendTime / 1000L, 0, ZoneOffset.ofHours(8));
                    if (reminder.getIsSendMsg().booleanValue()) {
                        msgSendTime = this.ucFeignService.computeSendDate(item.getId(), (long)reminder.getMsgSendTime().intValue());
                    }
                    msgBeginDate = LocalDateTime.ofEpochSecond(msgSendTime / 1000L, 0, ZoneOffset.ofHours(8));
                }
                taskReminder.setDueDate(dueDate);
                taskReminder.setTriggerDate(dueDate);
                if (reminder.getIsSendMsg().booleanValue()) {
                    taskReminder.setMsgSendDate(msgBeginDate);
                    if (msgBeginDate.isBefore(dueDate)) {
                        taskReminder.setTriggerDate(msgBeginDate);
                    }
                }
                if (BeanUtils.isNotEmpty(reminder.getWarningSetList())) {
                    this.getWarningSet(reminder, task.getExecutors(), relDate, taskReminder);
                }
                taskReminder.setRelDate(relDate);
                taskReminder.setSendPerson("1");
                taskReminder.setSendUserId(item.getId());
                this.bpmTaskReminderManager.create((Model)taskReminder);
                this.createReminderHistory(taskReminder, "create");
            }
        }
    }

    private void getWarningSet(Reminder reminder, List<BpmIdentity> executors, LocalDateTime relDate, BpmTaskReminder taskReminder) throws Exception {
        ArrayNode warings = JsonUtil.getMapper().createArrayNode();
        for (WarningSet waringSet : reminder.getWarningSetList()) {
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((Object)waringSet);
            LocalDateTime warnDate = null;
            int warnTime = jsonObject.get("warnTime").asInt();
            if ("caltime".equals(reminder.getDateType())) {
                warnDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)warnTime, (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
            } else {
                ObjectNode params = JsonUtil.getMapper().createObjectNode();
                params.put("userId", executors.get(0).getId());
                if (BeanUtils.isNotEmpty((Object)relDate)) {
                    params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)relDate));
                }
                params.put("time", warnTime);
                String warnDateDateStr = this.systemConfigFeignService.getEndTimeByUser(params);
                warnDate = DateFormatUtil.parse((String)warnDateDateStr);
            }
            if (taskReminder.getTriggerDate() == null || warnDate.isBefore(taskReminder.getTriggerDate())) {
                taskReminder.setTriggerDate(warnDate);
            }
            jsonObject.put("warnDate", TimeUtil.getDateTimeString((LocalDateTime)warnDate));
            warings.add((JsonNode)jsonObject);
        }
        taskReminder.setWarningset(warings.toString());
    }

    private Object executeScript(BpmTaskPluginSession pluginSession, String script) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.putAll(pluginSession.getBpmDelegateTask().getVariables());
        Map<String, ObjectNode> boDatas = BpmContextUtil.getBoFromContext();
        vars.putAll(boDatas);
        return this.groovyScriptEngine.executeObject(script, vars);
    }

    @Transactional
    void createReminderHistory(BpmTaskReminder reminder, String type) {
        BpmReminderHistory history = new BpmReminderHistory();
        history.setExecuteDate(reminder.getDueDate());
        history.setRemindType(type);
        history.setNote("\u50ac\u529e\u521b\u5efa");
        history.setId(UniqueIdUtil.getSuid());
        history.setTaskId(reminder.getTaskId());
        this.bpmReminderHistoryManager.create((Model)history);
    }
}

