/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.service;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.IGlobalRestfulPluginDef;
import com.artfess.bpm.api.model.process.def.Restful;
import com.artfess.bpm.api.plugin.core.context.BpmPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.artfess.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.RestfulService;
import com.artfess.bpm.api.service.TaskCommuService;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCommuReceiverManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCommuManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.model.BpmCommuReceiver;
import com.artfess.bpm.persistence.model.BpmTaskCommu;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultTaskCommuService
implements TaskCommuService {
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmPluginFactory bpmPluginFactory;
    @Resource
    RestfulService restfulService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceMapper;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IUserService userServiceImpl;

    private BpmTaskCommu getByTasknew(String instId, String opinion) {
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByInstId(instId);
        if (taskCommu != null) {
            return taskCommu;
        }
        taskCommu = new BpmTaskCommu();
        taskCommu.setId(UniqueIdUtil.getSuid());
        taskCommu.setInstanceId(instId);
        taskCommu.setNodeName("\u6c9f\u901a\u4efb\u52a1");
        taskCommu.setSenderId(user.getUserId());
        taskCommu.setSender(user.getFullname());
        taskCommu.setCreatetime(LocalDateTime.now());
        taskCommu.setOpinion(opinion);
        this.bpmTaskCommuManager.create((Model)taskCommu);
        return taskCommu;
    }

    @Override
    @Transactional
    public void addCommuTask(String instId, String notifyType, String opinion, List<IUser> users, String files, String defId) throws Exception {
        DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceMapper.get((Serializable)((Object)instId));
        BpmTaskCommu commu = this.getByTasknew(instId, opinion);
        String commuId = commu.getId();
        this.addTranCheckOpinion(processInstance, OpinionStatus.START_COMMU, ContextUtil.getCurrentUserId(), opinion, files, "");
        for (IUser user : users) {
            BpmCommuReceiver receiver = this.getCommuReceiver(commuId, user);
            this.bpmCommuReceiverManager.create((Model)receiver);
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNotice notice = new BpmTaskNotice();
            notice.setStatus(TaskType.COMMU.getKey());
            notice.setId(UniqueIdUtil.getSuid());
            notice.setName("\u6c9f\u901a\u4efb\u52a1");
            notice.setProcInstId(instId);
            notice.setAssigneeId(user.getUserId());
            notice.setAssigneeName(user.getFullname());
            notice.setOwnerId(user.getUserId());
            notice.setOwnerName(user.getFullname());
            notice.setSubject(processInstance.getSubject());
            notice.setProcDefId(processInstance.getProcDefId());
            notice.setProcDefName(processInstance.getProcDefName());
            notice.setSupportMobile(processInstance.getSupportMobile());
            noticeManager.create((Model)notice);
            this.addTranCheckOpinion(processInstance, OpinionStatus.AWAITING_FEEDBACK, user.getUserId(), "", "", notice.getId());
        }
    }

    private BpmCommuReceiver getCommuReceiver(String commuId, IUser user) {
        BpmCommuReceiver receiver = new BpmCommuReceiver();
        receiver.setId(UniqueIdUtil.getSuid());
        receiver.setCommuId(commuId);
        receiver.setReceiver(user.getFullname());
        receiver.setReceiverId(user.getUserId());
        receiver.setStatus(BpmCommuReceiver.COMMU_NO);
        return receiver;
    }

    private BpmTaskCommu getByTask(DefaultBpmTask task, String opinion) {
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(task.getId());
        if (taskCommu != null) {
            return taskCommu;
        }
        taskCommu = new BpmTaskCommu();
        taskCommu.setId(UniqueIdUtil.getSuid());
        taskCommu.setInstanceId(task.getProcInstId());
        taskCommu.setNodeId(task.getNodeId());
        taskCommu.setNodeName(task.getName());
        taskCommu.setTaskId(task.getId());
        taskCommu.setSenderId(user.getUserId());
        taskCommu.setSender(user.getFullname());
        taskCommu.setCreatetime(LocalDateTime.now());
        taskCommu.setOpinion(opinion);
        this.bpmTaskCommuManager.create((Model)taskCommu);
        return taskCommu;
    }

    @Override
    @Transactional
    public void completeTask(String taskId, String notifyType, String opinion) throws Exception {
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(defaultBpmTask.getParentId());
        BpmCommuReceiver commuReceiver = this.bpmCommuReceiverManager.getByCommuUser(taskCommu.getId(), defaultBpmTask.getAssigneeId());
        commuReceiver.setStatus(BpmCommuReceiver.COMMU_FEEDBACK);
        if (commuReceiver.getReceiveTime() == null) {
            commuReceiver.setReceiveTime(LocalDateTime.now());
        }
        commuReceiver.setFeedbackTime(LocalDateTime.now());
        commuReceiver.setOpinion(opinion);
        this.bpmCommuReceiverManager.update((Model)commuReceiver);
        this.updOpinionComplete(taskId, OpinionStatus.FEEDBACK, ContextUtil.getCurrentUserId(), opinion);
        IUser user = BpmUtil.getUser(taskCommu.getSenderId(), taskCommu.getSender());
        MessageUtil.notify(defaultBpmTask, opinion, user, notifyType, "bpmCommuFeedBack");
        defaultBpmTask.setAssigneeId(ContextUtil.getCurrentUserId());
        this.restfulPluginExecut(defaultBpmTask, EventType.TASK_COMPLETE_EVENT);
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
    }

    @Override
    public void finishTask(String parentId) {
        this.bpmTaskManager.delByParentId(parentId);
    }

    private void addTranCheckOpinion(DefaultBpmProcessInstance def, OpinionStatus opinionStatus, String commuUser, String opinion, String files, String noticeId) {
        IUser user = this.userServiceImpl.getUserById(commuUser);
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        String bpmnInstId = def.getBpmnInstId();
        String superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(def.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(def.getId());
        checkOpinion.setTaskId(noticeId);
        checkOpinion.setTaskKey("");
        checkOpinion.setTaskName("\u6c9f\u901a\u4efb\u52a1");
        checkOpinion.setFiles(files);
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        checkOpinion.setOpinion(opinion);
        if (opinionStatus.equals((Object)OpinionStatus.START_COMMU)) {
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(durMs);
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
        }
        checkOpinion.setIsRead(1);
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    @Transactional
    private void updOpinionComplete(String taskId, OpinionStatus opinionStatus, String commuUser, String opinion) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.addFilter("task_id_", (Object)taskId, QueryOP.EQUAL);
        queryFilter.addFilter("status_", (Object)OpinionStatus.AWAITING_FEEDBACK, QueryOP.EQUAL);
        PageList opinions = this.bpmCheckOpinionManager.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)opinions)) {
            DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)opinions.getRows().get(0);
            IUser user = BpmUtil.getUser(commuUser);
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            checkOpinion.setOpinion(opinion);
            checkOpinion.setStatus(opinionStatus.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(durMs);
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
    }

    private void restfulPluginExecut(DefaultBpmTask task, EventType eventType) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(task.getProcDefId());
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                IGlobalRestfulPluginDef restfulPluginDef;
                List<Restful> restfuls;
                BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
                if (!(bpmPluginDef instanceof BpmExecutionPluginDef)) continue;
                BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
                BpmExecutionPlugin bpmExecutionPlugin = this.bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
                if (bpmExecutionPlugin == null || !bpmPluginContext.getEventTypes().contains((Object)eventType) || !(bpmExecutionPluginDef instanceof IGlobalRestfulPluginDef) || !BeanUtils.isNotEmpty(restfuls = (restfulPluginDef = (IGlobalRestfulPluginDef)((Object)bpmExecutionPluginDef)).getRestfulList())) continue;
                this.restfulService.outTaskPluginExecute(task, restfuls, eventType);
            }
        }
    }
}

