/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.artfess.bpm.api.plugin.core.runtime.TaskActionHandler;
import com.artfess.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.artfess.bpm.persistence.model.BpmTaskDueTime;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Resource;

public abstract class AbstractTaskActionHandler
implements TaskActionHandler {
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;

    @Override
    public Boolean execute(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        String nowtime;
        String expireTime;
        Boolean isExpire;
        BpmTaskDueTime bpmTaskDueTime;
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        BpmTask bpmTask = (BpmTask)finishCmd.getTransitVars("bpmTask_");
        String taskId = bpmTask.getTaskId();
        if (StringUtil.isNotEmpty((String)taskId) && BeanUtils.isNotEmpty((Object)((Object)(bpmTaskDueTime = this.bpmTaskDueTimeManager.getByTaskId(taskId)))) && (isExpire = Boolean.valueOf(DateUtil.compare((String)(expireTime = DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getExpirationDate())), (String)(nowtime = DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()))))).booleanValue()) {
            ((DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd()).setApprovalOpinion("\u4efb\u52a1\u5ef6\u671f  " + pluginSession.getTaskFinishCmd().getApprovalOpinion());
        }
        this.prepare(pluginSession, taskId);
        this.preActionHandler(pluginSession, def);
        if (this.isNeedCompleteTask()) {
            if (finishCmd.isOnlyFinishTask()) {
                this.natTaskService.completeTaskOnly(taskId);
            } else {
                String destinationNode = finishCmd.getDestination();
                if (StringUtil.isEmpty((String)destinationNode)) {
                    this.natTaskService.completeTask(taskId);
                } else {
                    this.natTaskService.completeTask(taskId, destinationNode);
                }
            }
        }
        this.afterActionHandler(pluginSession, def);
        return true;
    }

    private void prepare(TaskActionPluginSession pluginSession, String taskId) {
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        Map<String, Object> vars = finishCmd.getVariables();
        if (vars.size() == 0) {
            vars = this.natTaskService.getVariables(taskId);
            finishCmd.setVariables(vars);
        } else {
            this.natTaskService.setVariables(taskId, vars);
        }
    }

    public abstract void preActionHandler(TaskActionPluginSession var1, TaskActionHandlerDef var2) throws Exception;

    public abstract void afterActionHandler(TaskActionPluginSession var1, TaskActionHandlerDef var2) throws Exception;
}

