/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.script;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.groovy.IUserScript;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class UserRelScript
implements IUserScript {
    @Resource
    IUserService userService;
    @Resource
    UCFeignService uCFeignService;

    private Set<BpmIdentity> convertUserList(List<IUser> list) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        for (IUser iUser : list) {
            if (!BeanUtils.isNotEmpty((Object)iUser) || !BeanUtils.isEmpty((Object)iUser.getStatus()) && iUser.getStatus() != 1) continue;
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(iUser.getUserId());
            bpmIdentity.setName(iUser.getFullname());
            bpmIdentity.setType("user");
            identitys.add((BpmIdentity)bpmIdentity);
        }
        return identitys;
    }

    private List<IUser> getSuperUserByRel(String userId, String typeCode) {
        ArrayList<IUser> list = new ArrayList<IUser>();
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("userId", userId);
        obj.put("typeCode", typeCode);
        List sysUserRels = this.uCFeignService.getSuperUser(obj);
        if (BeanUtils.isNotEmpty((Object)sysUserRels)) {
            for (ObjectNode sysUserRel : sysUserRels) {
                UserFacade user = new UserFacade();
                user.setUserId(sysUserRel.get("id").asText());
                user.setFullname(sysUserRel.get("fullname").asText());
                list.add((IUser)user);
            }
        }
        return list;
    }

    private List<IUser> usersObjConvertToIusers(List<ObjectNode> objs) {
        ArrayList<IUser> list = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty(objs)) {
            for (ObjectNode obj : objs) {
                UserFacade user = new UserFacade();
                user.setId(obj.get("id").asText());
                user.setAccount(obj.get("account").asText());
                user.setFullname(obj.get("fullname").asText());
                user.setUserId(obj.get("id").asText());
                user.setStatus(Integer.valueOf(obj.get("status").asInt()));
                list.add((IUser)user);
            }
        }
        return list;
    }

    public Set<BpmIdentity> getChargesByOrgId(Object orgId, Boolean isMain) {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        if (BeanUtils.isNotEmpty((Object)orgId)) {
            String obj = orgId + "";
            String[] orgIds = obj.split(",");
            ArrayList<IUser> list = new ArrayList<IUser>();
            for (String id : orgIds) {
                List users = this.uCFeignService.getChargesByOrgId(id.toString(), isMain.booleanValue());
                if (!BeanUtils.isNotEmpty((Object)users)) continue;
                list.addAll(this.usersObjConvertToIusers(users));
            }
            if (BeanUtils.isNotEmpty(list)) {
                identitys = this.convertUserList(list);
            }
        }
        return identitys;
    }

    public Set<BpmIdentity> getUpChargesByOrgId(Object orgId, Boolean isMain) {
        ObjectNode org;
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        if (BeanUtils.isNotEmpty((Object)orgId) && BeanUtils.isNotEmpty((Object)(org = this.uCFeignService.getOrgByIdOrCode(orgId.toString())))) {
            identitys = this.getChargesByOrgId(org.get("parentId").asText(), isMain);
        }
        return identitys;
    }

    public Set<BpmIdentity> getChargesByPreNode(Boolean isMain, String demCode) {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ObjectNode orgUser = this.uCFeignService.getOrgUserMaster(ContextUtil.getCurrentUserId(), demCode);
        if (BeanUtils.isNotEmpty((Object)orgUser)) {
            identitys = this.getChargesByOrgId(orgUser.get("orgId").asText(), isMain);
        }
        return identitys;
    }

    public Set<BpmIdentity> getByRelPreNode(String typeCode) {
        if (StringUtil.isEmpty((String)typeCode)) {
            typeCode = null;
        }
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet();
        List<IUser> list = this.getSuperUserByRel(ContextUtil.getCurrentUser().getUserId(), typeCode);
        identitys = this.convertUserList(list);
        return identitys;
    }

    public Set<BpmIdentity> getByRelStartUser(String typeCode) {
        Set<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            String userId = (String)taskCmd.getVariables().get("startUser");
            List<IUser> list = this.getSuperUserByRel(userId, typeCode);
            identitys = this.convertUserList(list);
        }
        return identitys;
    }

    public Set<BpmIdentity> getByRelStartUser() {
        return this.getByRelStartUser(null);
    }

    public Set<BpmIdentity> getSubFieldUser(String tableName, String field) throws IOException {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String json = cmd.getBusData();
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        Iterator it = jsonObj.fields();
        ArrayList<IUser> userList = new ArrayList<IUser>();
        while (it.hasNext()) {
            ObjectNode mainTable = (ObjectNode)it.next();
            if (!BeanUtils.isNotEmpty((Object)mainTable)) continue;
            ArrayNode subTable = (ArrayNode)mainTable.get("sub_" + tableName);
            for (JsonNode object : subTable) {
                String[] ids;
                ObjectNode subData = (ObjectNode)object;
                String fieldValue = subData.get(field).asText();
                if (!StringUtil.isNotEmpty((String)fieldValue)) continue;
                for (String id : ids = fieldValue.split(",")) {
                    IUser iUser = this.userService.getUserById(id);
                    if (!BeanUtils.isNotEmpty((Object)iUser)) continue;
                    userList.add(iUser);
                }
            }
        }
        if (BeanUtils.isNotEmpty(userList)) {
            identitys.addAll(this.convertUserList(userList));
        }
        return identitys;
    }

    public Set<BpmIdentity> getSubFieldOrg(String tableName, String field, boolean isMain) throws IOException {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        String json = cmd.getBusData();
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        Iterator it = jsonObj.fields();
        while (it.hasNext()) {
            ObjectNode mainTable = (ObjectNode)it.next();
            if (!BeanUtils.isNotEmpty((Object)mainTable)) continue;
            ArrayNode subTable = (ArrayNode)mainTable.get("sub_" + tableName);
            for (Object object : subTable) {
                String[] orgIds;
                ObjectNode subData = (ObjectNode)object;
                String fieldValue = subData.get(field).asText();
                if (!StringUtil.isNotEmpty((String)fieldValue)) continue;
                for (String orgId : orgIds = fieldValue.split(",")) {
                    Set<BpmIdentity> orgIdentitys = this.getChargesByOrgId(orgId, isMain);
                    identitys.addAll(orgIdentitys);
                }
            }
        }
        return identitys;
    }

    public Set<BpmIdentity> getUserFromBusSql(String sql) throws Exception {
        List query;
        JdbcTemplate jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        if ((sql = sql.toUpperCase()).contains("<#ID#>")) {
            ActionCmd cmd = ContextThreadUtil.getActionCmd();
            HashMap boInst = (HashMap)cmd.getTransitVars().get("bo_inst_");
            String boKey = (String)boInst.keySet().iterator().next();
            ObjectNode boData = (ObjectNode)boInst.get(boKey);
            String id = boData.get("id_").asText();
            sql = sql.replace("<#ID#>", id);
        }
        if (BeanUtils.isEmpty((Object)(query = jdbcTemplate.queryForList(sql)))) {
            return identitys;
        }
        if (((Map)query.get(0)).size() != 1) {
            throw new RuntimeException("SQL\u67e5\u8be2\u5217\u6570\u4e0d\u80fd\u8d85\u8fc71");
        }
        ArrayList<IUser> users = new ArrayList<IUser>();
        for (Map stringObjectMap : query) {
            IUser user;
            String key;
            String id = (String)stringObjectMap.get(key = (String)stringObjectMap.keySet().iterator().next());
            if (this.isContainsUserId(users, id) || !BeanUtils.isNotEmpty((Object)(user = this.userService.getUserById(id)))) continue;
            users.add(user);
        }
        if (BeanUtils.isNotEmpty(users)) {
            identitys.addAll(this.convertUserList(users));
        }
        return identitys;
    }

    private boolean isContainsUserId(List<IUser> users, String id) {
        if (BeanUtils.isNotEmpty(users)) {
            return false;
        }
        for (IUser user : users) {
            if (user.getUserId() != id) continue;
            return true;
        }
        return false;
    }
}

