/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.annotation.AsyncThreadClean;
import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.service.PropertyService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.string.StringValidator;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.cmd.ProcessInstCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.InterPoseType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.def.NodeProperties;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeForm;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.model.process.task.BpmTaskOpinion;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmFormService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmOpinionService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.api.service.DiagramService;
import com.artfess.bpm.engine.def.impl.handler.PropertiesBpmDefXmlHandler;
import com.artfess.bpm.engine.form.BpmFormFactory;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.form.FormCategory;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.model.var.DefaultBpmVariableDef;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCommuReceiverManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackRelationManager;
import com.artfess.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskCommuManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskReminderManager;
import com.artfess.bpm.persistence.model.BpmBusLink;
import com.artfess.bpm.persistence.model.BpmIdentityResult;
import com.artfess.bpm.persistence.model.BpmInterposeRecored;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProStatus;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.util.BpmStackRelationUtil;
import com.artfess.bpm.persistence.util.ServiceUtil;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.bpm.util.BpmIdentityUtil;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.params.BpmCheckOpinionVo;
import com.artfess.workflow.runtime.params.BpmImageParamObject;
import com.artfess.workflow.runtime.params.BpmNodeDefVo;
import com.artfess.workflow.runtime.params.BpmTaskResult;
import com.artfess.workflow.runtime.params.DefOtherParam;
import com.artfess.workflow.runtime.params.DoEndParamObject;
import com.artfess.workflow.runtime.params.DoNextParamObject;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.artfess.workflow.runtime.params.StartResult;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="IProcessManager")
public class ProcessManagerImpl
implements IProcessManager {
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BpmInstService processInstanceService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmExeStackRelationManager relationManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    PropertiesBpmDefXmlHandler propertiesBpmDefXmlHandler;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    NatTaskService natTaskService;
    @Resource(name="defaultBpmFormService")
    BpmFormService bpmFormService;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceMapper;
    @Resource
    IFlowManager flowManager;
    @Resource
    BaseContext baseContext;
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmTaskReminderManager taskReminderManager;
    @Value(value="${system.flow.tasksInStartResult:false}")
    private Boolean tasksInStartResult;

    @Override
    @Transactional
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public CompletableFuture<StartResult> start(StartFlowParamObject startFlowParamObject) throws Exception {
        StartResult result = this.syncStart(startFlowParamObject);
        return CompletableFuture.completedFuture(result);
    }

    @Override
    public StartResult syncStart(StartFlowParamObject startFlowParamObject) throws Exception {
        String current = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)current) && StringUtil.isEmpty((String)startFlowParamObject.getAccount())) {
            startFlowParamObject.setAccount(current);
        } else if (StringUtil.isNotEmpty((String)startFlowParamObject.getAccount()) && !startFlowParamObject.getAccount().equals(current)) {
            SecurityContextHolder.getContext().setAuthentication(null);
            IUser userByAccount = this.userServiceImpl.getUserByAccount(startFlowParamObject.getAccount());
            ContextUtil.setCurrentUser((IUser)userByAccount);
        }
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        BpmProcessInstance instance = this.processInstanceService.startProcessInst((ProcessInstCmd)processCmd);
        String instId = instance.getId();
        String curBoPkVal = "";
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        StartResult result = this.getFlowparameter(instId, curBoPkVal);
        return result;
    }

    public CompletableFuture<StartResult> startSync(StartFlowParamObject startFlowParamObject) throws Exception {
        String current = this.baseContext.getCurrentUserAccout();
        if (StringUtil.isNotEmpty((String)current) && StringUtil.isEmpty((String)startFlowParamObject.getAccount())) {
            startFlowParamObject.setAccount(current);
        }
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        BpmProcessInstance instance = this.processInstanceService.startProcessInst((ProcessInstCmd)processCmd);
        String instId = instance.getId();
        String curBoPkVal = "";
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        StartResult result = this.getFlowparameter(instId, curBoPkVal);
        return CompletableFuture.completedFuture(result);
    }

    private StartResult getFlowparameter(String instId, String curBoPkVal) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        List byBpmInstIdUserIdGroupList = null;
        if (this.tasksInStartResult.booleanValue()) {
            byBpmInstIdUserIdGroupList = this.bpmTaskManager.getByBpmInstIdUserIdGroupList(instId, userId, new ArrayList());
        }
        DefaultBpmProcessInstance instanceByInstId = this.getInstanceByInstId(instId);
        return new StartResult("\u6d41\u7a0b\u542f\u52a8\u6210\u529f", instId, curBoPkVal, byBpmInstIdUserIdGroupList, instanceByInstId);
    }

    @Override
    @Transactional
    public StartResult saveDraft(StartFlowParamObject startFlowParamObject) throws Exception {
        ContextUtil.clearAll();
        DefaultProcessInstCmd processCmd = this.getStartCmd(startFlowParamObject);
        processCmd.setApproval(startFlowParamObject.getApproval());
        Map map = this.processInstanceService.saveDraft((ProcessInstCmd)processCmd);
        BpmProcessInstance instance = (BpmProcessInstance)map.get("instance");
        String msg = (String)map.get("msg");
        String instId = instance.getId();
        if (BeanUtils.isEmpty((Object)instance.getSubject())) {
            throw new BaseException("\u6d41\u7a0b\u6807\u9898\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6807\u9898\u8bbe\u7f6e");
        }
        String curBoPkVal = "";
        if (BeanUtils.isNotEmpty((Object)ThreadMsgUtil.getMapMsg((String)"curBoPkVal"))) {
            curBoPkVal = ThreadMsgUtil.getMapMsg((String)"curBoPkVal");
        }
        return new StartResult(msg, instId, curBoPkVal);
    }

    private DefaultProcessInstCmd getStartCmd(StartFlowParamObject startFlowParamObject) throws Exception {
        DefaultBpmTask task;
        String nodeUsers;
        DefaultBpmDefinition def;
        DefaultBpmProcessInstance processInstance;
        String defId = startFlowParamObject.getDefId();
        String flowKey = startFlowParamObject.getFlowKey();
        String sysCode = startFlowParamObject.getSysCode();
        String formType = startFlowParamObject.getFormType();
        String proInstId = startFlowParamObject.getProInstId();
        String busData = "";
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getData())) {
            busData = com.artfess.base.util.Base64.getFromBase64((String)startFlowParamObject.getData());
        }
        String businessKey = startFlowParamObject.getBusinessKey();
        if (StringUtil.isEmpty((String)defId) && StringUtil.isEmpty((String)flowKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":" + "\u6d41\u7a0b\u5b9a\u4e49ID\u548c\u6d41\u7a0bkey\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!");
        }
        if (StringUtil.isNotEmpty((String)proInstId) && BeanUtils.isNotEmpty((Object)(processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)proInstId)))) && !ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus())) {
            throw new BaseException("\u8be5\u5b9e\u4f8bid\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u662f\u8349\u7a3f\u72b6\u6001");
        }
        DefaultProcessInstCmd processCmd = new DefaultProcessInstCmd();
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getAccount()) && !ContextUtil.getCurrentUser().getAccount().equals(startFlowParamObject.getAccount())) {
            IUser userByAccount = this.userServiceImpl.getUserByAccount(startFlowParamObject.getAccount());
            SecurityContextHolder.getContext().setAuthentication(null);
            ContextUtil.setCurrentUser((IUser)userByAccount);
            processCmd.addTransitVars("startUser", (Object)userByAccount);
        }
        if (StringUtil.isNotEmpty((String)businessKey)) {
            processCmd.setBusinessKey(businessKey);
        }
        if (BeanUtils.isNotEmpty((Object)startFlowParamObject.getUrgentStateValue()) && startFlowParamObject.getUrgentStateValue().hasNonNull("new")) {
            processCmd.setUrgentState(startFlowParamObject.getUrgentStateValue().get("new").asText());
        }
        if (StringUtil.isNotEmpty((String)defId)) {
            processCmd.setProcDefId(defId);
        }
        if (StringUtil.isEmpty((String)defId) && StringUtil.isNotEmpty((String)flowKey)) {
            BpmDefinition bpmDefinition = null;
            if (BeanUtils.isEmpty((Object)startFlowParamObject.getVersion())) {
                bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefKey(flowKey, false);
                if (BeanUtils.isEmpty((Object)bpmDefinition)) {
                    throw new BaseException("flowKey\u4e3a" + flowKey + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
                }
            } else {
                List definitions = this.bpmDefinitionManager.queryByDefKey(flowKey);
                if (BeanUtils.isNotEmpty((Object)definitions)) {
                    for (DefaultBpmDefinition defaultBpmDefinition : definitions) {
                        if (defaultBpmDefinition.getVersion() != startFlowParamObject.getVersion()) continue;
                        bpmDefinition = defaultBpmDefinition;
                        break;
                    }
                    if (BeanUtils.isEmpty((Object)bpmDefinition)) {
                        throw new BaseException(String.format("\u6839\u636eflowKey\u3010%s\u3011\u672a\u67e5\u627e\u5230\u7248\u672c\u4e3a\u3010%s\u3011\u7684\u6d41\u7a0b", flowKey, startFlowParamObject.getVersion()));
                    }
                } else {
                    throw new BaseException("flowKey\u4e3a" + flowKey + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
                }
            }
            defId = bpmDefinition.getDefId();
            processCmd.setFlowKey(flowKey);
        }
        if (BeanUtils.isEmpty((Object)(def = this.bpmDefinitionManager.getById(defId)))) {
            throw new BaseException("id\u4e3a" + defId + "\u7684\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        if ("forbidden".equals(def.getStatus()) || "forbidden_instance".equals(def.getStatus())) {
            throw new BaseException("\u6d41\u7a0b\u5b9a\u4e49\u5df2\u88ab\u7981\u6b62\u65e0\u6cd5\u53d1\u8d77\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        processCmd.setSupportMobile(def.getSupportMobile());
        processCmd.setBusData(busData);
        processCmd.setAgentLeaderId(startFlowParamObject.getAgentLeaderId());
        if (StringUtil.isNotEmpty((String)sysCode)) {
            processCmd.setSysCode(sysCode);
        }
        if (StringUtil.isEmpty((String)formType)) {
            processCmd.setDataMode(this.getFormType(defId));
        } else {
            processCmd.setDataMode(FormCategory.FRAME.value().equals(formType) ? "pk" : "bo");
        }
        ObjectNode node = JsonUtil.getMapper().createObjectNode();
        node.put("defId", startFlowParamObject.getDefId());
        node.put("flowKey", startFlowParamObject.getFlowKey());
        List<BpmVariableDef> list = this.flowManager.getWorkflowVar(node.toString());
        if (list != null && list.size() > 0) {
            Map<String, String> existVars = startFlowParamObject.getVars();
            if (BeanUtils.isEmpty(existVars)) {
                existVars = new HashMap<String, String>();
                startFlowParamObject.setVars(existVars);
            }
            for (int i = 0; i < list.size(); ++i) {
                String key = list.get(i).getVarKey();
                if (existVars.containsKey(key)) continue;
                existVars.put(key, list.get(i).getDefaultVal() + "");
            }
            this.setValriablesToCmd(defId, "", existVars, (BaseActionCmd)processCmd);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getDestination())) {
            processCmd.setDestination(startFlowParamObject.getDestination());
        }
        if (StringUtil.isNotEmpty((String)(nodeUsers = startFlowParamObject.getNodeUsers()))) {
            int isSendNodeUsers = startFlowParamObject.getIsSendNodeUsers();
            Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
            if (BeanUtils.isNotEmpty((Object)specUserMap)) {
                processCmd.addVariable("bpm_node_users_", JsonUtil.toJson((Object)specUserMap));
                if (isSendNodeUsers == 1) {
                    processCmd.setBpmIdentities(specUserMap);
                }
            }
        }
        if (StringUtil.isNotEmpty((String)proInstId)) {
            processCmd.setInstId(proInstId);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getStartOrgId())) {
            processCmd.addTransitVars("start_org_id", (Object)startFlowParamObject.getStartOrgId());
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getTaskId()) && BeanUtils.isNotEmpty((Object)(task = this.bpmTaskManager.getByTaskId(startFlowParamObject.getTaskId())))) {
            processCmd.addTransitVars("bpmTask_", (Object)task);
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getFormKey())) {
            processCmd.setFormKey(startFlowParamObject.getFormKey());
        }
        if (StringUtil.isNotEmpty((String)startFlowParamObject.getUpdateSubTableJson())) {
            ThreadMsgUtil.addMapMsg((String)"updateSubTableJson", (String)startFlowParamObject.getUpdateSubTableJson());
        }
        return processCmd;
    }

    private String getFormType(String defId) {
        String formType = "bo";
        try {
            FormCategory type;
            Form form;
            BpmNodeForm nodeForm = this.bpmFormService.getByDefId(defId);
            if (BeanUtils.isNotEmpty((Object)nodeForm) && BeanUtils.isNotEmpty((Object)(form = nodeForm.getForm())) && FormCategory.FRAME.equals((Object)(type = form.getType()))) {
                formType = "pk";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formType;
    }

    private Map<String, Object> getActVars(String defId, String nodeId, Map<String, String> varMap) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ArrayList bpmVariableList = defExt.getVariableList();
        if (bpmVariableList == null) {
            bpmVariableList = new ArrayList();
        }
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)nodeId)) {
            bpmVariableList.addAll(defExt.getVariableList(nodeId));
        }
        for (BpmVariableDef var : bpmVariableList) {
            String varkey = var.getVarKey();
            String val = varMap.get(varkey);
            if (val == null) continue;
            Object rtnVal = DefaultBpmVariableDef.getValue((String)var.getDataType(), (String)val);
            rtnMap.put(varkey, rtnVal);
        }
        return rtnMap;
    }

    @Override
    @Transactional
    public CommonResult<String> doNext(DoNextParamObject doNextParamObject) throws Exception {
        String destination;
        ContextUtil.clearAll();
        String account = doNextParamObject.getAccount();
        ServiceUtil.setCurrentUser((String)account);
        String taskId = doNextParamObject.getTaskId();
        String actionName = doNextParamObject.getActionName();
        String opinion = doNextParamObject.getOpinion();
        String data = "";
        String base64data = doNextParamObject.getData();
        if (StringUtil.isNotEmpty((String)base64data)) {
            data = com.artfess.base.util.Base64.getFromBase64((String)base64data);
        }
        Boolean directHandlerSign = doNextParamObject.getDirectHandlerSign();
        String backHandMode = doNextParamObject.getBackHandMode();
        String jumpType = doNextParamObject.getJumpType();
        if (this.bpmTaskService.getByTaskId(taskId) == null) {
            throw new RuntimeException("\u6b64\u4efb\u52a1\u5df2\u88ab\u5904\u7406\u6216\u4e0d\u5b58\u5728");
        }
        DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
        if (("free".equals(jumpType) || "select".equals(jumpType) || "reject".equals(actionName)) && StringUtil.isNotEmpty((String)(destination = doNextParamObject.getDestination()))) {
            cmd.setDestination(destination);
        }
        if (directHandlerSign.booleanValue()) {
            cmd.addTransitVars("signDirect", (Object)"1");
        }
        cmd.setTaskId(taskId);
        cmd.setActionName(actionName);
        cmd.setApprovalOpinion(opinion);
        if (StringUtil.isNotEmpty((String)data)) {
            BpmUtil.handOpinion((String)data, (DefaultTaskFinishCmd)cmd);
            cmd.setBusData(data);
            cmd.setDataMode("bo");
        }
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        Map<String, String> vars = doNextParamObject.getVars();
        this.setValriablesToCmd(bpmTask.getProcDefId(), bpmTask.getNodeId(), vars, (BaseActionCmd)cmd);
        cmd.addTransitVars("backHandMode", (Object)backHandMode);
        String nodeUsers = "";
        if (StringUtil.isNotEmpty((String)doNextParamObject.getNodeUsers())) {
            nodeUsers = com.artfess.base.util.Base64.getFromBase64((String)doNextParamObject.getNodeUsers());
        }
        if (StringUtil.isNotEmpty((String)nodeUsers)) {
            Map specUserMap = BpmIdentityUtil.getBpmIdentity((String)nodeUsers);
            cmd.addTransitVars("bpm_node_users_", (Object)specUserMap);
            cmd.setBpmIdentities(specUserMap);
        }
        if (StringUtil.isNotEmpty((String)doNextParamObject.getNotifyType())) {
            cmd.setNotifyType(doNextParamObject.getNotifyType());
        }
        ContextUtil.setCurrentUserByAccount((String)account);
        this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
        return new CommonResult(true, "\u4efb\u52a1\u5904\u7406\u6210\u529f");
    }

    private void setVariables(String defId, String nodeId, String vars, BaseActionCmd cmd) throws Exception {
        Map<String, String> variables = this.convertVars(vars);
        Map<String, Object> varMap = this.getActVars(defId, nodeId, variables);
        if (BeanUtils.isNotEmpty(varMap)) {
            cmd.setVariables(varMap);
        }
    }

    private void setValriablesToCmd(String defId, String nodeId, Map<String, String> variables, BaseActionCmd cmd) throws Exception {
        if (BeanUtils.isEmpty(variables)) {
            return;
        }
        Map<String, Object> varMap = this.getActVars(defId, nodeId, variables);
        if (BeanUtils.isNotEmpty(varMap)) {
            cmd.setVariables(varMap);
        }
    }

    @Override
    public List<BpmNodeDefVo> getEnableRejectNode(String taskId, String rejectType) throws Exception {
        String nodeId;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        String defId = task.getProcDefId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId = task.getNodeId());
        NodeProperties nodeProperties = taskNodeDef.getLocalProperties();
        String backMode = nodeProperties.getBackMode();
        if (StringUtil.isEmpty((String)backMode)) {
            backMode = "normal";
        }
        String procInstId = task.getProcInstId();
        List listBpmNodeDef = BpmStackRelationUtil.getHistoryListBpmNodeDef((String)procInstId, (String)task.getNodeId(), (String)"pre");
        ArrayList<BpmNodeDefVo> bpmExeStacksUserNode = new ArrayList<BpmNodeDefVo>();
        ArrayList<BpmNodeDefVo> bpmExeStacksGoMapUserNode = new ArrayList<BpmNodeDefVo>();
        List relationList = this.relationManager.getListByProcInstId(procInstId);
        for (BpmNodeDef node : listBpmNodeDef) {
            if (!node.getType().equals((Object)NodeType.USERTASK) && !node.getType().equals((Object)NodeType.SIGNTASK) || node.getNodeId().equals(nodeId)) continue;
            BpmNodeDefVo vo = BpmNodeDefVo.parseVo(node);
            bpmExeStacksUserNode.add(vo);
            boolean isHavePre = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"pre", (List)relationList);
            boolean isHaveAfter = BpmStackRelationUtil.isHaveAndOrGateway((String)procInstId, (String)node.getNodeId(), (String)"after", (List)relationList);
            if (!isHavePre || !isHaveAfter) {
                bpmExeStacksGoMapUserNode.add(vo);
                continue;
            }
            List incomeNodes = node.getIncomeNodes();
            if (!BeanUtils.isNotEmpty((Object)incomeNodes)) continue;
            BpmNodeDef nodeDef = (BpmNodeDef)incomeNodes.get(0);
            if (!node.getType().equals((Object)NodeType.USERTASK) || !nodeDef.getType().equals((Object)NodeType.START) && !nodeDef.getType().equals((Object)NodeType.USERTASK)) continue;
            bpmExeStacksGoMapUserNode.add(vo);
        }
        return "direct".equals(rejectType) ? bpmExeStacksUserNode : bpmExeStacksGoMapUserNode;
    }

    private Map<String, String> convertVars(String varsJson) throws Exception {
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)varsJson)) {
            return varMap;
        }
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)varsJson);
        for (int i = 0; i < array.size(); ++i) {
            String varStr = array.get(i).toString();
            ObjectNode var = (ObjectNode)JsonUtil.toJsonNode((String)varStr);
            String name = var.get("name").asText();
            String value = var.get("val").asText();
            if (!StringUtil.isEmpty((String)name)) continue;
            throw new Exception("\u6d41\u7a0b\u53d8\u91cf\u7684\u53d8\u91cf\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return varMap;
    }

    @Override
    public List<BpmTaskOpinion> getHistoryOpinion(String procInstId, String taskId) throws Exception {
        if (StringUtil.isEmpty((String)procInstId) && StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":procInstId\u548ctaskId\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!");
        }
        if ((procInstId == null || procInstId.isEmpty()) && taskId != null) {
            BpmTask bpmTask = this.bpmTaskService.getByTaskId(taskId);
            if (BeanUtils.isEmpty((Object)bpmTask)) {
                throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
            }
            procInstId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        List list = this.bpmOpinionService.getTaskOpinions(procInstId);
        return list;
    }

    @Override
    public CommonResult<String> getBusinessKey(String procInstanceId, String taskId) throws NullPointerException {
        DefaultBpmProcessInstance instance;
        if (StringUtil.isEmpty((String)procInstanceId) && StringUtil.isNotEmpty((String)taskId)) {
            procInstanceId = this.bpmTaskService.getByTaskId(taskId).getProcInstId();
        }
        if (BeanUtils.isEmpty((Object)(instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstanceId))))) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u4fe1\u606f\u6ca1\u6709\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e\uff01");
        }
        return new CommonResult(true, "\u4e1a\u52a1\u4e3b\u952e--" + instance.getBizKey(), (Object)instance.getBizKey());
    }

    @Override
    public CommonResult<String> getProcInstId(String businessKey) throws NullPointerException {
        DefaultBpmProcessInstance instance = this.bpmProcessInstanceManager.getByBusinessKey(businessKey);
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new NullPointerException("\u6839\u636e\u8f93\u5165\u7684businessKey\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5b9e\u4f8b\u6570\u636e\uff01");
        }
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8bid--" + instance.getId(), (Object)instance.getId());
    }

    @Override
    @Transactional
    public CommonResult<String> doEndProcess(DoEndParamObject doEndParamObject) throws Exception {
        String taskId = doEndParamObject.getTaskId();
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        String endReason = doEndParamObject.getEndReason();
        if (StringUtil.isEmpty((String)endReason)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u7ec8\u6b62\u7406\u7531\u5fc5\u586b");
        }
        String messageType = StringUtil.isNotEmpty((String)doEndParamObject.getMessageType()) ? doEndParamObject.getMessageType() : "mail";
        String files = doEndParamObject.getFiles();
        if (BeanUtils.isEmpty((Object)this.bpmTaskManager.get((Serializable)((Object)taskId)))) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        this.bpmTaskManager.endProcessByTaskId(taskId, messageType, endReason, files, doEndParamObject.getBusDataObjectNode());
        return new CommonResult(true, "\u5df2\u7ec8\u6b62\u6d41\u7a0b", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> renewProcess(String instId, String reason) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u5b9e\u4f8bid\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)reason)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u7ec8\u6b62\u7406\u7531\u5fc5\u586b");
        }
        String messageType = "inner,mail";
        String topInstId = this.bpmCheckOpinionManager.getTopInstId(instId);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        instance.setStatus(ProcessInstanceStatus.STATUS_RUNNING.getKey());
        instance.setEndTime(LocalDateTime.now());
        instance.setDuration(Long.valueOf(TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)instance.getCreateTime())));
        this.bpmProcessInstanceManager.update((Model)instance);
        List litCheckOpinions = this.bpmCheckOpinionManager.getByInstId(instId);
        if (litCheckOpinions != null) {
            for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : litCheckOpinions) {
                if (!defaultBpmCheckOpinion.getStatus().equals(OpinionStatus.MANUAL_END.getKey())) continue;
                defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
                defaultBpmCheckOpinion.setCompleteTime(null);
                defaultBpmCheckOpinion.setAuditor(null);
                defaultBpmCheckOpinion.setAuditorName(null);
                defaultBpmCheckOpinion.setOrgId(null);
                defaultBpmCheckOpinion.setOrgPath(null);
                defaultBpmCheckOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
                defaultBpmCheckOpinion.setDurMs(null);
                defaultBpmCheckOpinion.setOpinion(null);
                this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
                NodeStatus nanualEndStatus = NodeStatus.PENDING;
                this.bpmProStatusManager.createOrUpd(instance.getId(), instance.getBpmnDefId(), defaultBpmCheckOpinion.getTaskKey(), defaultBpmCheckOpinion.getTaskName(), nanualEndStatus);
            }
        }
        BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(instId, reason, InterPoseType.RENEW_END, reason);
        BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
        manager.create((Model)bpmInterposeRecored);
        DefaultBpmProcessInstance processInstance = instId.equals(topInstId) ? instance : (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)topInstId));
        ArrayList<IUser> userList = new ArrayList<IUser>();
        if (topInstId != null) {
            IUser user = BpmUtil.getUser((String)processInstance.getCreateBy(), (String)processInstance.getCreator());
            userList.add(user);
        }
        Map<String, Object> vars = this.getVars((BpmProcessInstance)instance, reason);
        MessageUtil.sendMsg((String)"bpmRenewProcess", (String)messageType, userList, vars);
        return new CommonResult(true, "\u5df2\u6062\u590d\u7ec8\u6b62\u6d41\u7a0b", (Object)"");
    }

    private Map<String, Object> getVars(BpmProcessInstance instance, String cause) {
        String baseUrl = PortalDataUtil.getPropertyByAlias((String)"baseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", BeanUtils.isNotEmpty((Object)user) ? user.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        map.put("taskSubject", instance.getSubject());
        map.put("instSubject", instance.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("cause", cause);
        map.put("instId", instance.getId());
        return map;
    }

    @Override
    public List<String> getApprovalItems(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String defKey = bpmProcessInstance.getProcDefKey();
        String typeId = task.getTypeId();
        ArrayList<String> approvalItem = new ArrayList<String>();
        return approvalItem;
    }

    @Override
    public List<BpmIdentityResult> getNodeUsers(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String instanceId = bpmProcessInstance.getId();
        String nodeId = task.getNodeId();
        List opinionList = this.bpmOpinionService.getByInstNodeId(instanceId, nodeId);
        ArrayList<BpmIdentityResult> result = new ArrayList<BpmIdentityResult>();
        for (BpmTaskOpinion b : opinionList) {
            String qualfieds = b.getQualfieds();
            if (b.getCompleteTime() != null) continue;
            result.addAll(this.qualfields2BpmIdentityResult(qualfieds));
        }
        BeanUtils.removeDuplicate(result);
        return result;
    }

    private List<BpmIdentityResult> qualfields2BpmIdentityResult(String qualfieds) throws Exception {
        ArrayList<BpmIdentityResult> result = new ArrayList<BpmIdentityResult>();
        if (StringUtil.isEmpty((String)qualfieds)) {
            return result;
        }
        JsonNode parse = JsonUtil.toJsonNode((String)qualfieds);
        if (BeanUtils.isNotEmpty((Object)parse) && parse.isArray()) {
            ArrayNode ArrayNode2 = (ArrayNode)parse;
            for (JsonNode jsonNode : ArrayNode2) {
                String id;
                if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) continue;
                ObjectNode jobject = (ObjectNode)jsonNode;
                JsonNode typeObj = jobject.get("type");
                if (!BeanUtils.isNotEmpty((Object)jobject.get("type")) || !jobject.get("type").isTextual() || !"user".equals(jobject.get("type").asText()) || !BeanUtils.isNotEmpty((Object)(id = jobject.get("id").asText()))) continue;
                IUser user = ServiceUtil.getUserById((String)id);
                result.add(new BpmIdentityResult(user));
            }
        }
        return result;
    }

    @Override
    public List<BpmCheckOpinionVo> getProcessOpinionByActInstId(String actTaskId) throws Exception {
        if (StringUtil.isEmpty((String)actTaskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":actTaskId\u5fc5\u586b\uff01");
        }
        DefaultBpmProcessInstance process = this.bpmProcessInstanceManager.getByBpmnInstId(actTaskId);
        if (BeanUtils.isEmpty((Object)process)) {
            throw new RuntimeException("\u6839\u636esctTaskId\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff01");
        }
        List bpmCheckOpinionList = this.bpmCheckOpinionManager.getByInstId(process.getId());
        ArrayList<BpmCheckOpinionVo> checkOpinionVoList = new ArrayList<BpmCheckOpinionVo>();
        for (DefaultBpmCheckOpinion o : bpmCheckOpinionList) {
            o.setQualfieds("");
            JsonNode object = JsonUtil.toJsonNode((Object)o);
            BpmCheckOpinionVo b = (BpmCheckOpinionVo)JsonUtil.toBean((JsonNode)object, BpmCheckOpinionVo.class);
            checkOpinionVoList.add(b);
        }
        return checkOpinionVoList;
    }

    @Override
    public BpmProcessInstance getProcessRunByTaskId(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        return bpmProcessInstance;
    }

    @Override
    public String getStatusByRunidNodeId(String instId, String nodeId) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u6d41\u7a0b\u5b9e\u4f8bid\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)nodeId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1anodeId\u5bf9\u5e94\u8282\u70b9id\u5fc5\u586b\uff01");
        }
        DefaultBpmProStatus proStatus = this.bpmProStatusManager.getByInstNodeId(instId, nodeId);
        if (BeanUtils.isEmpty((Object)proStatus)) {
            throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u8be5\u5b9e\u4f8b\u8be5\u8282\u70b9\u7684\u72b6\u6001\uff01");
        }
        String status = "";
        if (NodeStatus.SUBMIT.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SUBMIT.getValue();
        }
        if (NodeStatus.RE_SUBMIT.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RE_SUBMIT.getValue();
        }
        if (NodeStatus.AGREE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.AGREE.getValue();
        }
        if (NodeStatus.PENDING.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.PENDING.getValue();
        }
        if (NodeStatus.OPPOSE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.OPPOSE.getValue();
        }
        if (NodeStatus.BACK.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.BACK.getValue();
        }
        if (NodeStatus.BACK_TO_START.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.BACK_TO_START.getValue();
        }
        if (NodeStatus.COMPLETE.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.COMPLETE.getValue();
        }
        if (NodeStatus.RECOVER.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RECOVER.getValue();
        }
        if (NodeStatus.RECOVER_TO_START.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.RECOVER_TO_START.getValue();
        }
        if (NodeStatus.SIGN_PASS.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SIGN_PASS.getValue();
        }
        if (NodeStatus.SIGN_NO_PASS.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SIGN_NO_PASS.getValue();
        }
        if (NodeStatus.MANUAL_END.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.MANUAL_END.getValue();
        }
        if (NodeStatus.ABANDON.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.ABANDON.getValue();
        }
        if (NodeStatus.SUSPEND.getKey().equals(proStatus.getStatus())) {
            status = proStatus.getStatus() + "\u2014\u2014" + NodeStatus.SUSPEND.getValue();
        }
        return status;
    }

    @Override
    public BpmTaskResult getTaskByTaskId(String taskId) throws Exception {
        if (StringUtil.isEmpty((String)taskId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u4efb\u52a1id\u5fc5\u586b");
        }
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        return new BpmTaskResult(task);
    }

    @Override
    public String getTaskNameByTaskId(String taskId) throws Exception {
        BpmTaskResult taskByTaskId = this.getTaskByTaskId(taskId);
        return taskByTaskId.getTaskName();
    }

    @Override
    public DefaultBpmProcessInstance getInstancetByBusinessKey(String businessKey) throws Exception {
        if (StringUtil.isEmpty((String)businessKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1abusinessKey\u5fc5\u586b");
        }
        DefaultBpmProcessInstance instance = this.bpmProcessInstanceManager.getByBusinessKey(businessKey);
        if (BeanUtils.isEmpty((Object)instance) && BeanUtils.isEmpty((Object)(instance = this.getInstanceFromBusLink(businessKey, null)))) {
            throw new RuntimeException("\u6839\u636e\u3010" + businessKey + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        return instance;
    }

    @Override
    public DefaultBpmProcessInstance getInstancetByBizKeySysCode(String businessKey, String sysCode) throws Exception {
        if (StringUtil.isEmpty((String)businessKey)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1abusinessKey\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)sysCode)) {
            return this.getInstancetByBusinessKey(businessKey);
        }
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.withParam("biz_key_", (Object)businessKey);
        queryFilter.withParam("sys_code_", (Object)sysCode);
        PageList pageList = this.bpmProcessInstanceManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)pageList) || pageList.getRows().size() == 0) {
            DefaultBpmProcessInstance processInstance = this.getInstanceFromBusLink(businessKey, sysCode);
            if (BeanUtils.isEmpty((Object)processInstance)) {
                throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
            }
            return processInstance;
        }
        if (pageList.getRows().size() > 1) {
            throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u627e\u5230\u4e86\u591a\uff08" + pageList.getTotal() + "\uff09\u6761\u5bf9\u5e94\u7684\u6570\u636e");
        }
        return (DefaultBpmProcessInstance)pageList.getRows().get(0);
    }

    private DefaultBpmProcessInstance getInstanceFromBusLink(String businessKey, String sysCode) {
        DefaultBpmProcessInstance processInstance = null;
        if (StringUtil.isNotEmpty((String)businessKey)) {
            PageList pageList;
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            queryFilter.withParam("businesskey_str_", (Object)businessKey);
            if (StringUtil.isNotEmpty((String)sysCode)) {
                queryFilter.withParam("sys_code_", (Object)sysCode);
            }
            if (BeanUtils.isEmpty((Object)(pageList = this.bpmBusLinkManager.query(queryFilter)).getRows()) && StringValidator.isNumberic((String)businessKey)) {
                QueryFilter queryFilter2 = QueryFilter.build().withDefaultPage();
                queryFilter2.withParam("businesskey_", (Object)businessKey);
                if (StringUtil.isNotEmpty((String)sysCode)) {
                    queryFilter2.withParam("sys_code_", (Object)sysCode);
                }
                pageList = this.bpmBusLinkManager.query(queryFilter2);
            }
            if (BeanUtils.isNotEmpty((Object)pageList.getRows())) {
                ArrayList<Object> proInsts = new ArrayList<Object>();
                for (BpmBusLink bpmBusLink : pageList.getRows()) {
                    DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmBusLink.getProcInstId()));
                    if (!BeanUtils.isNotEmpty((Object)instance)) continue;
                    proInsts.add(instance);
                }
                HashSet h = new HashSet(proInsts);
                proInsts.clear();
                proInsts.addAll(h);
                if (proInsts.size() > 1) {
                    throw new RuntimeException("\u6839\u636ebusinessKey\u3010" + businessKey + "\u3011\u3001sysCode\u3010" + sysCode + "\u3011\u627e\u5230\u4e86\u591a\uff08" + proInsts.size() + "\uff09\u6761\u5bf9\u5e94\u7684\u6570\u636e");
                }
                if (BeanUtils.isNotEmpty(proInsts)) {
                    processInstance = (DefaultBpmProcessInstance)proInsts.get(0);
                }
            }
        }
        return processInstance;
    }

    public DefaultBpmProcessInstance getInstanceByInstId(String instId) throws Exception {
        BpmFormService bpmFormService;
        FormModel formModel;
        int showModifyRecord;
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u6d41\u7a0b\u5b9e\u4f8bid\u5fc5\u586b");
        }
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new RuntimeException("\u6839\u636e\u3010" + instId + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e");
        }
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(instance.getProcDefId());
        if (BeanUtils.isNotEmpty((Object)bpmDefinition) && (showModifyRecord = bpmDefinition.getShowModifyRecord()) == 1) {
            instance.setShowModifyRecord(true);
        }
        if (BeanUtils.isNotEmpty((Object)(formModel = (bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC)).getByDefId(instance.getProcDefId(), "", (BpmProcessInstance)instance, true)))) {
            instance.setBpmFormKey(formModel.getFormKey());
        }
        return instance;
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getInstanceListByXml(String xml) throws Exception {
        IUser user;
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String account = root.attributeValue("account");
        String subject = root.attributeValue("subject");
        String status = root.attributeValue("status");
        String pageSize = root.attributeValue("pageSize");
        String currentPage = root.attributeValue("currentPage");
        if (StringUtil.isNotEmpty((String)account) && BeanUtils.isEmpty((Object)(user = ServiceUtil.getUserByAccount((String)account)))) {
            throw new RuntimeException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        ContextUtil.setCurrentUserByAccount((String)account);
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        PageBean page = new PageBean(Integer.valueOf(1), Integer.valueOf(20));
        if (StringUtil.isNotEmpty((String)pageSize)) {
            page.setPageSize(Integer.valueOf(pageSize).intValue());
        }
        if (StringUtil.isNotEmpty((String)currentPage)) {
            page.setPage(new Integer(currentPage).intValue());
        }
        queryFilter.setPageBean(page);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.withQuery(new QueryField("status_", (Object)status));
        }
        if (StringUtil.isNotEmpty((String)subject)) {
            queryFilter.withQuery(new QueryField("subject_", (Object)subject, QueryOP.LIKE));
        }
        PageList list = (PageList)this.bpmProcessInstanceManager.queryList(queryFilter);
        return list;
    }

    @Override
    public PageList<DefaultBpmTask> getTasksByInstId(String instId) throws Exception {
        if (StringUtil.isEmpty((String)instId)) {
            throw new RequiredException(ResponseErrorEnums.REQUIRED_ERROR.getMessage() + "\uff1ainstId\u5b9e\u4f8bid\u5fc5\u586b\uff01");
        }
        PageList taskList = new PageList();
        taskList.setRows(this.bpmTaskManager.getByInstId(instId));
        return taskList;
    }

    @Override
    public List<BpmNodeDefVo> getTaskOutNodes(String taskId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        String defId = bpmProcessInstance.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef taskNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List nodes = taskNodeDef.getOutcomeNodes();
        List<BpmNodeDef> nextNodes = this.handlerSelectOutcomeNodes(nodes);
        ArrayList<BpmNodeDefVo> array = new ArrayList<BpmNodeDefVo>();
        for (BpmNodeDef n : nextNodes) {
            BpmNodeDefVo nodeDefVo = BpmNodeDefVo.parseVo(n);
            array.add(nodeDefVo);
        }
        return array;
    }

    private List<BpmNodeDef> handlerSelectOutcomeNodes(List<BpmNodeDef> outcomeNodes) {
        BpmNodeDef bpmNodeDef;
        NodeType nodeType;
        int size = outcomeNodes.size();
        List<Object> returnList = new ArrayList<BpmNodeDef>();
        if (size == 1 && (NodeType.EXCLUSIVEGATEWAY.equals((Object)(nodeType = (bpmNodeDef = outcomeNodes.get(0)).getType())) || NodeType.INCLUSIVEGATEWAY.equals((Object)nodeType) || NodeType.PARALLELGATEWAY.equals((Object)nodeType))) {
            returnList = bpmNodeDef.getOutcomeNodes();
        }
        if (BeanUtils.isEmpty(returnList)) {
            return outcomeNodes;
        }
        return returnList;
    }

    @Override
    public String getDetailUrl(String taskId) throws Exception {
        ApplicationContext applicationContext = AppUtil.getApplicaitonContext();
        String applicationName = applicationContext.getApplicationName();
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5904\u7406\uff01");
        }
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(task.getProcInstId());
        if (!"bo".equals(bpmProcessInstance.getDataMode())) {
            throw new RuntimeException("\u8be5\u4efb\u52a1\u5bf9\u5e94\u7684\u8282\u70b9\u4e0d\u662f\u5728\u7ebf\u8868\u5355\uff01");
        }
        String url = applicationName + "/flow/instance/instanceFlowForm?id=" + bpmProcessInstance.getId();
        return url;
    }

    @Override
    @Transactional
    public CommonResult<String> setTaskVar(String taskId, Map<String, Object> variables) throws Exception {
        this.natTaskService.setVariables(taskId, variables);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setTaskVarLocal(String taskId, Map<String, Object> variables) throws Exception {
        this.natTaskService.setVariablesLocal(taskId, variables);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> forbiddenInstance(String instId) throws Exception {
        this.processInstanceService.suspendProcessInstance(instId);
        this.taskReminderManager.forbiddenTaskReminder(instId);
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> unForbiddenInstance(String instId) throws Exception {
        this.processInstanceService.recoverProcessInstance(instId);
        this.taskReminderManager.allowTaskReminder(instId);
        return new CommonResult(true, "\u6d41\u7a0b\u5b9e\u4f8b\u53d6\u6d88\u6302\u8d77\u6210\u529f", (Object)"");
    }

    @Override
    public List<BpmProcessInstance> getBpmProcessByParentIdAndSuperNodeId(String parentInstId, String superNodeId) throws Exception {
        return this.bpmProcessInstanceManager.getBpmProcessByParentIdAndSuperNodeId(parentInstId, superNodeId);
    }

    @Override
    public List<DefaultBpmProcessInstance> getInstancesByParentId(String parentInstId, String status) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.withParam("parent_inst_id_", (Object)parentInstId);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.withParam("status_", (Object)status);
        }
        return this.bpmProcessInstanceManager.queryList(queryFilter);
    }

    @Override
    public List<DefaultBpmProcessInstance> getInstancesByDefId(String defId, String status) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.withParam("proc_def_id_", (Object)defId);
        if (StringUtil.isNotEmpty((String)status)) {
            queryFilter.withParam("status_", (Object)status);
        }
        return this.bpmProcessInstanceManager.queryList(queryFilter);
    }

    @Override
    public BpmProcessInstance getTopBpmProcessInstance(String instId) throws Exception {
        return this.bpmProcessInstanceManager.getTopBpmProcessInstance(instId);
    }

    @Override
    public String getBpmImage(BpmImageParamObject bpmImageParamObject) throws Exception {
        BpmProcessInstance instance;
        DiagramService diagramService = (DiagramService)AppUtil.getBean((String)"diagramService");
        BpmInstService instService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
        InputStream is = null;
        if (StringUtil.isNotEmpty((String)bpmImageParamObject.getProcInstId()) && BeanUtils.isNotEmpty((Object)(instance = instService.getProcessInstance(bpmImageParamObject.getProcInstId()))) && ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance.getStatus())) {
            bpmImageParamObject.setDefId(instance.getProcDefId());
        }
        if (StringUtils.isNotEmpty((String)bpmImageParamObject.getDefId())) {
            is = diagramService.getDiagramByBpmnDefId(bpmImageParamObject.getDefId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getBpmnInstId())) {
            is = this.getDiagramByInstance(diagramService, bpmImageParamObject.getBpmnInstId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getTaskId())) {
            BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean((String)"defaultBpmTaskService");
            BpmTask bpmTask = bpmTaskService.getByTaskId(bpmImageParamObject.getTaskId());
            is = this.getDiagramByInstance(diagramService, bpmTask.getBpmnInstId());
        } else if (StringUtils.isNotEmpty((String)bpmImageParamObject.getProcInstId())) {
            instance = instService.getProcessInstance(bpmImageParamObject.getProcInstId());
            is = this.getDiagramByInstance(diagramService, instance.getBpmnInstId());
        }
        if (is == null) {
            return "";
        }
        byte[] data = null;
        try {
            data = new byte[is.available()];
            is.read(data);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "data:image/png;base64," + new String(Base64.encodeBase64((byte[])data));
    }

    private InputStream getDiagramByInstance(DiagramService diagramService, String bpmnInstId) {
        BpmInstService bpmInstService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessInstance bpmProcessInstance = bpmInstService.getProcessInstanceByBpmnInstId(bpmnInstId);
        if (bpmProcessInstance == null) {
            bpmProcessInstance = bpmProcessInstanceManager.getBpmProcessInstanceHistoryByBpmnInstId(bpmnInstId);
        }
        Map colorMap = this.bpmProStatusManager.getProcessInstanceStatus(bpmProcessInstance.getId());
        return diagramService.getDiagramByDefId(bpmProcessInstance.getProcDefId(), colorMap);
    }

    @Override
    public CommonResult<String> setDefOtherParam(DefOtherParam defOtherParam) throws Exception {
        return null;
    }

    @Override
    @Transactional
    public CommonResult<String> doNextcommu(DoNextParamObject doNextParamObject) throws Exception {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)doNextParamObject.getTaskId()));
        if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
            return new CommonResult(false, "\u8be5\u6c9f\u901a\u5df2\u53cd\u9988");
        }
        String opinion = doNextParamObject.getOpinion();
        this.updOpinionComplete(doNextParamObject.getInstId(), doNextParamObject.getTaskId(), OpinionStatus.FEEDBACK, ContextUtil.getCurrentUserId(), opinion, doNextParamObject.getFiles(), doNextParamObject.getZfiles());
        noticeManager.removeByIds(new String[]{bpmTaskNotice.getId()});
        return new CommonResult(true, "\u53cd\u9988\u6210\u529f");
    }

    private void updOpinionComplete(String instId, String noticeId, OpinionStatus opinionStatus, String commuUser, String opinion, String files, String zFiles) {
        IUser user = this.userServiceImpl.getUserById(commuUser);
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTeam(instId, noticeId, OpinionStatus.AWAITING_FEEDBACK, user.getFullname());
        checkOpinion.setFiles(files);
        checkOpinion.setZfiles(zFiles);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
        checkOpinion.setDurMs(Long.valueOf(durMs));
        checkOpinion.setAuditor(user.getUserId());
        checkOpinion.setAuditorName(user.getFullname());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setOpinion(opinion);
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    @Override
    public Map<String, Object> getUrgentStateConf(ObjectNode obj) throws Exception {
        BpmNodeDef bpmNodeDef;
        DefaultBpmProcessInstance instance;
        DefaultBpmProcessInstance instance2;
        String defId = obj.hasNonNull("defId") ? obj.get("defId").asText() : "";
        String taskId = obj.hasNonNull("taskId") ? obj.get("taskId").asText() : "";
        String instId = obj.hasNonNull("instId") ? obj.get("instId").asText() : "";
        boolean getConf = obj.hasNonNull("getConf") ? obj.get("getConf").asBoolean() : false;
        String nodeId = "";
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)taskId)) {
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)obj.get("taskId").asText()));
            if (BeanUtils.isNotEmpty((Object)defaultBpmTask)) {
                nodeId = defaultBpmTask.getNodeId();
                instId = defaultBpmTask.getProcInstId();
                defId = defaultBpmTask.getProcDefId();
            }
        } else if (StringUtil.isNotEmpty((String)instId) && BeanUtils.isNotEmpty((Object)(instance2 = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId))))) {
            defId = instance2.getProcDefId();
            result.put("value", instance2.getUrgentState());
            if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance2.getStatus())) {
                result.put("right", "w");
            }
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if ((BeanUtils.isEmpty((Object)defaultBpmDefinition) || defaultBpmDefinition.getShowUrgentState() == 0) && !getConf) {
            return result;
        }
        PropertyService propertyService = (PropertyService)AppUtil.getBean(PropertyService.class);
        String byAlias = propertyService.getProperty("urgentStateConf", "");
        result.put("conf", byAlias);
        if (getConf) {
            return result;
        }
        if (!result.containsKey("value") && BeanUtils.isNotEmpty((Object)(instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId))))) {
            result.put("value", instance.getUrgentState());
            if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(instance.getStatus())) {
                result.put("right", "w");
            }
        }
        if (StringUtil.isNotEmpty((String)nodeId) && BeanUtils.isNotEmpty((Object)(bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId))) && bpmNodeDef.getNodeProperties().size() > 0 && ((NodeProperties)bpmNodeDef.getNodeProperties().get(0)).isAllowEditUrgentState()) {
            result.put("right", "w");
        }
        if (!result.containsKey("value")) {
            result.put("right", "w");
        }
        return result;
    }

    @Override
    @Transactional
    public CommonResult<String> doNextCopyto(DoNextParamObject doNextParamObject) throws Exception {
        IUser user = this.userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmProcessInstance def = (DefaultBpmProcessInstance)this.bpmProcessInstanceMapper.get((Serializable)((Object)doNextParamObject.getInstId()));
        String bpmnInstId = def.getBpmnInstId();
        String superInstId = "";
        if (!OpinionStatus.END.getKey().equals(def.getStatus())) {
            superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        }
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(def.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(doNextParamObject.getInstId());
        checkOpinion.setTaskId("");
        checkOpinion.setTaskKey("");
        checkOpinion.setTaskName("\u4f20\u9605\u4efb\u52a1");
        checkOpinion.setFiles(doNextParamObject.getFiles());
        checkOpinion.setZfiles(doNextParamObject.getZfiles());
        checkOpinion.setStatus(OpinionStatus.COPYTO_REPLY.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        checkOpinion.setOpinion(doNextParamObject.getOpinion());
        checkOpinion.setCompleteTime(LocalDateTime.now());
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
        checkOpinion.setDurMs(Long.valueOf(durMs));
        checkOpinion.setAuditor(user.getUserId());
        checkOpinion.setAuditorName(user.getFullname());
        checkOpinion.setIsRead(Integer.valueOf(1));
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
        return new CommonResult(true, "\u56de\u590d\u6210\u529f");
    }
}

