/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataAccess.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.dataAccess.dao.DataAccessDefinedDao;
import com.artfess.dataAccess.manager.DataAccessControlManager;
import com.artfess.dataAccess.model.DataAccessControl;
import com.artfess.dataAccess.params.DataAccessControlVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6570\u636e\u6743\u9650\u6388\u6743"})
@ApiGroup(group={"group_uc"})
@RequestMapping(value={"/uc/DataAccessControl/v1/"})
public class DataAccessControlController
extends BaseController<DataAccessControlManager, DataAccessControl> {
    @Resource
    DataAccessControlManager DataAccessControlManager;
    @Resource
    DataAccessDefinedDao dao;

    @GetMapping(value={"queryListDataAccessDefined"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u6743\u9650id\u67e5\u8be2\u6743\u9650\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u6570\u636e\u6743\u9650id\u67e5\u8be2\u6743\u9650\u5217\u8868")
    @PowerLogInfo(logType=LogType.AUDIT, operaionType=OperationType.QUERY, description="\u6839\u636e\u6570\u636e\u6743\u9650id\u67e5\u8be2\u6743\u9650\u5217\u8868")
    public DataAccessControlVo queryListDataAccessDefined(@ApiParam(name="accessControlId", value="\u6570\u636e\u6743\u9650id", required=true) @RequestParam String accessControlId) throws Exception {
        List<DataAccessControl> list = this.DataAccessControlManager.queryListDataAccessDefined(accessControlId);
        if (list.size() < 0) {
            return null;
        }
        DataAccessControlVo vo = new DataAccessControlVo();
        String orgList = "";
        String persoinList = "";
        String roleList = "";
        for (int i = 0; i < list.size(); ++i) {
            Integer type = list.get(i).getAccessControlType();
            if (type == 2) {
                if (i < list.size() - 1) {
                    orgList = orgList + list.get(i).getAccessControlId() + ",";
                    continue;
                }
                orgList = orgList + list.get(i).getAccessControlId();
                continue;
            }
            if (type == 3) {
                if (i < list.size() - 1) {
                    persoinList = persoinList + list.get(i).getAccessControlId() + ",";
                    continue;
                }
                persoinList = persoinList + list.get(i).getAccessControlId();
                continue;
            }
            if (type != 4) continue;
            roleList = i < list.size() - 1 ? roleList + list.get(i).getAccessControlId() + "," : roleList + list.get(i).getAccessControlId();
        }
        if (orgList.length() > 0) {
            String[] split = orgList.split(",");
            List<String> orgNameList = this.dao.queryRangNameByOrg(Arrays.asList(split));
            vo.setOrgNameList(StringUtils.strip((String)orgNameList.toString(), (String)"[]"));
        }
        if (persoinList.length() > 0) {
            String[] split2 = persoinList.split(",");
            List<String> persoinNameList = this.dao.queryRangNameByUser(Arrays.asList(split2));
            vo.setPersonNameList(StringUtils.strip((String)persoinNameList.toString(), (String)"[]"));
        }
        if (roleList.length() > 0) {
            String[] split3 = roleList.split(",");
            List<String> roleNameList = this.dao.queryRangNameByRole(Arrays.asList(split3));
            vo.setRoleNameList(StringUtils.strip((String)roleNameList.toString(), (String)"[]"));
        }
        if (list.get(0).getAccessControlType() == 2) {
            vo.setAccessControlType(2);
        } else {
            vo.setAccessControlType(1);
        }
        vo.setAccessDefinedId(accessControlId);
        vo.setOrgList(orgList);
        vo.setPersonList(persoinList);
        vo.setRoleList(roleList);
        return vo;
    }

    @PostMapping(value={"saveDataAccessDefined"})
    @ApiOperation(value="\u65b0\u589e\u3001\u66f4\u65b0\u6570\u636e\u6388\u6743", httpMethod="POST", notes="\u65b0\u589e\u3001\u66f4\u65b0\u6570\u636e\u6388\u6743")
    @PowerLogInfo(logType=LogType.PERMISSION, operaionType=OperationType.UPDATE, description="\u65b0\u589e\u3001\u66f4\u65b0\u6570\u636e\u6388\u6743")
    public CommonResult<String> saveDataAccessDefined(@ApiParam(name="DataAccessControlVo", value="\u6388\u6743\u5bf9\u8c61", required=true) @RequestBody DataAccessControlVo DataAccessControlVo2) throws Exception {
        Integer accessControlType = DataAccessControlVo2.getAccessControlType();
        ArrayList<DataAccessControl> list = new ArrayList<DataAccessControl>();
        String definedId = DataAccessControlVo2.getAccessDefinedId();
        if (1 == accessControlType) {
            DataAccessControl DataAccessControl2 = new DataAccessControl();
            DataAccessControl2.setAccessControlType(1);
            DataAccessControl2.setAccessDefinedId(definedId);
            list.add(DataAccessControl2);
        } else {
            DataAccessControl DataAccessControl3;
            String[] split;
            if (StringUtils.isNotEmpty((String)DataAccessControlVo2.getOrgList())) {
                String orgList = DataAccessControlVo2.getOrgList();
                for (String orgId : split = orgList.split(",")) {
                    DataAccessControl3 = new DataAccessControl();
                    DataAccessControl3.setAccessControlType(2);
                    DataAccessControl3.setAccessControlId(orgId);
                    DataAccessControl3.setAccessDefinedId(definedId);
                    list.add(DataAccessControl3);
                }
            }
            if (StringUtils.isNotEmpty((String)DataAccessControlVo2.getPersonList())) {
                String personList = DataAccessControlVo2.getPersonList();
                for (String personId : split = personList.split(",")) {
                    DataAccessControl3 = new DataAccessControl();
                    DataAccessControl3.setAccessControlType(3);
                    DataAccessControl3.setAccessControlId(personId);
                    DataAccessControl3.setAccessDefinedId(definedId);
                    list.add(DataAccessControl3);
                }
            }
            if (StringUtils.isNotEmpty((String)DataAccessControlVo2.getRoleList())) {
                String roleList = DataAccessControlVo2.getRoleList();
                for (String roleId : split = roleList.split(",")) {
                    DataAccessControl3 = new DataAccessControl();
                    DataAccessControl3.setAccessControlType(4);
                    DataAccessControl3.setAccessControlId(roleId);
                    DataAccessControl3.setAccessDefinedId(definedId);
                    list.add(DataAccessControl3);
                }
            }
        }
        String msg = this.DataAccessControlManager.saveDataAccessDefined(list);
        return new CommonResult(msg);
    }
}

