/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.service.impl;

import com.artfess.base.service.LoginUserService;
import com.artfess.base.util.IPUtils;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Primary
@Service
public class LoginUserServiceImpl
implements LoginUserService {
    protected static Logger logger = LoggerFactory.getLogger(LoginUserServiceImpl.class);
    @Resource
    UserManager userManager;

    @Transactional
    public void lockedUser(String account, int lockedStatus) {
        try {
            User user = this.userManager.getByAccount(account);
            user.setLockedStatus(lockedStatus);
            if (lockedStatus == 2) {
                user.setLockedTime(LocalDateTime.now());
            } else {
                user.setLockedTime(null);
            }
            this.userManager.update((Model)user);
        }
        catch (Exception e) {
            logger.error("\u9501\u5b9a\u7528\u6237\u8d26\u53f7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void updateLastLoginTime(String account) {
        try {
            User user = this.userManager.getByAccount(account);
            user.setLastLoginTime(LocalDateTime.now());
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            user.setIP(IPUtils.getIpAddr((HttpServletRequest)request));
            this.userManager.update((Model)user);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6700\u540e\u767b\u5f55\u65f6\u95f4\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void updateUserIp() {
        try {
            this.userManager.updateUserIP();
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u7528\u6237\u767b\u5f55\u673a\u5668IP\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

