/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.validgroup.UpdateGroup;
import com.artfess.portal.kh.manager.KhResultManager;
import com.artfess.portal.kh.manager.KhSchemePlanManager;
import com.artfess.portal.kh.model.KhSchemePlan;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7ee9\u6548\u8003\u6838-\u8003\u6838\u8ba1\u5212\u4fe1\u606f"})
@RequestMapping(value={"/kh/scheme/plan/"})
@ApiGroup(group={"group_system"})
public class KhSchemePlanController
extends BaseController<KhSchemePlanManager, KhSchemePlan> {
    private static final Logger log = LoggerFactory.getLogger(KhSchemePlanController.class);
    @Autowired
    private KhResultManager resultManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) KhSchemePlan t) {
        boolean result = ((KhSchemePlanManager)this.baseService).createInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) KhSchemePlan t) {
        boolean result = ((KhSchemePlanManager)this.baseService).updateInfo(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public KhSchemePlan getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((KhSchemePlanManager)this.baseService).findById(id);
    }

    @GetMapping(value={"/executePlan"})
    @ApiOperation(value="\u6267\u884c\u8ba1\u5212")
    public CommonResult<String> executePlan(String ... ids) {
        Assert.notNull((Object)ids, (String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u8ba1\u5212\uff01");
        boolean result = ((KhSchemePlanManager)this.baseService).updateStatus(Arrays.asList(ids), "execute");
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u8ba1\u5212\u5931\u8d25");
        }
        result = this.resultManager.createResult(Arrays.asList(ids).get(0));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u8ba1\u5212\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/pausePlan"})
    @ApiOperation(value="\u6682\u505c\u8ba1\u5212")
    public CommonResult<String> pausePlan(String ... ids) {
        boolean result = ((KhSchemePlanManager)this.baseService).updateStatus(Arrays.asList(ids), "stop");
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6682\u505c\u8ba1\u5212\u5931\u8d25");
        }
        return new CommonResult();
    }

    @GetMapping(value={"/endPlan"})
    @ApiOperation(value="\u7ed3\u675f\u8ba1\u5212")
    public CommonResult<String> endPlan(String ... ids) {
        boolean result = ((KhSchemePlanManager)this.baseService).updateStatus(Arrays.asList(ids), "end");
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u7ed3\u675f\u8ba1\u5212\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<KhSchemePlan> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<KhSchemePlan> queryFilter) {
        PageList query = ((KhSchemePlanManager)this.baseService).query(queryFilter);
        query.getRows().forEach(plan -> {
            if (plan.getEndDate().isBefore(LocalDate.now())) {
                plan.setStatus("end");
            }
        });
        return query;
    }
}

