/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.util.jvm;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Properties;

public class JVMInfoUtils {
    private static RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
    private static ClassLoadingMXBean classLoad = ManagementFactory.getClassLoadingMXBean();
    private static CompilationMXBean compilation = ManagementFactory.getCompilationMXBean();
    private static Properties properties = System.getProperties();

    public static String getPID() {
        String name;
        String pid = System.getProperty("pid");
        if (pid == null && (name = runtime.getName()) != null) {
            pid = name.split("@")[0];
            System.setProperty("pid", pid);
        }
        return pid;
    }

    public static String getJVMSpecName() {
        return runtime.getSpecName();
    }

    public static String getJVMSpecVendor() {
        return runtime.getSpecVendor();
    }

    public static String getJVMSpecVersion() {
        return runtime.getSpecVersion();
    }

    public static String getJVMName() {
        return runtime.getVmName();
    }

    public static String getJavaVersion() {
        return JVMInfoUtils.getSystemProperty("java.version");
    }

    public static String getJVMVendor() {
        return runtime.getVmVendor();
    }

    public static String getJVMVersion() {
        return runtime.getVmVersion();
    }

    public static long getJVMStartTimeMs() {
        return runtime.getStartTime();
    }

    public static long getJVMUpTimeMs() {
        return runtime.getUptime();
    }

    public static long getJVMLoadedClassCount() {
        return classLoad.getLoadedClassCount();
    }

    public static long getJVMUnLoadedClassCount() {
        return classLoad.getUnloadedClassCount();
    }

    public static long getJVMTotalLoadedClassCount() {
        return classLoad.getTotalLoadedClassCount();
    }

    public static String getJITName() {
        return null == compilation ? "" : compilation.getName();
    }

    public static long getJITTimeMs() {
        if (null != compilation && compilation.isCompilationTimeMonitoringSupported()) {
            return compilation.getTotalCompilationTime();
        }
        return -1L;
    }

    public static String getSystemProperty(String key) {
        return properties.getProperty(key);
    }

    public static Properties getSystemProperty() {
        return properties;
    }
}

