/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.SysLayoutSetting;
import com.artfess.portal.persistence.manager.SysLayoutSettingManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/sysLayoutSetting/sysLayoutSetting/v1/"})
@Api(tags={"\u95e8\u6237\u5e03\u5c40\u8bbe\u7f6e"})
@ApiGroup(group={"group_system"})
public class SysLayoutSettingController
extends BaseController<SysLayoutSettingManager, SysLayoutSetting> {
    @Resource
    SysLayoutSettingManager sysLayoutSettingManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e03\u5c40\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u5e03\u5c40\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysLayoutSetting> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysLayoutSetting> queryFilter) throws Exception {
        return this.sysLayoutSettingManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e03\u5c40\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u5e03\u5c40\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysLayoutSetting getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysLayoutSetting();
        }
        SysLayoutSetting sysLayoutSetting = (SysLayoutSetting)this.sysLayoutSettingManager.get((Serializable)((Object)id));
        return sysLayoutSetting;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e03\u5c40\u8bbe\u7f6e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e03\u5c40\u8bbe\u7f6e\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysLayoutSetting", value="\u5e03\u5c40\u8bbe\u7f6e") @RequestBody SysLayoutSetting sysLayoutSetting) throws Exception {
        String resultMsg = null;
        try {
            SysLayoutSetting setting = this.sysLayoutSettingManager.getByLayoutId(sysLayoutSetting.getLayoutId());
            if (setting == null) {
                sysLayoutSetting.setId(UniqueIdUtil.getSuid());
                this.sysLayoutSettingManager.create((Model)sysLayoutSetting);
                resultMsg = "\u6dfb\u52a0\u5e03\u5c40\u8bbe\u7f6e\u6210\u529f";
            } else {
                BeanUtils.copyNotNullProperties((Object)((Object)setting), (Object)((Object)sysLayoutSetting));
                this.sysLayoutSettingManager.update((Model)setting);
                resultMsg = "\u66f4\u65b0\u5e03\u5c40\u8bbe\u7f6e\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u5e03\u5c40\u8bbe\u7f6e\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg, (Object)e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e03\u5c40\u8bbe\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5e03\u5c40\u8bbe\u7f6e\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.sysLayoutSettingManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u5e03\u5c40\u8bbe\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5e03\u5c40\u8bbe\u7f6e\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getByLayout"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e03\u5c40\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u5e03\u5c40\u8be6\u60c5")
    @ResponseBody
    public SysLayoutSetting getByLayout(@ApiParam(name="layoutId", value="\u5e03\u5c40id", required=true) @RequestParam String layoutId) throws Exception {
        if (StringUtil.isEmpty((String)layoutId)) {
            return new SysLayoutSetting();
        }
        SysLayoutSetting sysLayoutSetting = this.sysLayoutSettingManager.getByLayoutId(layoutId);
        return sysLayoutSetting;
    }
}

