/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.PortalNewsNotice;
import com.artfess.portal.model.PortalNewsTree;
import com.artfess.portal.persistence.dao.PortalNewsNoticeDao;
import com.artfess.portal.persistence.manager.PortalNewsNoticeManager;
import com.artfess.portal.persistence.manager.PortalNewsTreeManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalNewsNoticeManagerImpl
extends BaseManagerImpl<PortalNewsNoticeDao, PortalNewsNotice>
implements PortalNewsNoticeManager {
    @Resource
    PortalNewsNoticeDao portalNewsNoticeDao;
    @Resource
    PortalNewsTreeManager portalNewsTreeManager;

    @Override
    public List<PortalNewsNotice> getNews(String classifyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        LocalDateTime now = LocalDateTime.now();
        if (!classifyId.equals("all")) {
            queryWrapper.eq((Object)"CLASSIFY_ID_", (Object)classifyId);
        }
        List selectList = ((PortalNewsNoticeDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        ArrayList<PortalNewsNotice> respNotice = new ArrayList<PortalNewsNotice>();
        selectList.forEach(notice -> {
            if (notice.getEndTime() == null || !notice.getEndTime().isBefore(now)) {
                respNotice.add((PortalNewsNotice)((Object)notice));
            }
        });
        return respNotice;
    }

    @Override
    @Transactional
    public Boolean insertNews(PortalNewsNotice news) {
        if (BeanUtils.isNotEmpty((Object)((Object)news))) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("CLASSIFY_ID_", news.getClassifyId());
            news.setSn(this.getNextSequence(paramsMap));
            Integer result = ((PortalNewsNoticeDao)this.baseMapper).insert((Object)news);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public void deleteByClassifyId(String classifyId) {
        this.portalNewsNoticeDao.deleteByClassifyId(classifyId);
    }

    @Override
    @Transactional
    public void deleteNewsByParentId(String parentId) {
        this.portalNewsNoticeDao.deleteNewsByParentId(parentId);
    }

    @Override
    public String export(List<String> ids) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            throw new BaseException("\u4f20\u5165\u7684id\u96c6\u5408\u4e3a\u7a7a");
        }
        List portalNewsNotices = ((PortalNewsNoticeDao)this.baseMapper).selectBatchIds(ids);
        if (BeanUtils.isEmpty((Object)portalNewsNotices)) {
            throw new BaseException("\u6839\u636eid\u96c6\u5408\u67e5\u627e\uff0c\u672a\u67e5\u5230\u4efb\u4f55\u8bb0\u5f55");
        }
        return JsonUtil.toJson((Object)portalNewsNotices);
    }

    @Override
    @Transactional
    public void importFile(String uzPath, String classifyId) {
        try {
            String treeType;
            String fileStr = FileUtil.readFile((String)(uzPath + File.separator + "newsNotice.json"));
            SaaSConfig saaSConfig = (SaaSConfig)AppUtil.getBean(SaaSConfig.class);
            boolean enable = saaSConfig.isEnable();
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            PortalNewsTree portalNewsTree = (PortalNewsTree)this.portalNewsTreeManager.get((Serializable)((Object)classifyId));
            if (BeanUtils.isEmpty((Object)((Object)portalNewsTree))) {
                throw new BaseException("\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u5165\u7684\u5206\u7c7b");
            }
            if (portalNewsTree.getPath().startsWith("100")) {
                treeType = "1";
            } else if (portalNewsTree.getPath().startsWith("200")) {
                treeType = "2";
            } else {
                throw new BaseException("\u6240\u5c5e\u5206\u7c7b\u672a\u77e5");
            }
            for (Object o : list) {
                PortalNewsNotice portalNewsNotice = (PortalNewsNotice)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), PortalNewsNotice.class));
                if (treeType.equals(portalNewsNotice.getType().toString())) {
                    throw new BaseException("\u6240\u5c5e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u5bfc\u5165");
                }
                portalNewsNotice.setClassifyPath(portalNewsTree.getPath());
                portalNewsNotice.setClassifyId(classifyId);
                portalNewsNotice.setClassifyName(portalNewsTree.getName());
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("CLASSIFY_ID_", portalNewsNotice.getClassifyId());
                portalNewsNotice.setSn(this.getNextSequence(paramsMap));
                QueryFilter filter = QueryFilter.build();
                filter.addFilter("CLASSIFY_ID_", (Object)portalNewsTree.getId(), QueryOP.EQUAL, FieldRelation.AND);
                filter.addFilter("ID_", (Object)portalNewsNotice.getId(), QueryOP.EQUAL, FieldRelation.AND);
                PageList old = this.query(filter);
                if (BeanUtils.isEmpty((Object)old.getRows()) || old.getRows().isEmpty()) {
                    portalNewsNotice.setId(UniqueIdUtil.getSuid());
                    if (enable) {
                        portalNewsNotice.setTenantId(null);
                    }
                    this.create((Model)portalNewsNotice);
                    continue;
                }
                this.updateById((Object)portalNewsNotice);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }
}

