/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.sqlbuilder.SqlBuilderModel;
import com.artfess.base.sqlbuilder.service.ISqlBuilderService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.form.datatrans.ITypeConvert;
import com.artfess.form.datatrans.ResultTransform;
import com.artfess.form.model.CustomQuery;
import com.artfess.form.persistence.dao.CustomQueryDao;
import com.artfess.form.persistence.manager.CustomQueryManager;
import com.artfess.form.util.CustomUtil;
import com.artfess.form.vo.CustomQueryControllerVo;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.operator.IViewOperator;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customQueryManager")
public class CustomQueryManagerImpl
extends BaseManagerImpl<CustomQueryDao, CustomQuery>
implements CustomQueryManager {
    @Resource
    CommonManager commonManager;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    MultiTenantHandler tenantHandler;
    @Resource
    DatabaseContext databaseContext;

    @Override
    public PageList getData(CustomQuery customQuery, String queryData, String dsType, int pageNo, int pageSize) throws IOException {
        String sql = this.getSql(customQuery, queryData, dsType);
        if (!"postgresql".equals(dsType)) {
            sql = sql.replaceAll("\"", "");
        }
        PageList pageList = null;
        List list = null;
        if (customQuery.getNeedPage() == 1) {
            pageNo = pageNo <= 0 ? 1 : pageNo;
            pageSize = pageSize <= 0 ? 10 : pageSize;
            PageBean page = new PageBean(Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            pageList = this.commonManager.query(sql, page);
        } else {
            list = this.commonManager.query(sql);
            pageList = new PageList(list);
        }
        ResultTransform.transform(pageList.getRows(), new ITypeConvert(){

            @Override
            public Object processValue(Object obj) {
                Map map = null;
                if (BeanUtils.isNotEmpty((Object)obj)) {
                    map = (Map)obj;
                    for (String key : map.keySet()) {
                        if (BeanUtils.isEmpty(map.get(key)) || !Date.class.isAssignableFrom(map.get(key).getClass()) && !java.util.Date.class.isAssignableFrom(map.get(key).getClass())) continue;
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            map.put(key, sdf.format(map.get(key)));
                        }
                        catch (Exception exception) {}
                    }
                }
                return map;
            }
        });
        return pageList;
    }

    private SqlBuilderModel buildSqlBuilderModel(CustomQuery customQuery, String queryData, String dsType) throws IOException {
        SqlBuilderModel sqlBuilderModel = new SqlBuilderModel();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)queryData)) {
            ArrayNode jArray = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
            for (int i = 0; i < jArray.size(); ++i) {
                ObjectNode jSONObject = (ObjectNode)JsonUtil.toJsonNode((Object)jArray.get(i));
                if (!BeanUtils.isNotEmpty((Object)jSONObject.get("value"))) continue;
                params.put(jSONObject.get("key").asText(), jSONObject.get("value").asText());
            }
        }
        sqlBuilderModel.setDbType(dsType);
        sqlBuilderModel.setFromName(customQuery.getObjName());
        sqlBuilderModel.setResultField((ArrayNode)JsonUtil.toJsonNode((String)customQuery.getResultfield()));
        ArrayNode conditionField = JsonUtil.getMapper().createArrayNode();
        ArrayNode confilJA = (ArrayNode)JsonUtil.toJsonNode((String)customQuery.getConditionfield());
        try {
            boolean isIn;
            ArrayNode queryDataArry = JsonUtil.createArrayNode();
            if (StringUtil.isNotEmpty((String)queryData)) {
                queryDataArry = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
            }
            if (BeanUtils.isNotEmpty((Object)queryDataArry) && queryDataArry.size() > 0) {
                ArrayNode extArray = JsonUtil.getMapper().createArrayNode();
                for (JsonNode quryNode : queryDataArry) {
                    isIn = false;
                    for (JsonNode confNode : confilJA) {
                        ObjectNode objConfNode = (ObjectNode)confNode;
                        if (quryNode.get("key").asText().equals(objConfNode.get("field").asText()) || quryNode.get("key").asText().equals(objConfNode.get("comment").asText())) {
                            isIn = true;
                            if (BeanUtils.isNotEmpty((Object)quryNode.get("value"))) {
                                objConfNode.set("defaultValue", quryNode.get("value"));
                            }
                        }
                        if (isIn) continue;
                        extArray.add(quryNode);
                    }
                }
                if (extArray.size() > 0) {
                    this.getMoreConditionField(customQuery.getResultfield(), (ObjectNode)JsonUtil.toJsonNode((Object)queryDataArry.get(0)), confilJA);
                }
            }
            if (BeanUtils.isNotEmpty((Object)queryDataArry) && queryDataArry.size() > 0) {
                for (Object object1 : queryDataArry) {
                    ObjectNode qObj = (ObjectNode)JsonUtil.toJsonNode(object1);
                    isIn = false;
                    for (Object object2 : confilJA) {
                        ObjectNode confObj = (ObjectNode)JsonUtil.toJsonNode(object2);
                        if (!qObj.get("key").asText().equals(confObj.get("field").asText()) && !qObj.get("key").asText().equals(confObj.get("comment").asText())) continue;
                        isIn = true;
                    }
                    if (isIn) continue;
                    this.getMoreConditionField(customQuery.getResultfield(), qObj, confilJA);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < confilJA.size(); ++i) {
            ObjectNode jObject = (ObjectNode)JsonUtil.toJsonNode((Object)confilJA.get(i));
            String field = jObject.get("field").asText();
            String defaultType = jObject.get("defaultType").asText();
            String defaultValue = jObject.get("defaultValue").asText();
            String dbType = jObject.get("dbType").asText();
            String condition = jObject.get("condition").asText();
            Object value = null;
            ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
            jsonObject.put("field", field);
            jsonObject.put("op", condition);
            jsonObject.put("dbType", dbType);
            value = CustomUtil.buildValue(field, defaultType, defaultValue, params);
            if (BeanUtils.isEmpty((Object)value) || value instanceof String && (StringUtil.isEmpty((String)value.toString()) || value.toString().equals("|"))) continue;
            if (condition.equals(QueryOP.BETWEEN.toString())) {
                value = CustomUtil.handleDateBetweenValue(value);
            }
            jsonObject.set("value", JsonUtil.toJsonNode((Object)value));
            conditionField.add((JsonNode)jsonObject);
        }
        sqlBuilderModel.setConditionField(conditionField);
        sqlBuilderModel.setSortField((ArrayNode)JsonUtil.toJsonNode((String)customQuery.getSortfield()));
        return sqlBuilderModel;
    }

    private void getMoreConditionField(String resultField, ObjectNode qObj, ArrayNode confilJA) throws IOException {
        ArrayNode resultFields = (ArrayNode)JsonUtil.toJsonNode((String)resultField);
        for (Object object : resultFields) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
            if (!obj.get("comment").asText().equals(qObj.get("key").asText())) continue;
            ObjectNode newCondi = JsonUtil.getMapper().createObjectNode();
            newCondi.put("field", obj.get("field").asText());
            newCondi.put("comment", obj.get("comment").asText());
            newCondi.put("condition", "LK");
            newCondi.put("dbType", "varchar");
            newCondi.put("defaultType", 2);
            newCondi.put("defaultValue", qObj.get("value").asText());
            confilJA.add((JsonNode)newCondi);
            break;
        }
    }

    private String getSql(CustomQuery customQuery, String queryData, String dsType) throws IOException {
        String sql = "";
        if (customQuery.getSqlBuildType() == 1) {
            HashMap params = new HashMap();
            if (StringUtil.isNotEmpty((String)queryData)) {
                ArrayNode json = (ArrayNode)JsonUtil.toJsonNode((String)queryData);
                HashMap<String, String> tmp = new HashMap<String, String>();
                boolean isEmpty = true;
                for (JsonNode jsonObj : json) {
                    tmp.put(jsonObj.get("key").asText(), jsonObj.get("value").asText());
                    isEmpty = false;
                }
                if (!isEmpty) {
                    params.put("map", tmp);
                    params.putAll(tmp);
                }
            }
            sql = this.groovyScriptEngine.executeString(customQuery.getDiySql(), params);
        } else {
            SqlBuilderModel model = this.buildSqlBuilderModel(customQuery, queryData, dsType);
            sql = this.sqlBuilderService.getSql(model);
        }
        return sql;
    }

    @Override
    public CustomQuery getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL, FieldRelation.AND);
        PageList list = this.query(queryFilter);
        List customQueries = list.getRows();
        if (customQueries == null || customQueries.isEmpty()) {
            return null;
        }
        return (CustomQuery)((Object)customQueries.get(0));
    }

    @Override
    public ArrayNode getTableOrViewByDsName(CustomQueryControllerVo vo) throws Exception {
        ArrayNode jsonArray = JsonUtil.getMapper().createArrayNode();
        if ("1".equals(vo.getIsTable())) {
            Map map;
            try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(vo.getDsalias());){
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                map = baseTableMeta.getTablesByName(vo.getObjName());
            }
            String tenantCode = this.tenantHandler.getTenantCode();
            List ignoreTableNames = this.tenantHandler.getIgnoreTableNames();
            Pattern regex = null;
            if (StringUtil.isNotEmpty((String)tenantCode)) {
                String exp = String.format("^%s(%s)_.*$", "W_".toLowerCase(), tenantCode.toLowerCase());
                regex = Pattern.compile(exp);
            }
            for (String key : map.keySet()) {
                Matcher matcher;
                if (ignoreTableNames.stream().anyMatch(e -> e.equalsIgnoreCase(key)) || key.toLowerCase().startsWith("W_".toLowerCase()) && regex != null && ((matcher = regex.matcher(key.toLowerCase())) == null || !matcher.find())) continue;
                ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
                jsonObject.put("name", key.toString());
                jsonObject.put("comment", BeanUtils.isNotEmpty(map.get(key)) ? ((String)map.get(key)).toString() : key.toString());
                jsonArray.add((JsonNode)jsonObject);
            }
        } else {
            PageList viewNames;
            try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(vo.getDsalias());){
                IViewOperator iViewOperator = MetaDataUtil.getIViewOperatorAfterSetDT((String)dResult.getDbType());
                viewNames = iViewOperator.getViews(vo.getObjName());
            }
            for (String name : viewNames.getRows()) {
                ObjectNode jsonObject = JsonUtil.getMapper().createObjectNode();
                jsonObject.put("name", name);
                jsonObject.put("comment", name);
                jsonArray.add((JsonNode)jsonObject);
            }
        }
        return jsonArray;
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String s : idList) {
            list.add(this.get((Serializable)((Object)s)));
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "customQuery.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object o : list) {
                CustomQuery customQuery = (CustomQuery)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), CustomQuery.class));
                CustomQuery byAlias = this.getByAlias(customQuery.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (!byAlias.getId().equals(customQuery.getId())) {
                        throw new BaseException("\u522b\u540d\u3010" + customQuery.getAlias() + "\u3011\u5df2\u5b58\u5728");
                    }
                    ((CustomQueryDao)this.baseMapper).updateById((Object)customQuery);
                    continue;
                }
                customQuery.setId(UniqueIdUtil.getSuid());
                ((CustomQueryDao)this.baseMapper).insert((Object)customQuery);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
    }
}

