/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.form.model.CustomChart;
import com.artfess.form.model.CustomChartList;
import com.artfess.form.persistence.dao.CustomChartDao;
import com.artfess.form.persistence.manager.CustomChartManager;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customChartManager")
public class CustomChartManagerImpl
extends BaseManagerImpl<CustomChartDao, CustomChart>
implements CustomChartManager {
    @Resource
    CommonManager commonManager;
    @Resource
    DatabaseContext databaseContext;

    public CustomChart get(Serializable id) {
        CustomChart customChart = (CustomChart)super.get(id);
        if (BeanUtils.isEmpty((Object)((Object)customChart))) {
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("ALIAS_", (Object)id, QueryOP.EQUAL);
            PageList query = this.query(queryFilter);
            if (query.getRows().size() > 0) {
                customChart = (CustomChart)((Object)query.getRows().get(0));
            }
        }
        return customChart;
    }

    @Override
    public Object getListData(CustomChart customDialog, QueryFilter<?> filter, String dbType) throws IOException {
        String sql = "";
        sql = customDialog.getIsTable() == 2 ? customDialog.getDiySql() : "select * from " + customDialog.getObjName();
        PageList query = this.commonManager.query(sql, filter);
        for (int i = 0; i < query.getRows().size(); ++i) {
            Map m = (Map)query.getRows().get(i);
            HashMap tm = new HashMap();
            for (String k : m.keySet()) {
                tm.put(k.toUpperCase(), m.get(k));
            }
            query.getRows().set(i, tm);
        }
        return query;
    }

    @Override
    public CustomChart getChartByAlias(String alias) {
        return ((CustomChartDao)this.baseMapper).getChartByAlias(alias);
    }

    @Override
    public boolean listChartByAlias(String alias) {
        List<CustomChart> customCharts = ((CustomChartDao)this.baseMapper).listChartByAlias(alias);
        return customCharts.size() <= 1;
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        CustomChartList customChartList = new CustomChartList();
        for (String id : ids) {
            CustomChart customChart = this.get((Serializable)((Object)id));
            customChartList.addCustomChart(customChart);
        }
        try {
            String xml = JAXBUtil.marshall((Object)customChartList, CustomChartList.class);
            map.put("customCharts.form.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "customCharts.form.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            CustomChartList list = (CustomChartList)JAXBUtil.unmarshall((String)xml, CustomChartList.class);
            List<CustomChart> customChartList = list.getCustomChartList();
            for (CustomChart customChart : customChartList) {
                this.importData(customChart);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    private void importData(CustomChart customChart) {
        block18: {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"alias_", (Object)customChart.getAlias());
            List customChartList = ((CustomChartDao)this.baseMapper).selectList((Wrapper)wrapper);
            if (customChartList != null && !customChartList.isEmpty()) {
                ThreadMsgUtil.addMapMsg2((String)"customChartsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", customChart.getName() + "", customChart.getAlias() + ""));
                return;
            }
            try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customChart.getDsalias());){
                short isTable;
                short s = isTable = customChart.getIsTable() != null ? customChart.getIsTable() : (short)1;
                if (isTable == 1) {
                    try {
                        BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                        baseTableMeta.getTableByName(customChart.getObjName());
                        break block18;
                    }
                    catch (Exception e) {
                        throw new BaseException(String.format("\u6570\u636e\u6e90: %s \u4e2d\u7684\u6570\u636e\u8868: %s \u4e0d\u5b58\u5728!", customChart.getDsalias() + "", customChart.getObjName() + ""));
                    }
                }
                this.checkSql(customChart.getDiySql());
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        String id = UniqueIdUtil.getSuid();
        customChart.setId(id);
        this.create((Model)customChart);
        ThreadMsgUtil.addMapMsg2((String)"customChartsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", customChart.getName() + "", customChart.getAlias() + ""));
    }

    private void checkSql(String sql) {
        if (SQLUtil.containsSqlInjection((String)sql)) {
            throw new BaseException("SQL\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("bad SQL grammar")) {
                throw new BaseException("SQL\u8bed\u53e5\u5b58\u5728\u8bed\u6cd5\u9519\u8bef\uff01");
            }
            throw new BaseException("SQL\u9a8c\u8bc1\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
    }
}

