/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.sqlbuilder.ISqlBuilder;
import com.artfess.base.sqlbuilder.SqlBuilderModel;
import com.artfess.base.sqlbuilder.service.ISqlBuilderService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoAttributeManager;
import com.artfess.bo.persistence.manager.BoEntManager;
import com.artfess.form.model.CombinateDialog;
import com.artfess.form.model.CustomDialog;
import com.artfess.form.persistence.dao.CustomDialogDao;
import com.artfess.form.persistence.manager.CombinateDialogManager;
import com.artfess.form.persistence.manager.CustomDialogManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customDialogManager")
public class CustomDialogManagerImpl
extends BaseManagerImpl<CustomDialogDao, CustomDialog>
implements CustomDialogManager {
    @Resource
    CombinateDialogManager combinateDialogManager;
    @Resource
    ISqlBuilderService sqlBuilderService;
    @Resource
    BoEntManager boEntManager;
    @Resource
    BoAttributeManager boAttributeManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;
    @Resource
    WorkflowFeignService workflowFeignService;

    @Override
    public CustomDialog getByAlias(String alias) {
        CustomDialog byAlias = ((CustomDialogDao)this.baseMapper).getByAlias(alias);
        if (byAlias == null || byAlias.getStyle() == 1) {
            return byAlias;
        }
        String displayfield = byAlias.getDisplayfield();
        String resultfield = byAlias.getResultfield();
        String conditionfield = byAlias.getConditionfield();
        try {
            if (!displayfield.equals("[]")) {
                JsonNode jsonNode = JsonUtil.toJsonNode((String)displayfield);
                String disPlay = this.getNewField(jsonNode, displayfield);
                byAlias.setDisplayfield(disPlay);
            }
            if (!resultfield.equals("[]")) {
                JsonNode jsonNode1 = JsonUtil.toJsonNode((String)resultfield);
                String resultField = this.getNewField(jsonNode1, resultfield);
                byAlias.setResultfield(resultField);
            }
            if (!conditionfield.equals("[]")) {
                JsonNode jsonNode2 = JsonUtil.toJsonNode((String)conditionfield);
                String condition = this.getNewField(jsonNode2, conditionfield);
                byAlias.setConditionfield(condition);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return byAlias;
    }

    private String getNewField(JsonNode jsonNode, String str) {
        String resultStr = null;
        String dbType = SQLUtil.getDbType();
        for (int i = 0; i < jsonNode.size(); ++i) {
            String field = jsonNode.get(i).get("field").asText().toLowerCase();
            if ("postgresql".equals(dbType)) {
                field = jsonNode.get(i).get("field").asText();
            }
            if (str.indexOf(jsonNode.get(i).get("field").asText()) == -1) continue;
            String rfield = ":\"" + jsonNode.get(i).get("field").asText() + "\"";
            String brfield = ":\"" + field + "\"";
            resultStr = resultStr != null ? resultStr.replace(rfield, brfield) : str.replace(rfield, brfield);
        }
        return resultStr;
    }

    @Override
    public PageList getListData(CustomDialog customDialog, Map<String, Object> param, PageBean pageBean) throws Exception {
        Serializable dataFormatMap;
        String sql = "";
        List boEntList = null;
        List attr = null;
        HashMap<String, String> attrMap = new HashMap<String, String>();
        if (customDialog.getSqlBuildType() == 1) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("map", param);
            params.putAll(param);
            sql = this.groovyScriptEngine.executeString(customDialog.getDiySql(), params);
        } else {
            String dbType = this.databaseContext.getDbTypeByAlias(customDialog.getDsalias());
            SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType);
            String fromName = model.getFromName();
            dataFormatMap = new HashMap();
            if (StringUtil.isNotEmpty((String)fromName) && (boEntList = this.boEntManager.getByTableName(fromName)).size() > 0) {
                for (BoEnt boEnt : boEntList) {
                    attr = this.boAttributeManager.getByBoEnt(boEnt);
                    for (BoAttribute attribute : attr) {
                        if ("yyyy-MM-dd".equals(attribute.getFormat())) {
                            String fieldName = attribute.getFieldName();
                            attrMap.put(fieldName.toUpperCase(), fieldName.toUpperCase());
                        }
                        if (!StringUtil.isNotEmpty((String)attribute.getFormat())) continue;
                        dataFormatMap.put(attribute.getFieldName().toUpperCase(), attribute.getFormat());
                        dataFormatMap.put(attribute.getFieldName().toLowerCase(), attribute.getFormat());
                    }
                }
            }
            if (dataFormatMap.size() > 0) {
                for (int i = 0; i < model.getConditionField().size(); ++i) {
                    ObjectNode obj = (ObjectNode)model.getConditionField().get(i);
                    String key = obj.get("field").asText();
                    if (!"date".equals(obj.get("dbType").asText()) || !dataFormatMap.containsKey(key)) continue;
                    obj.put("format", (String)dataFormatMap.get(key));
                }
            }
            ISqlBuilder sqlBuilder = this.sqlBuilderService.getSqlBuilder(model);
            sql = sqlBuilder.getSql();
        }
        List list = null;
        PageList pageList = null;
        DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customDialog.getDsalias());
        dataFormatMap = null;
        try {
            if (customDialog.getNeedPage().booleanValue()) {
                PageBean page = pageBean == null ? new PageBean() : pageBean;
                pageList = this.commonManager.query(sql, page);
            } else {
                list = this.commonManager.query(sql);
            }
        }
        catch (Throwable page) {
            dataFormatMap = page;
            throw page;
        }
        finally {
            if (dResult != null) {
                if (dataFormatMap != null) {
                    try {
                        dResult.close();
                    }
                    catch (Throwable page) {
                        ((Throwable)dataFormatMap).addSuppressed(page);
                    }
                } else {
                    dResult.close();
                }
            }
        }
        if (list == null) {
            list = pageList.getRows();
        }
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap<String, Object> tm = new HashMap<String, Object>();
            for (String k : m.keySet()) {
                try {
                    if (BeanUtils.isNotEmpty(m.get(k)) && "java.sql.Timestamp".equals(m.get(k).getClass().getCanonicalName())) {
                        Date date = (Date)m.get(k);
                        if (date.getYear() == 70 && date.getMonth() == 0 && date.getDate() == 1) {
                            tm.put(k.toLowerCase(), DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"HH:mm:ss"));
                        } else if (date.getMinutes() == 0 && date.getHours() == 0 && date.getSeconds() == 0 && k.toLowerCase().equals(attrMap.get(k.toLowerCase()))) {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date).toLocalDate());
                        } else {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date));
                        }
                    } else {
                        tm.put(k.toLowerCase(), m.get(k));
                    }
                }
                catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
            if (customDialog.getNeedPage().booleanValue()) continue;
            pageList = new PageList(list);
            pageList.setPageSize((long)list.size());
            pageList.setPage(1L);
        }
        return pageList;
    }

    @Override
    public PageList getCustomDialogData(String alias, QueryFilter filter, String mapParam) throws Exception {
        PageBean pageBean;
        PageList list;
        List querys;
        CustomDialog customDialog = null;
        if (StringUtil.isNotEmpty((String)alias)) {
            customDialog = this.getByAlias(alias);
        }
        if (customDialog == null) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)mapParam)) {
            mapParam = "{" + mapParam + "}";
            Map map = JsonUtil.toMap((String)mapParam);
            for (Iterator<Object> key : map.keySet()) {
                param.put(key + "", map.get(key));
            }
        }
        if (BeanUtils.isNotEmpty((Object)customDialog.getConditionfield())) {
            try {
                Iterator<Object> key;
                String conditionfield = customDialog.getConditionfield();
                ArrayNode confArray = (ArrayNode)JsonUtil.toJsonNode((String)conditionfield);
                key = confArray.iterator();
                while (key.hasNext()) {
                    CommonResult result;
                    JsonNode jsonNode = (JsonNode)key.next();
                    if (!BeanUtils.isNotEmpty((Object)jsonNode.get("defaultType")) || !"5".equals(jsonNode.get("defaultType").asText())) continue;
                    String field = jsonNode.get("field").asText();
                    String scriptStr = jsonNode.get("defaultValue").asText();
                    if (!StringUtil.isNotEmpty((String)scriptStr) || !(result = this.workflowFeignService.executeScript(scriptStr)).getState().booleanValue()) continue;
                    param.put(field, result.getValue());
                }
            }
            catch (Exception e) {
                throw new WorkFlowException("\u6267\u884c\u53c2\u6570\u811a\u672c\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        if ((querys = filter.getQuerys()).size() > 0) {
            for (QueryField queryField : querys) {
                param.put(queryField.getProperty(), queryField.getValue());
            }
            if (querys.size() > 1) {
                param.put("relation", ((QueryField)querys.get(1)).getRelation().value());
            }
        }
        if (BeanUtils.isNotEmpty((Object)(list = this.getListData(customDialog, param, pageBean = filter.getPageBean())))) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (int i = 0; i < list.getRows().size(); ++i) {
                HashMap map = (HashMap)list.getRows().get(i);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof Timestamp) {
                        Timestamp times = (Timestamp)entry.getValue();
                        entry.setValue(dateFormat.format(times));
                        continue;
                    }
                    if (!(entry.getValue() instanceof Date)) continue;
                    entry.setValue(dateFormat.format(entry.getValue()));
                }
            }
        }
        return list;
    }

    private void addQuery2Condition(List<QueryField> querys, CustomDialog customDialog) throws Exception {
        ArrayNode confArray = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getConditionfield());
        querys.forEach(item -> {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("field", item.getProperty());
            node.put("defaultType", "1");
            node.put("defaultValue", item.getValue().toString());
            node.put("dbType", "varchar");
            node.put("condition", item.getOperation().value());
            confArray.add((JsonNode)node);
        });
        customDialog.setConditionfield(JsonUtil.toJsonString((Object)confArray));
    }

    @Override
    public Map getMobileCustomDialogData(Boolean isCombine, String alias) throws Exception {
        HashMap<String, Object> mv = new HashMap<String, Object>();
        CustomDialog customDialog = null;
        CustomDialog treeDialog = null;
        if (isCombine.booleanValue()) {
            CombinateDialog combine = this.combinateDialogManager.getByAlias(alias);
            treeDialog = combine.getTreeDialog();
            customDialog = combine.getListDialog();
            mv.put("combineField", combine.getField());
            mv.put("returnField", combine.getListDialog().getResultfield());
            mv.put("isSingle", combine.getListDialog().getSelectNum() == 1);
        } else {
            CustomDialog dialog = this.getByAlias(alias);
            Boolean isTree = dialog.getStyle() == 1;
            if (isTree.booleanValue()) {
                treeDialog = dialog;
                String disPlayName = JsonUtil.toJsonNode((String)dialog.getDisplayfield()).get("displayName") + "";
                mv.put("displayName", disPlayName.toUpperCase());
            } else {
                customDialog = dialog;
                mv.put("returnField", dialog.getResultfield());
                mv.put("isSingle", dialog.getSelectNum() == 1);
            }
        }
        if (customDialog != null) {
            JsonNode customDialogNode = JsonUtil.toJsonNode((Object)((Object)customDialog));
            Map custDialog = JsonUtil.toMap((String)(customDialogNode + ""));
            custDialog.put("conditionfield", JsonUtil.toJsonNode((String)customDialog.getConditionfield()));
            custDialog.put("displayfield", JsonUtil.toJsonNode((String)customDialog.getDisplayfield()));
            mv.put("listDialog", JsonUtil.toJsonNode((Object)custDialog));
        }
        if (treeDialog != null) {
            mv.put("treeDialog", (Object)treeDialog);
        }
        mv.put("isCombine", isCombine);
        return mv;
    }

    @Override
    public List geTreetData(CustomDialog customDialog, Map<String, Object> param, String dbType) throws IOException {
        String sql = this.getTreeSql(customDialog, param, dbType);
        List pageList = this.commonManager.query(sql);
        this.handleIsParent(pageList);
        return pageList;
    }

    private Map<String, Object> getFromParam(Map<String, Object> param, String fieldName) {
        try {
            Pattern regex = Pattern.compile("Q\\^(.*)\\^(.*)");
            String name = "";
            for (String k : param.keySet()) {
                Matcher regexMatcher = regex.matcher(k);
                if (!regexMatcher.matches() || !fieldName.equals(name = regexMatcher.group(1))) continue;
                Object object = param.get(k);
                if (BeanUtils.isEmpty((Object)object)) {
                    return null;
                }
                Map returnMap = MapUtil.buildMap((String)"value", (Object)object);
                returnMap.put("condition", regexMatcher.group(2));
                return returnMap;
            }
        }
        catch (PatternSyntaxException ex) {
            return null;
        }
        return null;
    }

    private SqlBuilderModel constructSqlBuilderModel(CustomDialog customDialog, Map<String, Object> param, String dbType) throws IOException {
        ArrayNode conditionField = JsonUtil.getMapper().createArrayNode();
        ArrayNode conJA = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getConditionfield());
        for (int i = 0; i < conJA.size(); ++i) {
            JsonNode jo = conJA.get(i);
            String fieldName = jo.get("field").asText();
            String defaultType = jo.get("defaultType").asText();
            String defaultValue = jo.get("defaultValue").asText();
            String fdbType = jo.get("dbType").asText();
            String condition = jo.get("condition").asText();
            Object value = null;
            if (defaultType.equals("1") || defaultType.equals("3")) {
                value = MapUtil.getIgnoreCase(param, (String)fieldName);
            } else if (defaultType.equals("2")) {
                value = defaultValue;
            } else if (defaultType.equals("7")) {
                Map<String, Object> fromParam = this.getFromParam(param, fieldName);
                if (BeanUtils.isEmpty(fromParam)) continue;
                condition = MapUtil.getString(fromParam, (String)"condition");
                value = fromParam.get("value");
            } else {
                value = MapUtil.getIgnoreCase(param, (String)fieldName);
            }
            if (BeanUtils.isEmpty((Object)value)) continue;
            HashMap<String, Object> jsonObject = new HashMap<String, Object>();
            jsonObject.put("field", fieldName);
            jsonObject.put("op", condition);
            jsonObject.put("dbType", fdbType);
            jsonObject.put("value", value);
            jsonObject.put("relation", param.get("relation"));
            conditionField.add(JsonUtil.toJsonNode(jsonObject));
        }
        ArrayNode sortField = (ArrayNode)JsonUtil.toJsonNode((String)customDialog.getSortfield());
        ObjectNode sortFieldJO = JsonUtil.arrayToObject((ArrayNode)sortField, (String)"field");
        String sortFieldStr = MapUtil.getIgnoreCase(param, (String)"sortField", (Object)"").toString();
        String orderSeq = MapUtil.getIgnoreCase(param, (String)"orderSeq", (Object)"").toString();
        if (StringUtil.isNotEmpty((String)sortFieldStr) && StringUtil.isNotEmpty((String)orderSeq)) {
            ObjectNode jo = JsonUtil.getMapper().createObjectNode();
            jo.put("field", sortFieldStr);
            jo.put("sortType", orderSeq);
            sortFieldJO.put(sortFieldStr, (JsonNode)jo);
        }
        SqlBuilderModel model = new SqlBuilderModel();
        model.setFromName(customDialog.getObjName());
        model.setDbType(dbType);
        model.setConditionField(conditionField);
        model.setSortField(JsonUtil.objectToArray((JsonNode)sortFieldJO));
        return model;
    }

    private void handleIsParent(List list) {
        block0: for (Object obj : list) {
            Map map = (Map)obj;
            for (String key : map.keySet()) {
                Object isParent;
                if (!"isParent".equals(key) || !"ISPARENT".equals(key.trim().toUpperCase()) || (isParent = map.get(key)) == null) continue;
                if ("true".equals(isParent.toString())) {
                    map.put("isLeaf", false);
                } else {
                    map.put("isLeaf", true);
                }
                map.remove(key);
                continue block0;
            }
        }
    }

    private String getTreeSql(CustomDialog customDialog, Map<String, Object> param, String dbType) throws IOException {
        String sql = "";
        SqlBuilderModel model = this.constructSqlBuilderModel(customDialog, param, dbType);
        JsonNode djo = JsonUtil.toJsonNode((String)customDialog.getDisplayfield());
        HashMap<String, Object> pidJson = new HashMap<String, Object>();
        String pid = this.getPid(customDialog, param);
        if (StringUtil.isNotEmpty((String)pid)) {
            pidJson.put("field", djo.get("pid"));
            pidJson.put("op", QueryOP.EQUAL.value());
            pidJson.put("dbType", "varchar");
            pidJson.put("value", pid);
        } else {
            pidJson.put("field", djo.get("pid"));
            pidJson.put("dbType", "varchar");
            pidJson.put("op", QueryOP.IS_NULL);
        }
        model.getConditionField().add(JsonUtil.toJsonNode(pidJson));
        sql = this.sqlBuilderService.getSql(model);
        sql = sql.replace(customDialog.getObjName(), customDialog.getObjName() + " o ").replace("*", "o.*");
        String isParentSql = ", ( case (select count(*)  from " + customDialog.getObjName() + " p where p." + djo.get("pid") + "=o." + djo.get("id") + " and p." + djo.get("id") + "!=p." + djo.get("pid") + ") when 0 then 'false' else 'true' end )isParent ";
        isParentSql = isParentSql.replaceAll("\"", "");
        String[] strs = sql.split("from");
        strs[0] = strs[0].contains("*") ? strs[0].replace("*", "") : strs[0] + ",";
        String str0 = strs[0] + " * ";
        str0 = str0 + isParentSql;
        sql = str0 + " from " + strs[1];
        sql = sql.replaceAll("\"", "");
        return sql;
    }

    private String getPid(CustomDialog customDialog, Map<String, Object> param) throws IOException {
        String str = customDialog.getDisplayfield();
        ObjectNode jo = (ObjectNode)JsonUtil.toJsonNode((String)str);
        String id = jo.get("id") + "";
        String isScript = JsonUtil.getString((JsonNode)jo, (String)"isScript", (String)"false");
        String pvalue = JsonUtil.getString((JsonNode)jo, (String)"pvalue", (String)"");
        String pidVal = MapUtil.getIgnoreCase(param, (String)id, (Object)"").toString();
        if (StringUtil.isNotEmpty((String)pidVal)) {
            pidVal = isScript != null && isScript.equals("true") ? this.groovyScriptEngine.executeString(pvalue, null).toString() : pvalue;
        }
        return pidVal;
    }

    @Override
    public String export(String[] idList) throws IOException {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String id : idList) {
            list.add(this.get((Serializable)((Object)id)));
        }
        if (BeanUtils.isNotEmpty(list)) {
            return JsonUtil.toJson(list);
        }
        return "";
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String fileStr = FileUtil.readFile((String)(unZipFilePath + File.separator + "customDialog.json"));
            List list = (List)JsonUtil.toBean((String)fileStr, List.class);
            for (Object o : list) {
                CustomDialog customDialog = (CustomDialog)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), CustomDialog.class));
                CustomDialog byAlias = ((CustomDialogDao)this.baseMapper).getByAlias(customDialog.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (byAlias.getId().equals(customDialog.getId())) {
                        ((CustomDialogDao)this.baseMapper).updateById((Object)customDialog);
                        continue;
                    }
                    throw new BaseException("\u81ea\u5b9a\u4e49\u5bf9\u8bdd\u6846\u522b\u540d\u3010" + customDialog.getAlias() + "\u3011\u5df2\u5b58\u5728");
                }
                customDialog.setId(UniqueIdUtil.getSuid());
                ((CustomDialogDao)this.baseMapper).insert((Object)customDialog);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    @Override
    public void saveWithCombineDialog(CustomDialog customDialog) {
        if (StringUtil.isEmpty((String)customDialog.getId())) {
            if (BeanUtils.isNotEmpty((Object)((Object)this.getByAlias(customDialog.getAlias())))) {
                throw new BaseException("\u522b\u540d" + customDialog.getAlias() + "\uff0c\u5df2\u5b58\u5728");
            }
            customDialog.setId(UniqueIdUtil.getSuid());
            customDialog.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)customDialog);
        } else {
            this.update((Model)customDialog);
        }
    }
}

