/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class DmpBeanUtil {
    private static final Logger log = LoggerFactory.getLogger(DmpBeanUtil.class);

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
    }

    public static <T> T copy(Object source, Class<T> target) {
        try {
            T newInstance = target.newInstance();
            BeanUtils.copyProperties((Object)source, newInstance);
            return newInstance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, K> List<K> copyList(List<T> source, Class<K> target) {
        if (null == source || source.isEmpty()) {
            return new ArrayList();
        }
        return source.stream().map(e -> DmpBeanUtil.copy(e, target)).collect(Collectors.toList());
    }

    public static <T> void setPropertiesNull(Object source, Class<T> baseEntity) {
        Class<?> aClass = source.getClass();
        Arrays.stream(baseEntity.getDeclaredFields()).map(Field::getName).collect(Collectors.toList()).forEach(o -> {
            Field field = null;
            try {
                field = aClass.getDeclaredField((String)o);
                Object object = aClass.newInstance();
                field.setAccessible(true);
                field.set(object, null);
            }
            catch (NoSuchFieldException e) {
                log.info("\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.info("\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
            }
            catch (InstantiationException e) {
                log.info("\u5904\u7406\u5f02\u5e38:{}", (Object)e.getMessage());
            }
        });
    }
}

