/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.huawei.message.utils;

import com.artfess.base.huawei.message.utils.StringUtil;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static String jsonObj2Sting(Object jsonObj) {
        String jsonString = null;
        try {
            jsonString = objectMapper.writeValueAsString(jsonObj);
        }
        catch (IOException e) {
            System.out.printf("pasre json Object[{}] to string failed.", jsonString);
        }
        return jsonString;
    }

    public static <T> T jsonString2SimpleObj(String jsonString, Class<T> cls) {
        Object jsonObj = null;
        try {
            jsonObj = objectMapper.readValue(jsonString, cls);
        }
        catch (IOException e) {
            System.out.printf("pasre json Object[{}] to string failed.", jsonString);
        }
        return (T)jsonObj;
    }

    public static <T> ObjectNode convertObject2ObjectNode(T object) throws Exception {
        if (null == object) {
            return null;
        }
        ObjectNode objectNode = null;
        objectNode = object instanceof String ? JsonUtil.convertJsonStringToObject((String)object, ObjectNode.class) : JsonUtil.convertValue(object, ObjectNode.class);
        return objectNode;
    }

    public static <T> T convertJsonStringToObject(String jsonString, Class<T> cls) throws Exception {
        if (StringUtil.strIsNullOrEmpty(jsonString)) {
            return null;
        }
        try {
            Object object = objectMapper.readValue(jsonString, cls);
            return (T)object;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static <T> T convertValue(Object fromValue, Class<T> toValueType) throws Exception {
        try {
            return (T)objectMapper.convertValue(fromValue, toValueType);
        }
        catch (IllegalArgumentException e) {
            throw new Exception(e);
        }
    }

    static {
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

