/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util.string;

import com.artfess.base.util.string.StringConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class StringCollections {
    public static final String DEFAULT_TOKEN = ",";

    public static final List<String> toLetterList(String str) {
        ArrayList<String> singles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)str)) {
            for (int i = 0; i < str.length(); ++i) {
                singles.add(str.substring(i, i + 1));
            }
        }
        return singles;
    }

    public static final String[] toArray(String str, String token) {
        String[] array = null;
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                if (st != null && st.countTokens() > 0) {
                    array = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        array[i++] = st.nextToken();
                    }
                }
            } else {
                array = new String[]{str};
            }
        }
        return array;
    }

    public static final String[] toArray(String str) {
        return StringCollections.toArray(str, DEFAULT_TOKEN);
    }

    public static final String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = list.get(i).toString();
        }
        return array;
    }

    public static final List<String> toList(String str, String token) {
        ArrayList<String> array = new ArrayList<String>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(st.nextToken());
                }
            } else {
                array.add(str);
            }
        }
        return array;
    }

    public static final List<Integer> toListInteger(String str, String token) {
        ArrayList<Integer> array = new ArrayList<Integer>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(StringConverter.toInteger(st.nextToken()));
                }
            } else {
                array.add(new Integer(str));
            }
        }
        return array;
    }

    public static final List<Long> toListLong(String str, String token) {
        ArrayList<Long> array = new ArrayList<Long>();
        if (str != null && str.length() > 0 && token != null && token.length() > 0) {
            if (str.indexOf(token) > -1) {
                StringTokenizer st = new StringTokenizer(str, token);
                while (st.hasMoreTokens()) {
                    array.add(StringConverter.toLong(st.nextToken()));
                }
            } else {
                array.add(new Long(str));
            }
        }
        return array;
    }

    public static final LinkedHashMap<String, String> toMapByTokens(String options, String token1, String token2) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] strArray = StringCollections.toArray(options, token1);
        for (int i = 0; i < strArray.length; ++i) {
            String option = strArray[i];
            if (option.indexOf(token2) > -1) {
                String[] keyAndValue = StringCollections.toArray(option, token2);
                map.put(keyAndValue[0], keyAndValue[1]);
                continue;
            }
            map.put(option, option);
        }
        return map;
    }

    public static final String toString(List<?> list, String appendToken) {
        StringBuffer sb = new StringBuffer();
        int len = list.size();
        int last = len - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(list.get(i));
            if (i == last) continue;
            sb.append(appendToken);
        }
        return sb.toString();
    }

    public static final String toString(List<String> list, String appendToken, String prefix) {
        StringBuffer sb = new StringBuffer();
        int len = list.size();
        int last = len - 1;
        for (int i = 0; i < len; ++i) {
            sb.append(prefix + list.get(i));
            if (i == last) continue;
            sb.append(appendToken);
        }
        return sb.toString();
    }

    public static final String toString(String str, String splitToken, String prefix) {
        List<String> list = StringCollections.toList(str, splitToken);
        return StringCollections.toString(list, splitToken, prefix);
    }
}

