/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.ArrayUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.SQLUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class JdbcTemplateUtil {
    public static <T> PageList<T> queryForListWithPage(String originalSql, PageBean pageBean, Class<T> elementType) {
        return JdbcTemplateUtil.queryForListWithPage(originalSql, null, pageBean, elementType);
    }

    public static <T> PageList<T> queryForListWithPage(String originalSql, Object[] args, PageBean pageBean, Class<T> elementType) {
        Object[] pageArgs;
        JdbcTemplate jdbcTemplate = AppUtil.getBean(JdbcTemplate.class);
        PageList pageList = new PageList();
        String dialectSql = JdbcTemplateUtil.initPageList(jdbcTemplate, originalSql, pageBean, pageList);
        Object[] newArgs = pageArgs = JdbcTemplateUtil.getPageArgs(pageBean);
        if (BeanUtils.isNotEmpty(args)) {
            newArgs = ArrayUtil.concat(args, pageArgs);
        }
        List queryForList = jdbcTemplate.queryForList(dialectSql, newArgs, elementType);
        pageList.setRows(queryForList);
        return pageList;
    }

    public static PageList<Map<String, Object>> queryForListWithPage(String originalSql, PageBean pageBean) {
        return JdbcTemplateUtil.queryForListWithPage(originalSql, null, pageBean);
    }

    public static PageList<Map<String, Object>> queryForListWithPage(String originalSql, Object[] args, PageBean pageBean) {
        Object[] pageArgs;
        JdbcTemplate jdbcTemplate = AppUtil.getBean(JdbcTemplate.class);
        PageList<Map<String, Object>> pageList = new PageList<Map<String, Object>>();
        String dialectSql = JdbcTemplateUtil.initPageList(jdbcTemplate, originalSql, pageBean, pageList);
        Object[] newArgs = pageArgs = JdbcTemplateUtil.getPageArgs(pageBean);
        if (BeanUtils.isNotEmpty(args)) {
            newArgs = ArrayUtil.concat(args, pageArgs);
        }
        List queryForList = jdbcTemplate.queryForList(dialectSql, newArgs);
        pageList.setRows(queryForList);
        return pageList;
    }

    public static <T> PageList<T> query(String originalSql, PageBean pageBean, RowMapper<T> rowMapper) {
        return JdbcTemplateUtil.query(originalSql, null, pageBean, rowMapper);
    }

    public static <T> PageList<T> query(String originalSql, Object[] args, PageBean pageBean, RowMapper<T> rowMapper) {
        Object[] pageArgs;
        JdbcTemplate jdbcTemplate = AppUtil.getBean(JdbcTemplate.class);
        PageList pageList = new PageList();
        Object[] newArgs = pageArgs = JdbcTemplateUtil.getPageArgs(pageBean);
        if (BeanUtils.isNotEmpty(args)) {
            newArgs = ArrayUtil.concat(args, pageArgs);
        }
        String dialectSql = JdbcTemplateUtil.initPageList(jdbcTemplate, originalSql, args, pageBean, pageList);
        List query = jdbcTemplate.query(dialectSql, newArgs, rowMapper);
        pageList.setRows(query);
        return pageList;
    }

    private static <T> String initPageList(JdbcTemplate jdbcTemplate, String originalSql, PageBean pageBean, PageList<T> pageList) {
        return JdbcTemplateUtil.initPageList(jdbcTemplate, originalSql, null, pageBean, pageList);
    }

    private static <T> String initPageList(JdbcTemplate jdbcTemplate, String originalSql, Object[] args, PageBean pageBean, PageList<T> pageList) {
        SqlInfo sqlInfo = SqlParserUtils.getOptimizeCountSql((boolean)true, null, (String)originalSql);
        String countSql = sqlInfo.getSql();
        IDialect dialect = DialectFactory.getDialect((DbType)SQLUtil.getDbTypeObj());
        DialectModel model = dialect.buildPaginationSql(originalSql, (long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue());
        String dialectSql = model.getDialectSql();
        Long total = 0L;
        total = BeanUtils.isNotEmpty(args) ? (Long)jdbcTemplate.queryForObject(countSql, args, Long.class) : (Long)jdbcTemplate.queryForObject(countSql, Long.class);
        pageList.setPage(pageBean.getPage().intValue());
        pageList.setPageSize(pageBean.getPageSize().intValue());
        pageList.setTotal(total);
        return dialectSql;
    }

    private static Object[] getPageArgs(PageBean pageBean) {
        Object[] args = new Object[]{pageBean.getLimit(), pageBean.getOffset()};
        return args;
    }
}

