/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.manager.impl;

import com.artfess.base.dao.CommonDao;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.SystemException;
import com.artfess.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.QueryFilterHelper;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

@Service
public class DefaultCommonManager
implements CommonManager,
QueryFilterHelper<Map<String, Object>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    CommonDao commonDao;

    @Override
    public int execute(String sql) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        return this.execute(sql, new HashMap<String, Object>());
    }

    private String convertToMap(Map<String, Object> map, String sql, Object ... objs) {
        Assert.notNull(map, (String)"map\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)StringUtil.isNotEmpty(sql), (String)"sql\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)BeanUtils.isNotEmpty(objs), (String)"objs\u4e0d\u80fd\u4e3a\u7a7a");
        Pattern pattern = Pattern.compile("(\\?)");
        Matcher matcher = pattern.matcher(sql);
        StringBuffer sb = new StringBuffer();
        int count = 0;
        while (matcher.find()) {
            matcher.appendReplacement(sb, String.format("#{key%s}", count));
            ++count;
        }
        matcher.appendTail(sb);
        if (count != objs.length) {
            throw new BaseException(String.format("sql\uff1a%s\u4e2d\u53c2\u6570\u5316\u7684\u6570\u91cf\u548c\u4f20\u9012\u8fdb\u6765\u7684\u53c2\u6570\uff1a%s\u6570\u91cf\u4e0d\u5339\u914d\u3002", sql, objs));
        }
        map.clear();
        for (int i = 0; i < objs.length; ++i) {
            map.put("key" + i, objs[i]);
        }
        return sb.toString();
    }

    @Override
    public int execute(String sql, Object ... objs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String newSql = this.convertToMap(map, sql, objs);
        return this.execute(newSql, map);
    }

    @Override
    public int execute(String sql, Map<String, Object> map) {
        map.put("sql", sql);
        if (MasterSlaveAutoRoutingPlugin.getInExternalDatasource()) {
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
            try {
                int update = this.commonDao.update(map);
                transactionManager.commit(status);
                return update;
            }
            catch (DuplicateKeyException e) {
                transactionManager.rollback(status);
                throw e;
            }
            catch (Exception e) {
                transactionManager.rollback(status);
                throw new BaseException(ResponseErrorEnums.DATABASE_ERROR, (Throwable)e);
            }
        }
        return this.commonDao.update(map);
    }

    @Override
    public List<Map<String, Object>> query(String sql) {
        return this.query(sql, new HashMap<String, Object>());
    }

    @Override
    public List<Map<String, Object>> query(String sql, Object ... objs) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String newSql = this.convertToMap(map, sql, objs);
        return this.query(newSql, map);
    }

    @Override
    public List<Map<String, Object>> query(String sql, Map<String, Object> map) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(map, (String)"map can not be empty.");
        if (map.containsKey("sql")) {
            this.logger.warn("can not define 'sql' in map when invoke CommonManager.query(sql, map), it will be override by sql string.");
        }
        map.put("sql", sql);
        if (MasterSlaveAutoRoutingPlugin.getInExternalDatasource()) {
            PlatformTransactionManager transactionManager = (PlatformTransactionManager)AppUtil.getBean(TransactionManager.class);
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            TransactionStatus status = transactionManager.getTransaction((TransactionDefinition)def);
            try {
                List<Map<String, Object>> result = this.commonDao.query(map);
                transactionManager.commit(status);
                return result;
            }
            catch (Exception e) {
                transactionManager.rollback(status);
                throw new BaseException(ResponseErrorEnums.DATABASE_ERROR, (Throwable)e);
            }
        }
        return this.commonDao.query(map);
    }

    @Override
    public PageList<Map<String, Object>> query(String sql, PageBean pageBean) {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        IPage<Map<String, Object>> result = this.commonDao.queryByPage(this.convert2IPage(pageBean), sql);
        return new PageList<Map<String, Object>>(result);
    }

    @Override
    public PageList<Map<String, Object>> query(String sql, QueryFilter<?> queryFilter) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(queryFilter, (String)"queryFilter can not be empty.");
        PageBean pageBean = queryFilter.getPageBean();
        IPage<Map<String, Object>> result = this.commonDao.queryByQueryFilter(this.convert2IPage(pageBean), sql, (Wrapper<Map<String, Object>>)this.convert2Wrapper(queryFilter, null));
        return new PageList<Map<String, Object>>(result);
    }

    @Override
    public PageList<Map<String, Object>> queryByCustomSql(String sql, QueryFilter<?> queryFilter) throws SystemException {
        Assert.notNull((Object)sql, (String)"sql can not be empty.");
        Assert.notNull(queryFilter, (String)"queryFilter can not be empty.");
        PageBean pageBean = queryFilter.getPageBean();
        IPage<Map<String, Object>> result = this.commonDao.queryByCustomSql(this.convert2IPage(pageBean), sql, (Wrapper<Map<String, Object>>)this.convert2Wrapper(queryFilter, null));
        return new PageList<Map<String, Object>>(result);
    }
}

