/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.service.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.model.MessageConfig;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.service.TemplateService;
import com.artfess.base.exception.NotFoundException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.jms.Notice;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private Log logger = LogFactory.getLog(TemplateServiceImpl.class);
    @Resource
    FreeMarkerEngine freeMarkerEngine;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public void sendNotice2Jms(Notice notice) {
        this.jmsProducer.sendToQueue((Object)notice);
    }

    @Override
    public void sendNotice(Notice notice) {
        ArrayNode users;
        if (BeanUtils.isEmpty((Object)notice)) {
            throw new RequiredException("The args 'Notice' is required.");
        }
        NoticeMessageType[] messageTypes = notice.getMessageTypes();
        if (messageTypes.length == 0) {
            throw new RequiredException("The 'messageTypes' in 'Notice' is required.");
        }
        ArrayList<JmsActor> receiver = notice.getReceiver();
        if (BeanUtils.isEmpty((Object)receiver) && BeanUtils.isNotEmpty((Object)notice.getReceivers()) && BeanUtils.isNotEmpty((Object)(users = this.ucFeignService.getUserByAccounts(StringUtils.join((Object[])notice.getReceivers(), (String)","))))) {
            receiver = new ArrayList<JmsActor>();
            for (JsonNode j : users) {
                JmsActor actor = this.convertUserObject2JmsActor(j);
                if (!BeanUtils.isNotEmpty((Object)actor)) continue;
                receiver.add(actor);
            }
        }
        if (receiver.size() == 0) {
            throw new RequiredException("The 'receivers' in 'Notice' is required.");
        }
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        String templateKey = notice.getTemplateKey();
        String templateType = notice.getTemplateType();
        if (notice.isUseTemplate() && StringUtil.isEmpty((String)templateKey) && StringUtil.isEmpty((String)templateType)) {
            throw new RequiredException("Nor the 'templateKey' and the 'templateType' is empty, so we can not find out the template to send with.");
        }
        JsonNode sender = null;
        String senderAccount = notice.getSender();
        if (StringUtil.isNotEmpty((String)senderAccount)) {
            sender = this.ucFeignService.loadUserByUsername(senderAccount);
        }
        String subject = notice.getSubject();
        String content = notice.getContent();
        String plainContent = "";
        String templateAlias = "";
        String templateTypeKey = "";
        String smsTemplateNo = "";
        String voiceTemplateNo = "";
        if (notice.isUseTemplate()) {
            MsgTemplate templateVo = null;
            if (StringUtil.isNotEmpty((String)templateKey)) {
                templateVo = this.getTemplate(templateKey);
                if (BeanUtils.isEmpty((Object)((Object)templateVo))) {
                    throw new NotFoundException(String.format("The is no template key was '%s'.", templateKey));
                }
            } else {
                templateVo = this.getDefaultTemplate(templateType);
                if (BeanUtils.isEmpty((Object)((Object)templateVo))) {
                    throw new NotFoundException(String.format("The is no default template for type: '%s'.", templateType));
                }
            }
            Map vars = notice.getVars();
            subject = this.parseSubject(templateVo, vars);
            content = this.parseHtmlContent(templateVo, vars);
            plainContent = this.parsePlainContent(templateVo, vars);
            templateAlias = templateVo.getKey();
            templateTypeKey = templateVo.getTypeKey();
            if (StringUtil.isNotEmpty((String)templateVo.getSmsTemplateNo())) {
                smsTemplateNo = templateVo.getSmsTemplateNo();
            }
            if (StringUtil.isNotEmpty((String)templateVo.getVoiceTemplateNo())) {
                voiceTemplateNo = templateVo.getVoiceTemplateNo();
            }
        }
        for (NoticeMessageType type : messageTypes) {
            JmsMessage jmsMessage = null;
            jmsMessage = type.isPlain() != false && notice.isUseTemplate() ? new JmsMessage(templateAlias, subject, plainContent, this.convertUserObject2JmsActor(sender), receiver, type.key(), templateTypeKey) : new JmsMessage(templateAlias, subject, content, this.convertUserObject2JmsActor(sender), receiver, type.key(), templateTypeKey);
            if (StringUtil.isNotEmpty((String)smsTemplateNo)) {
                jmsMessage.setSmsTemplateNo(smsTemplateNo);
            }
            if (StringUtil.isNotEmpty((String)voiceTemplateNo)) {
                jmsMessage.setVoiceTemplateNo(voiceTemplateNo);
            }
            jmsMessage.setExtendVars(notice.getVars());
            jmsProducer.sendToQueue((Object)jmsMessage);
        }
    }

    @Override
    public void sendToQueueByMessageConfig(Notice notice, MessageConfig messageConfig) {
        if (BeanUtils.isEmpty((Object)((Object)messageConfig))) {
            throw new NotFoundException("Message config cannot be empty\uff01");
        }
        if (BeanUtils.isEmpty((Object)((Object)messageConfig))) {
            throw new NotFoundException("Notice cannot be empty\uff01");
        }
        MsgTemplate template = this.getTemplate(messageConfig.getTplKey());
        if (messageConfig.getUserConfigType() == 2) {
            String userIds = messageConfig.getUserId();
            String orgIds = messageConfig.getOrgId();
            if (null != template && (StringUtils.isNotBlank((CharSequence)userIds) || StringUtils.isNotBlank((CharSequence)orgIds))) {
                notice.setReceivers(this.getUserList(userIds, orgIds));
            }
        }
        notice.setTemplateKey(messageConfig.getTplKey());
        notice.setUseTemplate(true);
        String notifyType = messageConfig.getNotifyType();
        String[] splitNotify = notifyType.split(",");
        NoticeMessageType[] noticeMessageTypes = new NoticeMessageType[splitNotify.length];
        int j = splitNotify.length;
        for (int i = 0; i < j; ++i) {
            noticeMessageTypes[i] = NoticeMessageType.valueOf((String)splitNotify[i].toUpperCase());
        }
        notice.setMessageTypes(noticeMessageTypes);
        this.sendNotice(notice);
    }

    public String[] getUserList(String userIds, String orgIds) {
        List listByOrg;
        ArrayList userList = new ArrayList();
        IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
        List listByUser = userService.getUserByIds(userIds);
        if (null != listByUser && listByUser.size() > 0) {
            userList.addAll(listByUser);
        }
        if (null != (listByOrg = userService.getUserListByGroups("org", orgIds)) && listByOrg.size() > 0) {
            userList.addAll(listByOrg);
        }
        String[] accounts = new String[userList.size()];
        int j = userList.size();
        for (int i = 0; i < j; ++i) {
            IUser iUser = (IUser)userList.get(i);
            accounts[i] = iUser.getAccount();
        }
        return accounts;
    }

    @Override
    public MsgTemplate getTemplate(String templateKey) {
        MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(templateKey);
        return msgTemplate;
    }

    @Override
    public MsgTemplate getDefaultTemplate(String typeKey) {
        MsgTemplate msgTemplate = this.msgTemplateManager.getDefault(typeKey.toLowerCase());
        if (msgTemplate == null) {
            throw new RuntimeException("There is not a default msgTemplate in table.");
        }
        return msgTemplate;
    }

    @Override
    public String parseSubject(MsgTemplate templateVo, Map<String, Object> vars) {
        String subject = "";
        try {
            subject = this.freeMarkerEngine.parseByTemplate(templateVo.getSubject(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return subject;
    }

    @Override
    public String parsePlainContent(MsgTemplate templateVo, Map<String, Object> vars) {
        String content = "";
        try {
            content = this.freeMarkerEngine.parseByTemplate(templateVo.getPlain(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return content;
    }

    public JmsActor convertUserObject2JmsActor(JsonNode jsonNode) {
        if (BeanUtils.isEmpty((Object)jsonNode) || !jsonNode.isObject()) {
            return null;
        }
        ObjectNode userNode = (ObjectNode)jsonNode;
        String userId = JsonUtil.getString((JsonNode)userNode, (String)"userId");
        if (StringUtil.isEmpty((String)userId)) {
            userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
        }
        String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
        String fullname = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
        String email = JsonUtil.getString((JsonNode)userNode, (String)"email");
        String mobile = JsonUtil.getString((JsonNode)userNode, (String)"mobile");
        String weixin = JsonUtil.getString((JsonNode)userNode, (String)"weixin");
        String clientId = JsonUtil.getString((JsonNode)userNode, (String)"clientId");
        String clientToken = JsonUtil.getString((JsonNode)userNode, (String)"clientToken");
        return new JmsActor(userId, account, fullname, email, mobile, weixin, clientId, clientToken);
    }

    @Override
    public String parseHtmlContent(MsgTemplate templateVo, Map<String, Object> vars) {
        String content = "";
        try {
            content = this.freeMarkerEngine.parseByTemplate(templateVo.getHtml(), vars);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e.getMessage());
        }
        return content;
    }
}

